
#include "cwdaemon.h"

/* for serial port */
#define RBR(iobase) (iobase+0)
#define THR(iobase) (iobase+0)
#define IER(iobase) (iobase+1)
#define IIR(iobase) (iobase+2)
#define FCR(iobase) (iobase+2)
#define LCR(iobase) (iobase+3)
#define MCR(iobase) (iobase+4)
#define LSR(iobase) (iobase+5)
#define MSR(iobase) (iobase+6)
#define SCR(iobase) (iobase+7)
#define DLL(iobase) (iobase+0)
#define DLM(iobase) (iobase+1)

#define DTR 1
#define RTS 2
static unsigned char mcr_reg;

/* ttyS functions */

int ttys_init(cwdevice *dev)
{
  if (ioperm (dev->base, 8, 1) == -1)
    {
      errmsg ("Open ttys port 0x%x, %d", dev->base, dev->base);
      exit (1);
    }

  mcr_reg=0;
  dev->reset(dev);
  return 0;
}

int ttys_free(cwdevice *dev)
{
  dev->reset(dev);

  if (ioperm (dev->base, 8, 0) == -1)
    errmsg ("Close ttys port 0x%x, %d", dev->base, dev->base);

  return 0;
}

int ttys_reset(cwdevice *dev)
{
  ttys_cw_off(dev);
  ttys_ptt_off(dev);
}


/* CW keying - bit1 (pin 4 for DB-9) */
int ttys_cw_on(cwdevice *dev)
{
  mcr_reg |= DTR;
  outb (mcr_reg, MCR(dev->base));
  return 0;
}

int ttys_cw_off(cwdevice *dev)
{
  mcr_reg &= ~DTR;
  outb (mcr_reg, MCR(dev->base));
  return 0;
}

/* SSB PTT keying - 0 bit (pin 7 for DB-9) */
int ttys_ptt_on(cwdevice *dev)
{
  mcr_reg |= RTS;
  outb (mcr_reg, MCR(dev->base));
  return 0;
}

int ttys_ptt_off(cwdevice *dev)
{
  mcr_reg &= ~RTS;
  outb (mcr_reg, MCR(dev->base));
  return 0;
}



