#include "MethodCallBase.h"

#include "smoke.h"
#include "smokephp.h"

Marshall::HandlerFn getMarshallFn(const SmokeType &type);

MethodCallBase::MethodCallBase(Smoke *smoke, const Smoke::Index meth, zval **sp) :
	_smoke(smoke), _method(meth), _cur(-1), _called(false), _sp(sp)
{
}

MethodCallBase::MethodCallBase(Smoke *smoke, const Smoke::Index meth, const Smoke::Stack stack, zval** sp) :
	_smoke(smoke), _method(meth), _stack(stack), _cur(-1), _called(false), _sp(sp)
{
}

MethodCallBase::MethodCallBase(Smoke *smoke, const Smoke::Stack stack, zval** sp) :
	_smoke(smoke), _method(0), _stack(stack), _cur(-1), _called(false), _sp(sp)
{
}
/*
MethodCallBase::~MethodCallBase()
{
}
*/
Smoke *
MethodCallBase::smoke()
{
	return _smoke;
}

SmokeType
MethodCallBase::type()
{
	return SmokeType(_smoke, _args[_cur]);
}

Smoke::StackItem &
MethodCallBase::item()
{
	return _stack[_cur + 1];
}

const Smoke::Method &
MethodCallBase::method()
{
	return _smoke->methods[_method];
}

void
MethodCallBase::next()
{
	const int oldcur = _cur;
	_cur++;
	while(!_called && _cur < items() ) {
		Marshall::HandlerFn fn = getMarshallFn(type());
		(*fn)(this);
		_cur++;
	}
	callMethod();
	_cur = oldcur;
}

void
MethodCallBase::unsupported()
{
	php_error(E_ERROR, "Cannot handle '%s' as argument of %s::%s",
		type().name(),
		_smoke->className(method().classId),
		_smoke->methodNames[method().name]);
}
