/***************************************************************************
                          knetworkconfigparser.h  -  description
                             -------------------
    begin                : Mon Jan 13 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKCONFIGPARSER_H
#define KNETWORKCONFIGPARSER_H

#define BACKEND_PATH "knetworkconf/backends/network-conf"
#define ETHERNET_IFACE_TYPE "ethernet"
#define WIRELESS_IFACE_TYPE "wireless"
#define LOOPBACK_IFACE_TYPE "loopback"


#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>

#include <kmessagebox.h>
#include <klocale.h>
#include <qobject.h>

#include <q3process.h>
#include <qdom.h>
#include <QCheckBox>
//Added by qt3to4:
#include <Q3PtrList>

#include <kconfig.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "knetworkinfo.h"
#include "ui_kdetectdistrodlg.h"
#include "ui_kinterfaceupdowndlg.h"
#include "ui_kselectdistrodlg.h"


class KDetectDistroDlg : public QDialog, public Ui::KDetectDistroDlg
{
public:
  KDetectDistroDlg( QWidget *parent ) : QDialog( parent ) {
    setupUi( this );
  }
};

class KInterfaceUpDownDlg : public QWidget, public Ui::KInterfaceUpDownDlg
{
public:
  KInterfaceUpDownDlg( QWidget *parent ) : QWidget( parent ) {
    setupUi( this );
  }
};

class KSelectDistroDlg : public QWidget, public Ui::KSelectDistroDlg
{
public:
  KSelectDistroDlg( QWidget *parent ) : QWidget( parent ) {
    setupUi( parent );
  }
};

/**
  *@author Juan Luis Baptiste
  */

class KNetworkConfigParser : public QObject {
  Q_OBJECT
  public:
    KNetworkConfigParser();
    ~KNetworkConfigParser();
    /** return tyhe number of configured devices. */
    unsigned numDevices() const;
    void setProgramVersion(const QString &ver);
    /** Reads /proc/net/route looking for the default gateway. */
    void loadRoutingInfo(KRoutingInfo *routingInfo);
    /** Saves the new network configuration. */
    void saveNetworkInfo(KNetworkInfo *networkInfo);
    /** Loads the network info from a xml file generated by the gnome system tools
        network backends that are included with this app. */
    KNetworkInfo * getNetworkInfo();
    Q3Process * proc;
    Q3Process * procDetect;
    Q3Process * procSaveNetworkInfo;
    /** Variable to know if there is an dhcp device configured, so we can know if we need to save the defauilt gw info or not. */
    bool dhcpDevice;
    KNetworkInterface * getDeviceInfo(QString device);


  public slots:
    /** runs gst to find out the state of network devices.It runs the command:
    $knetworkconf_home/backends/networkconf [--platform platform] -d list_ifaces */
    void listIfaces(const QString &platform);

  private slots:
   /** Runs the gst backend to get network values. You can pass to the script a specific platform to load using the platform parameter.  */
    void runDetectionScript(QString platform);
    void readIfconfigOutput();
    void readNetworkInfo();
    void readFromStdoutReloadScript();
    /** emits a signal when the network changes have benn saved. */
    void sendNetworkInfoSavedSignalSlot();
    /** Concatenates into a QString the xml output of the network backend. */
    void concatXMLOutputSlot();
    void readXMLErrSlot();
    /** Shows the dialog with all the supported platforms by GST. */
    void showSupportedPlatformsDialogSlot();
    /** Parses the xml output generated by GST that has all the supported platforms. */
    void readSupportedPlatformsSlot();
    /** No descriptions */
    void readListIfacesSlot();
    void readFromStdoutSaveNetworkInfo();
    /** Calls runDetectionScript(). */
    void listIfacesSlot();

  private:
    //QPtrList<KNetworkInterface> deviceList;
    Q3PtrList<KNetworkInterface>  tempList;
    KNetworkInterface *newDevice;
    bool isUp;
    /** Counts the number of configured devices that had been found. */
    unsigned _numDevices;
    KRoutingInfo *routingInfo;
    KDNSInfo *dnsInfo;
    QString programVersion;
    /**  The output of ifconfig command that needs to be parsed in readIfconfigOutput()*/
    QString ifconfigOutput;
    KNetworkInfo * networkInfo;
    Q3PtrList<KKnownHostInfo> knownHostsList;
    QString hexIPv4ToDecIPv4(const QString &hex);
    /** lists all platforms supported by GST. */
    void loadSupportedPlatforms();
    /** Returns the info of a platform in the form of 'key:value' . */
    QString getPlatformInfo(QDomElement platform);

    /** Shows a progress dialog while the networl is being reloaded. */
    KInterfaceUpDownDlg * kpdReloadStatusDlg;
    Q3Process *procReloadNetwork;
    QString reloadScriptOutput;
    /** Contains the network configuration en xml format. */
    /** List of supported platforms. */
    QStringList supportedPlatformsList;
    QString xmlOuput;
    QString xmlErr;
    /** Temporal device list to be used when loading the dhcp devices info */
    Q3PtrList<KNetworkInterface> tempDevList;
    /** Parses all of the <statichost>...</statichost> entries in the xml configuration file. */
    KKnownHostInfo * getStaticHostInfo(QDomElement host);
    /** Saves the option to show again or not the platform using KConfig*/
    void saveAskAgain(const QString &platform, bool askAgain);
    /**Returns if the show platform should be shown again or not and the saved platform*/
    bool readAskAgain(QString &platform);
    void parseNetworkInfo(QDomNode node, KNetworkInfo *networkInfo, bool isProfile);
    void addRoutingInfoToXMLDoc(QDomDocument *doc, QDomNode *root, KRoutingInfo *routingInfo);
    void addDNSInfoToXMLDoc(QDomDocument *doc, QDomNode *root, KDNSInfo *dnsInfo);
    void addNetworkInterfacesToXMLDoc(QDomDocument *doc, QDomNode *root, Q3PtrList<KNetworkInterface> devList);
    void addNetworkProfilesToXMLDoc(QDomDocument *doc, QDomNode *root, Q3PtrList<KNetworkInfo> profileList);

  protected: // Protected methods
    /** Parses all of the <interface>...</interface> entries in the xml configuration file. */
    virtual KNetworkInterface *getInterfaceInfo(QDomElement interface, const QString &type);
    /** Parses all of the <interface>...</interface> entries in the xml configuration file. Returns a KWirelessInterface
    object that contains all the info of the wireless interface. */
    virtual KWirelessInterface *getWirelessInterfaceInfo(QDomElement interface, const QString &type);

  signals: // Signals
    /** emmited when the xml file is finished reading. */
    void readyLoadingNetworkInfo();

    /** emmited when the xml file saved and the backend has finished executing. */
//    void readySavingNetworkInfo();

    /** Signal that is sent when fillDevices() has finished fllind the dhcp devices. */
    void readyIfconfigOutputSignal();
    /** Signal emmited when the platform can't be auto-detected. */
    void errorDetectingPlatform();
    /** signal emmited when the parsing of the xml of the supported platform list. */
    void readyLoadingSupportedPlatforms();
    /** signal emmited when the config parser needs to set read only the GUI because
        some error in the parsing, or the platform isn't supported.*/
    void setReadOnly(bool);
};

#endif
