//Auto-generated by kalyptus. DO NOT EDIT.
namespace Phonon {
    using Phonon;
    using System;
    using Qyoto;
    /// <remarks> \class VolumeFaderEffect volumefadereffect.h Phonon/VolumeFaderEffect
    ///  Audio effect to gradually fade the audio volume.
    ///  This effect differs from gradually changing the output volume in that
    ///  a dedicated effect can change the volume in the smallest possible
    ///  steps while every other volume control will make more or less
    ///  noticeable steps.
    ///  \ingroup PhononEffects
    ///  \author Matthias Kretz <kretz@kde.org>
    ///  \see AudioOutput.Volume
    ///      </remarks>        <short>   \class VolumeFaderEffect volumefadereffect.</short>
    [SmokeClass("Phonon::VolumeFaderEffect")]
    public class VolumeFaderEffect : Phonon.Effect, IDisposable {
        protected VolumeFaderEffect(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(VolumeFaderEffect), this);
        }
        // FadeCurve fadeCurve(); >>>> NOT CONVERTED
        // void setFadeCurve(FadeCurve arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  "Crossfade curve" / "fast" fade out
        ///  Often the best fade for a crossfade, as after half of the
        ///  time the volume reached -3dB. This means that half the
        ///  possible power (which is proportional to the square of the
        ///  voltage) is reached. Summed, the maximum power of two audio
        ///  signals fading with a -3dB curve will always be equal.
        ///  For fading in or out the -3dB curve is too abrupt in the end.
        ///  This is the default fade curve.
        ///                  </remarks>        <short>    "Crossfade curve" / "fast" fade out </short>
        public float Volume() {
            return (float) interceptor.Invoke("volume", "volume() const", typeof(float));
        }
        public double VolumeDecibel() {
            return (double) interceptor.Invoke("volumeDecibel", "volumeDecibel() const", typeof(double));
        }
        public VolumeFaderEffect() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("VolumeFaderEffect", "VolumeFaderEffect()", typeof(void));
        }
        /// <remarks>
        ///  Tells the Fader to change the volume from the current volume to 100%
        ///  in <pre>fadeTime</pre> milliseconds.
        ///  Short for <code>fadeTo</code>(1.0, fadeTime).
        ///  \param fadeTime the fade duration in milliseconds
        ///  \see fadeTo
        ///  \see volume
        ///              </remarks>        <short>    Tells the Fader to change the volume from the current volume to 100%  in \p fadeTime milliseconds.</short>
        [Q_SLOT("void fadeIn(int)")]
        public void FadeIn(int fadeTime) {
            interceptor.Invoke("fadeIn$", "fadeIn(int)", typeof(void), typeof(int), fadeTime);
        }
        /// <remarks>
        ///  Tells the Fader to change the volume from the current volume to 0%
        ///  in <pre>fadeTime</pre> milliseconds.
        ///  Short for <code>fadeTo</code>(0.0, fadeTime).
        ///  \param fadeTime the fade duration in milliseconds
        ///  \see fadeTo
        ///              </remarks>        <short>    Tells the Fader to change the volume from the current volume to 0%  in \p fadeTime milliseconds.</short>
        [Q_SLOT("void fadeOut(int)")]
        public void FadeOut(int fadeTime) {
            interceptor.Invoke("fadeOut$", "fadeOut(int)", typeof(void), typeof(int), fadeTime);
        }
        [Q_SLOT("void setVolume(float)")]
        public void SetVolume(float volume) {
            interceptor.Invoke("setVolume$", "setVolume(float)", typeof(void), typeof(float), volume);
        }
        [Q_SLOT("void setVolumeDecibel(double)")]
        public void SetVolumeDecibel(double volumeDecibel) {
            interceptor.Invoke("setVolumeDecibel$", "setVolumeDecibel(double)", typeof(void), typeof(double), volumeDecibel);
        }
        /// <remarks>
        ///  Tells the Fader to change the volume from the current value to
        ///  <pre>volume</pre> in <pre>fadeTime</pre> milliseconds
        ///  \see fadeIn
        ///  \see fadeOut
        ///              </remarks>        <short>    Tells the Fader to change the volume from the current value to  \p volume in \p fadeTime milliseconds </short>
        [Q_SLOT("void fadeTo(float, int)")]
        public void FadeTo(float volume, int fadeTime) {
            interceptor.Invoke("fadeTo$$", "fadeTo(float, int)", typeof(void), typeof(float), volume, typeof(int), fadeTime);
        }
        ~VolumeFaderEffect() {
            interceptor.Invoke("~VolumeFaderEffect", "~VolumeFaderEffect()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~VolumeFaderEffect", "~VolumeFaderEffect()", typeof(void));
        }
        protected new IVolumeFaderEffectSignals Emit {
            get { return (IVolumeFaderEffectSignals) Q_EMIT; }
        }
    }

    public interface IVolumeFaderEffectSignals : Phonon.IEffectSignals {
    }
}
