/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.ExtensionElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension
extends UnaryTupleOperator {
    private List<ExtensionElem> elements = new ArrayList<ExtensionElem>();

    public Extension() {
    }

    public Extension(TupleExpr arg) {
        super(arg);
    }

    public Extension(TupleExpr arg, ExtensionElem ... elements) {
        this(arg);
        this.addElements(elements);
    }

    public Extension(TupleExpr arg, Iterable<ExtensionElem> elements) {
        this(arg);
        this.addElements(elements);
    }

    public List<ExtensionElem> getElements() {
        return this.elements;
    }

    public void setElements(Iterable<ExtensionElem> elements) {
        this.elements.clear();
        this.addElements(elements);
    }

    public void addElements(ExtensionElem ... elements) {
        for (ExtensionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElements(Iterable<ExtensionElem> elements) {
        for (ExtensionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElement(ExtensionElem pe) {
        this.elements.add(pe);
        pe.setParentNode(this);
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(this.arg.getBindingNames());
        for (ExtensionElem pe : this.elements) {
            bindingNames.add(pe.getName());
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ExtensionElem elem : this.elements) {
            elem.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int index = this.elements.indexOf(current);
        if (index >= 0) {
            this.elements.set(index, (ExtensionElem)replacement);
            replacement.setParentNode(this);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public Extension clone() {
        Extension clone = (Extension)super.clone();
        clone.elements = new ArrayList<ExtensionElem>(this.getElements().size());
        for (ExtensionElem elem : this.getElements()) {
            clone.addElement(elem.clone());
        }
        return clone;
    }
}

