/* info.c: PnP config tool device info view handler module */
/*
 * $Header: /root/pnp/tools/RCS/info.c,v 1.1 1996/06/24 23:31:22 root Exp $
 *
 * $Log: info.c,v $
 * Revision 1.1  1996/06/24  23:31:22  root
 * Initial revision
 *
 *
 */

/*
 * (c) Copyright 1996  D.W.Howells <dwh@nexor.co.uk>,
 */

#include <signal.h>
#include "tools.h"

/*****************************************************************************/
/* display information */
void info_display()
{
    struct pnp_index *ix;
    u_char sh, skip;
    int loop, line;

    ix = index_list[index_current];

    /* index info */
    wattrset(workwin,COLOR_PAIR(2));
    mvwprintw(workwin,0,0,"interface: %s",ix->pi_interface);wclrtoeol(workwin);
    mvwprintw(workwin,1,0,"      csn: %02x",ix->pi_csn);    wclrtoeol(workwin);
    mvwprintw(workwin,2,0,"      dev: %02x",ix->pi_dev);    wclrtoeol(workwin);
    mvwprintw(workwin,3,0,"    ident: %s",ix->pi_ident);    wclrtoeol(workwin);
    mvwprintw(workwin,4,0,"   driver: %s",ix->pi_driver);   wclrtoeol(workwin);
    mvwprintw(workwin,5,0,"     data: %s",ix->pi_data);     wclrtoeol(workwin);
    mvwprintw(workwin,6,0,"   device: %s",
	      ix->pi_device?ix->pi_device->pd_desc:"unknown");
    wclrtoeol(workwin);

    wmove(workwin,8,0);
    wprintw(workwin,"current config:\n");
    wclrtobot(workwin);
    line = 9;

    /* current irq config */
    sh = 0x01;
    skip = 1;
    for (loop=0; loop<2; loop++) {
	if (ix->pi_ioc.pioc.config.pc_s.irq&sh) {
	    wattrset(workwin,COLOR_PAIR(2));
	    mvwprintw(workwin,line,20*loop,"irq%d: ",loop);
	    wattrset(workwin,COLOR_PAIR(6)|A_BOLD);
	    wprintw(workwin,"%d ",ix->pi_ioc.pioc.config.pc_irq[loop].num);
	    if (ix->pi_device && ix->pi_device->pd_irq[loop]) {
		wattrset(workwin,COLOR_PAIR(4));
		wprintw(workwin,"%-8s",ix->pi_device->pd_irq[loop]);
	    }
	    skip = 0;
	}
	sh <<= 1;
    }
    if (!skip) {
	line++;
    }

    /* current dma config */
    sh = 0x01;
    skip = 1;
    for (loop=0; loop<2; loop++) {
	if (ix->pi_ioc.pioc.config.pc_s.dma&sh) {
	    wattrset(workwin,COLOR_PAIR(2));
	    mvwprintw(workwin,line,20*loop,"dma%d: ",loop);
	    wattrset(workwin,COLOR_PAIR(6)|A_BOLD);
	    wprintw(workwin,"%d ",ix->pi_ioc.pioc.config.pc_dma[loop].chan);
	    if (ix->pi_device && ix->pi_device->pd_dma[loop]) {
		wattrset(workwin,COLOR_PAIR(4));
		wprintw(workwin,"%-8s",ix->pi_device->pd_dma[loop]);
	    }
	    skip = 0;
	}
	sh <<= 1;
    }
    if (!skip) {
	line++;
    }

    /* current io config */
    sh = 0x01;
    skip = 1;
    for (loop=0; loop<7; loop++) {
	if (loop%3==0 && !skip)
	    line++;

	if (ix->pi_ioc.pioc.config.pc_s.io&sh) {
	    wattrset(workwin,COLOR_PAIR(2));
	    mvwprintw(workwin,line,20*(loop%3),"io%d: ",loop);
	    wattrset(workwin,COLOR_PAIR(6)|A_BOLD);
	    wprintw(workwin,"%04x",ix->pi_ioc.pioc.config.pc_io[loop].base);
	    if (ix->pi_device && ix->pi_device->pd_io[loop]) {
		wattrset(workwin,COLOR_PAIR(4));
		wprintw(workwin," %-8s",ix->pi_device->pd_io[loop]);
	    }
	    skip = 0;
	}
	sh <<= 1;
    }
    if (!skip) {
	line++;
    }

    /* current mem config */
    sh = 0x01;
    for (loop=0; loop<7; loop++) {
	if (ix->pi_ioc.pioc.config.pc_s.mem&sh) {
	    const char *mtype[] = { "8-bit", "16-bit", "????", "32-bit" };
	    wattrset(workwin,COLOR_PAIR(2));
	    mvwprintw(workwin,line,0,"mem%d: ",loop);
	    wattrset(workwin,COLOR_PAIR(6)|A_BOLD);
	    wprintw(workwin,"%08x-%08x %s",
		    ix->pi_ioc.pioc.config.pc_mem[loop].base,
		    ix->pi_ioc.pioc.config.pc_mem[loop].top,
		    mtype[ix->pi_ioc.pioc.config.pc_mem[loop].type&0x03]
		    );
	    if (ix->pi_device && ix->pi_device->pd_mem[loop]) {
		wattrset(workwin,COLOR_PAIR(4));
		wprintw(workwin," %-8s",ix->pi_device->pd_mem[loop]);
	    }
	    line++;
	}
	sh <<= 1;
    }

    touchwin(vworkwin);
    wrefresh(vworkwin);
    wrefresh(workwin);

} /* end info_display() */
