.\" FIG : Facility for Interactive Generation of figures
.\" Copyright (c) 1985 by Supoj Sutanthavibul
.\" Parts Copyright (c) 1994 by Brian V. Smith
.\" Parts Copyright (c) 1991 by Paul King
.\" The X Consortium, and any party obtaining a copy of these files from
.\" the X Consortium, directly or indirectly, is granted, free of charge, a
.\" full and unrestricted irrevocable, world-wide, paid up, royalty-free,
.\" nonexclusive right and license to deal in this software and
.\" documentation files (the "Software"), including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons who receive
.\" copies from any such party to do so, with the only requirement being
.\" that this copyright notice remain intact.  This license includes without
.\" limitation a license to do the foregoing actions under any patents of
.\" the party supplying this software to the X Consortium.
.\"-------
.\" Man page portability notes
.\"
.\" These are some notes on conventions to maintain for greatest
.\" portability of this man page to various other versions of
.\" nroff.
.\"
.\" When you want a \ to appear in the output, use \e in the man page.
.\"
.\" Evidently not all versions of nroff allow the omission of the
.\" terminal " on a macro argument.  Thus what could be written
.\"
.\" .B "bold stuff
.\"
.\" in true nroffs must be written
.\"
.\" .B "bold stuff"
.\"
.\" instead.
.\"
.\" Use symbolic font names (e.g. R, I, B) instead of the standard
.\" font positions 1, 2, 3.  Ideally, do not use \f at all to change
.\" fonts (there are none in this man page at this writing).  Use the
.\" -man macros instead, that's what they are there for and they are
.\" more readable to boot.
.\"
.\" Note that sentences should end at the end of a line.  nroff and
.\" troff will supply the correct intersentence spacing, but only if
.\" the sentences end at the end of a line.  Explicit spaces, if given,
.\" are apparently honored and the normal intersentence spacing is
.\" supressed.
.\"
.\" DaviD W. Sanderson
.\"-------
.\"-------
.\" xfig.1 conventions:
.\"
.\"	bold:	file names
.\"		command-line switches
.\"
.\"	italic:	variables (including environment variables)
.\"		program names
.\"		machine names
.\"
.\"-------
.if t .po .9i
.nh
.\"-------
.\" Dd	distance to space vertically before a "display"
.\" These are what n/troff use for interparagraph distance
.\"-------
.if t .nr Dd .4v
.if n .nr Dd 1v
.\"-------
.\" Sp	space down by the interparagraph distance
.\"-------
.de Sp
.sp \\n(Ddu
..
.\"-------
.\" At - argument tag
.\" Begin an argument tag for an argument description paragraph.
.\"-------
.de At
.PP
..
.\"-------
.\" Ap - argument description paragraph
.\" It's an indented paragraph starting immediately after the
.\" preceeding text (with no intervening blank line).
.\" The reason for having this is so that we can construct the
.\" ``tag'' for the paragraph (which describes a command argument)
.\" using more than one line of -man macros.  The regular .TP
.\" macro only allows the tag to occupy one line in the source file,
.\" which can often force explicit font changes using troff mechanisms
.\" which make the source harder to read.
.\"-------
.de Ap
.PD 0
.IP
.PD
..
.\"-------
.TH XFIG 1 "Release 3.1(.4) (Protocol 3.1)"
.SH NAME
xfig - Facility for Interactive Generation of figures under X11
.SH SYNOPSIS
.B xfig
.RI [ options ]
.RI [ file ]
.SH DESCRIPTION
.I Xfig
is a menu-driven tool that allows the user to draw and manipulate
objects interactively under the X Window System.
.B It runs under X version 11
.B release 4 or higher
and requires a two- or three-button mouse.
.I file
specifies the name of a file to be edited.
The description of objects in the file will be read at the start of
.IR xfig .
.PP
When using a two-button mouse use the
.I <Meta>
key and the right button at the same time to effect
the action of the middle button.
.PP
.I Xfig
is available via anonymous ftp from
.I ftp.x.org
in
.BI /contrib/applications/drawing_tools/xfig .
.PP
The
.I TransFig
package is used when printing or exporting the output from
.IR xfig .
It is automatically called by
.IR xfig
as a back-end processor to produce various types of output:
.nr n \w'PostScript\0\0\0\0'+1n-1/1n
.IP LaTeX \nn
.I "fig2dev \-L latex"
translates
.I xfig
to
.I LaTeX
picture environment commands which can be processed along with other
.I LaTeX
commands.
.IP Metafont
.I "fig2dev \-L mf"
produces
.I Metafont
output.
.IP PostScript
.I "fig2dev \-L ps"
produces an
.I "Encapsulated PostScript"
output.
.IP IBM-GL
.I "fig2dev \-L ibmgl"
produces a
.I IBM-GL (HP/GL)
output.
.IP Pic
.I "fig2dev \-L pic"
produces a
.I pic
output.
.IP PiCTeX
.I "fig2dev \-L pictex"
produces
.I PiCTeX
output.
This contains macros that can be used with the
.I PiCTeX
environment under
.I TeX
or
.I LaTeX.
.IP Others
.I fig2dev
has options for these other languages:
.IR box ,
.IR epic ,
.IR eepic ,
and
.IR eepicemu .
.PP
The
.I TransFig
package is available via anonymous ftp from
.I ftp.x.org
in
.BI /contrib/applications/drawing_tools/transfig .
.SH OPTIONS
.\"-------
.At
.BR \-help
.Ap
Print all command-line options for xfig and quit.
.At
.BR \-L [ andscape ]
.Ap
Make
.I xfig
come up in landscape mode (10.5" x 8").
This is the default; however as the orientation is stored with Fig files,
when you load a Fig file the orientation will change as required.
This is only true for files of version 3.0 or higher.
.\"-------
.At
.BR \-P [ ortrait ]
.Ap
Make
.I xfig
come up in portrait mode (8.5" x 9").  See note about landscape mode.
.\"-------
.At
.BI \-bg " color"
.Ap
Use
.I color
as the background color for the canvas and buttons.
.\"-------
.At
.BR \-bol [ d ]
.I font
.Ap
Cause the font used for displaying the file name and
confirmation messages to be
.I font
(default = 8x13bold).
.\"-------
.At
.BR \-butt [ on ]
.I font
.Ap
Cause the font used for most buttons to be
.I font
(default = 6x13).
.\"-------
.At
.BR \-but_ [ per_row ]
.I number
.Ap
Specify the number of buttons wide the mode panel should be.
This is useful in conjunction with the
.B \-pheight
parameter to reduce the canvas height for small screens.
.\"-------
.At
.BR \-de [ bug ]
.Ap
Turn on debugging mode.
Prints various debugging messages like font names etc.
.\"-------
.At
.BR \-do [ ntswitchcmap ]
.Ap
Prevents xfig from switching to a private colormap if there aren't
enough colors available in the default colormap.  See also
.BR \-max_image_colors.
.\"-------
.At
.BR \-e [ xportLanguage ]
.I language
.Ap
Specifies the language to be used for when exporting a fig file.
Choices are:
.Sp
.\"--------------------------------------------------------------------
.\" Table Begin
.\"--------------------------------------------------------------------
.ne 17
.nf
.nr t0 \w'eepicemu\0\0\0\0'u
.ta \n(t0u
.\" set n to length of longest line
.di xx
eepicemu	LaTeX picture + eepicemu macros
.nr n \n(.nu
.di
.rm xx
.\" HEADER
Name	Language
.if n \l'\nnu\&-'
.if t \l'\nnu'
.\" DATA
box\&\&\&	LaTeX box (figure boundary)
latex\&\&	LaTeX picture
epic\&\&	LaTeX picture + epic macros
eepic\&\&	LaTeX picture + eepic macros
eepicemu	LaTeX picture + eepicemu macros
pictex\&	PiCTeX macros
ibmgl\&\&	IBMGL (or HPGL)
eps\&\&\&	Encapuslated PostScript
ps\&\&\&	PostScript
pstex\&\&	Combined PS/LaTeX (PS part)
pstex_t\&	Combined PS/LaTeX (LaTeX part)
textyl\&	Textyl special commands
tpic\&\&	TPIC
pic\&\&\&	PIC
mf\&\&\&\&	MF (MetaFont)
gif\&\&\&	GIF
jpg\&\&\&	JPEG (JFIF)
xbm\&\&\&	X11 Bitmap
xpm\&\&\&	X11 Pixmap (XPM3 package)
.if n \l'\nnu\&-'
.if t \l'\nnu'
.DT
.fi
.\"--------------------------------------------------------------------
.\" Table End
.\"--------------------------------------------------------------------
.\"-------
.At
.BI \-fg " color"
.Ap
Use
.I color
as the foreground color and default color for objects.
.\"-------
.At
.BR \-fl [ ushleft ]
.Ap
Set the print option to print the figure flush left.
The default is to center the figure on the page.
.\"-------
.At
.BR \-geom [ etry ]
.IR W x H\c
.RI + X + Y
.Ap
Specifies the geometry for Fig application.
.\"-------
.At
.BR \-iconG [ eometry ]
.RI + X + Y
.Ap
Specifies the position for the icon.
.\"-------
.At
.BR \-inc [ hes ]
.Ap
Make inches the unit of choice (default).
.\"-------
.At
.BR \-ma [ ximagecolors ]
.I numcols
.Ap
Limit the number of colors used for EPS, GIF, JPEG or XPM images to
.I numcols.
.\"-------
.At
.BR \-me [ tric ]
.Ap
Make centimeters the unit of choice.
.IP \&
After
.I xfig
is started you may change the units from metric to
imperial or vice versa from a popup menu available by pressing mouse
button 3 in the
.I units
box where the two rulers meet.
.\"-------
.At
.BI \-internalBW " width"
.Ap
Use lines of width
.I width
between all buttons and panels (default = 1).
.\"-------
.At
.BR \-inv [ erse ]
.Ap
Use inverse video (white on black).
.\"-------
.At
.BR \-k [ eyFile ]
.I compose-key-file
.Ap
Use
.I compose-key-file
instead of
.I CompKeyDB
for compose (meta) key database.
If there are no
.RB `` / ''s
in the name, the file must reside in the
.I xfig
library directory,
.IR $XFIGLIBDIR ,
usually
.BR /usr/local/lib/X11/xfig .
If there are any
.RB `` / ''s
in the name it is taken as is (not relative to
.IR $XFIGLIBDIR ).
If there is a leading
.RB `` ~/ ''
in the string then the
.RB `` ~ ''
is expanded to the user's home directory.
.\"-------
.At
.BR \-lat [ exfonts ]
.Ap
Start
.I xfig
with
.I LaTeX
font selection.
Normally, the
.I PostScript
fonts are available as the default.
This flag selects the
.I LaTeX
fonts to start.
.\"-------
.At
.BR \-le [ ft ]
.Ap
Change the position of the side panel window to the left of the canvas window.
This is the default.
.\"-------
.At
.BR \-mo [ nochrome ]
.Ap
Use black and white only.
.\"-------
.At
.BR \-nor [ mal ]
.I font
.Ap
Cause the font used for the message window to be
.IR font .
This font is also used on the canvas when the selected font is not
available in an X11 font (default = 6x13).
.\"-------
.At
.BR \-not [ rack ]
.Ap
Turn off cursor (mouse) tracking arrows.
.\"-------
.At
.BR \-ph [ eight ]
.I height
.Ap
Make the
.I xfig
canvas
.I height
high (where
.I height
is either cm or in, depending on the -metric setting).
.\"-------
.At
.BR \-pw [ idth ]
.I width
.Ap
Make the
.I xfig
canvas
.I width
wide (where
.I width
is either cm or in, depending on the -metric setting).
.\"-------
.At
.BR \-ri [ ght ]
.Ap
Change the position of the side panel window to the right of the canvas window
(default: left).
.\"-------
.At
.BR \-sc [ alablefonts ]
.Ap
Allows use of the X11R5 or OpenWindows scalable fonts (this is the default).
If the scalable fonts aren't available
.I xfig
will automatically switch to non-scaling fonts.
.\"-------
.At
.BR \-nosc [ alablefonts ]
.Ap
Disables use of the X11R5 or OpenWindows scalable fonts.
You might want to use this for debugging.
.\"-------
.At
.BR \-sh [ owallbuttons ]
.Ap
Show all the
.I xfig
indicator buttons instead of only those relevant
to the current drawing mode.
Normally, the buttons
.IR "line width" ,
.IR area-fill ,
.IR "grid mode" ,
.IR "text size" ,
etc. are only visible when
they are relevant to the current drawing mode.
The
.B \-showallbuttons
option makes all
of the indicator buttons visible at all times.
This takes up more screen real estate,
but allows the user to see all settable parameters.
.\"-------
.At
.BR \-sp [ ecialtext ]
.Ap
Start
.I xfig
with the
.I "special text"
mode for text objects.
.\"-------
.At
.BR \-startfi [ llstyle ]
.I stylenumber
.Ap
Set the starting fill style for area fill (-1 to 21).
.\"-------
.At
.BR \-startfo [ ntsize ]
.I pointsize
.Ap
Set the default font size for text objects (default = 12pt).
.\"-------
.At
.BR \-startg [ ridmode ]
.I modenumber
.Ap
Set the starting grid mode (0 to 3).  Mode 0 is no grid.
In imperial (inches) mode, grid mode 1 is 1/4 inch,
mode 2 is 1/2 inch and mode 3 is 1 inch.
In metric mode, grid mode 1 is 5mm, mode 2 is 1cm and mode 3 is 2cm.
.\"-------
.At
.BR \-startla [ texFont ]
.I font
.Ap
Set the starting font name for
.I LaTeX
fonts.
.\"-------
.At
.BR \-startt [ extstep ]
.I stepsize
.Ap
Set the starting text step.
.\"-------
.At
.BR \-startli [ newidth ]
.I width
.Ap
Set the starting line width.
.\"-------
.At
.BR \-startp [ sFont ]
.I font
.Ap
Set the starting font name for
.I PostScript
fonts.
.\"-------
.At
.BR \-ta [ blet ]
.Ap
Specifies that xfig should use the input tablet instead of the mouse
for drawing.  You must have the XInputExtension in your X server and
an input tablet for this to work.  Also, you must modify the Imakefile
to include the USETAB and TABLIB variables.
.\"-------
.At
.BR \-tr [ ack ]
.Ap
Turn on cursor (mouse) tracking arrows (default).
.\"-------
.At
.BR \-users [ cale ]
.I scale
.Ap
Set the multiplier for displayed line lengths etc.
This factor is multiplied by the actual length,
radius or diameter of the object currently
being drawn on the canvas.
It is useful for making scale drawings, where
e.g. 1 inch = 1 foot (userscale = 12.0) or 1cm = 1m (userscale = 100.0).
.\"-------
.At
.BR \-useru [ nit ]
.I units
.Ap
The
.I units
string is printed with the length information when drawing objects.
For example if the
.I userscale
= 1.0 and the
.I userunit
=
.I ft
then a line which is 3 inches long on the canvas would be displayed as
``length = 3 ft'' when it is being drawn.
.IP
After
.I xfig
is started you may change the
.I userscale
and the
.I userunit
from a popup menu available by pressing mouse button 3 in the
.I units
box where the two rulers meet.
.SH "GRAPHICAL OBJECTS"
The objects in
.I xfig
are divided into
.B "primitive objects"
and
.BR "compound objects" .
The primitive objects are:
.IR ARC ,
.IR CIRCLE ,
.IR "CLOSED SPLINE" ,
.IR ELLIPSE ,
.IR POLYLINE ,
.IR POLYGON ,
.IR PICTURE ,
.IR BOX ,
.IR ARC-BOX ,
.IR SPLINE ,
and
.IR TEXT .
.PP
A primitive object can be moved, rotated, flipped vertically or horizontally,
scaled, copied, aligned within a compound object or erased.
The
.I TEXT
primitive may not be flipped.
The attributes of any primitive object can be edited using a popup
panel (discussed below), so you can, for instance, set the position
of an object manually.
.PP
A compound object is composed of primitive objects.
The primitive objects
that constitute a compound can not be individually modified,
but they can be manipulated as an entity;
a compound can be moved, rotated, flipped
vertically or horizontally, scaled, copied or erased.
A compound that contains any boxes or arc-boxes
may only be rotated by 90 degrees.
.PP
Objects may overlap other objects according to their ``depth''.
Objects with larger depth number are obscured by objects with smaller depth.
.PP
.I Regular
polygons may be created using a special drawing mode, but a
general
.I POLYGON
is created as a result, which may then be modified, i.e.
the individual vertices may be moved if desired.
.SH "DISPLAY WINDOWS"
Ten regions comprise the display area of
.IR xfig :
the command region, top ruler, side ruler, drawing mode region,
editing mode region, filename region, message region,
mouse function indicator region and canvas region,
and indicator region with buttons to set and show current line thickness,
line style, color, area-fill gray color and several other settings.
(The mouse function indicator region was inspired by the UPS
debugger from the University of Kent.)
The drawing and editing mode regions may be placed (together) to the left or
right of the the canvas window (default: left).
.SH "COMMAND PANEL FUNCTIONS"
.TP
.I Quit
Exit from
.IR xfig ,
discarding the figure.
If the figure has been modified and
not saved, the user will be asked to
confirm the action, by clicking mouse button 1 on a confirm/cancel popup menu.
The accelerator
.I <Meta>q
will also perform this function.
This and all other accelerators are defined in the
.I app-defaults
file and may be changed if desired.
.TP
.I "Port/Land"
Change shape of xfig canvas from/to portrait/landscape.  Note:  the canvas
will automatically change to the portrait/landscape configuration
specified in Fig files of version 3.0 or higher when loading those files.
.TP
.I "Delete ALL"
Delete all objects from the canvas window (may be undone).
The accelerator
.I <Meta>d
will also perform this function.
.TP
.I Undo
Undo the last object creation, deletion or modification.
The accelerator
.I <Meta>u
will also perform this function.
If an undo of a
.I Paste
or file
.I Merge
is done, any user-defined colors in the figure pasted in or the
file just merged will NOT be undefined.
.TP
.I Redraw
Redraw the canvas.
There are also two accelerators which do a redraw \(em
.I <Meta>r
and
.I <Ctrl>l.
.TP
.I Paste
Paste the object previously copied into the cut/paste file into the current
figure (at its original position).
The accelerator
.I <Meta>t
will also perform this function.
.TP
.I File
Pressing mouse button 3 on this button invokes
.I Save
function without popping up the file panel.
Before the figure is saved the original file is first renamed with the
suffix ``.bak'' appended.  This provides a backup file.
.sp
Mouse button 1 or
.I <Meta>f
pops up a panel which contains several file-related functions:
.PP
.po +.5i
.nr LL 6i
.TP
.I "Current Filename"
This is read-only AsciiTextWidget which contains the filename that will be used
to write output to a file
.I "if there is no name specified in"
the
.I Filename
panel.
.TP
.I Filename
This is an editable AsciiTextWidget which contains the filename selected
either by clicking on a filename from the
.I Alternatives
list or by typing a name in directly.
Pressing return in the Filename window will
.I Load
the file and copy the name to the
.I "Current Filename"
widget.
.TP
.I "(File) Alternatives"
Pressing mouse button 1 on a filename in the file alternatives
window will select that file by copying the filename into
.I Filename
window.
Pressing return in this window will
.I Load
the file specified in the
.I Filename
window (if any) or the
.I "Current Filename"
widget.
.TP
.I "Filename Mask"
A wildcard mask may be typed into this editable AsciiTextWidget to restrict
the search of filenames to a subset ala the
.I ls
command.
Pressing return in this window will automatically
rescan the current directory.
This string may be set by setting the X toolkit resource
.BR Fig*file_panel*mask*string .
.TP
.I "Current Directory"
This is an editable AsciiTextWidget which shows the current directory.
It may be modified by the user to manually set a directory name.
When return is pressed in this window the directory specified is scanned for
files matching the
.IR Filenamemask ,
if any.
.IP \&
The
.B ~
(tilde) character may be used to specify a user's home directory, ala
unix shell tilde expansion.
.TP
.I "(Directory) Alternatives"
Pressing mouse button 1 on a directory name in the directory
alternatives list will do a ``change directory'' to that directory.
.IP \&
Pressing mouse button 3 in either the file or
.I "Directory Alternatives"
window will do a ``change directory'' to the parent directory.
.TP
.I "Load/Merge figure offset"
These two editable AsciiTextWidgets allow one to load or merge
a figure with an offset on the canvas.
The figure will be offset by the amounts specified (in Fig units)
in the X and Y panels.  A negative value in the X offset will shift
the figure to the left, and a negative value in the Y offset will
shift the figure up.
.TP
.I Home
Pressing this button will change the directory to the
.I $HOME
directory of the user.
.TP
.I Rescan
Pressing this button or
.I <Meta>r
will rescan the current directory.
.TP
.I Cancel
Pressing this button or
.I <Meta>c
will pop down the
.I File
panel without making any changes to the directory or file name.
.TP
.I Save
Pressing this button or
.I <Meta>s
will save the current contents of the
canvas in the file specified in the
.I Filename
window
.IR "if any" ,
or the name specified in the
.I "Current Filename"
if the former is empty.
If the file already exists a confirmation popup menu will appear
asking the user to confirm or cancel the save.
If there is a filename in the
.I Filename
window it is copied to the
.I "Current Filename"
window.
.IP \&
The current Export directory is updated to the current File directory when
Save is pressed.
.IP \&
Before the figure is saved the original file is first renamed with the
suffix ``.bak'' appended.  This provides a backup file.
.TP
.I Load
Pressing this button or
.I <Meta>l
will clear the canvas of any
current figure and read the figure from the filename specified
in the
.I Filename
menu item
.IR "if any" ,
or the name specified in the
.I "Current Filename"
if the former is empty.
The figure will be offset by the amounts specified (Fig units)
in the X and Y load/merge offset widgets.
If there is a figure currently on the canvas and any modifications
have been made to it and not saved, a popup query
window will first appear asking if the user wishes to discard the current
figure or cancel the
.I Load
operation.
.IP \&
The current Export directory is updated to the current File directory when
Load is pressed.
.IP \&
A popup message window will appear and diagnostic messages
will be written if
.I xfig
changes any ``illegal'' object values to legal values.
For example,
older versions of
.I xfig
were lax about initializing unused parts such as
.IR depth ,
and would produce very large, random values.
.I Xfig
now will ``clean up'' bad values and inform you when it does so.
Also, if you read in an older file format,
.I xfig
will inform you that
it is converting it to the current format for that version of
.IR xfig .
.br
This window can be popped down by clicking the mouse button on the
.I Dismiss
button.
.TP
.I "Merge Read"
Pressing this button or
.I <Meta>r
will read the figure from the filename
specified in the
.I Filename
window
.IR "if any" ,
or the name
specified in the
.I "Current Filename"
if the former is empty,
and merge it with the figure already shown on the canvas.
The figure will be offset by the amounts specified (Fig units)
in the X and Y load/merge offset widgets.
Any user-defined colors in the file being merged will be renumbered
if necessary to unique values so as not to conflict with any user-defined
colors already defined.  There is
.I no
comparison of the color values of the existing user-defined colors with
the colors being merged in so there may be identical colors with different
numbers.
.IP \&
See
.I Load
above for a description of the popup message window.
.PP
.po -.5i
.nr LL 6.5i
.TP
.I Export
Will let you export the figure to an output file in one of several formats.
Pressing mouse button 3 on this button invokes
.I Export
function without popping up the export panel.
.br
Mouse button 1 or
.I <Meta>e
pops up a directory browser widget and
a menu with several export-related functions:
.PP
.po +.5i
.nr LL 6i
.TP
.I Magnification
This is an editable AsciiTextWidget which contains the magnification to use
when translating figure to the output language.
The default is 100%.
.TP
.I Orientation
This button will toggle the output orientation between Landscape (horizontal)
and Portrait (vertical).
The default orientation is the same as the mode that
.I xfig
was started with, or the orientation in the Fig file when loading a Fig
file of version 3.0 or higher.
.TP
.I Justification
This window will only be sensitive when the language selected is ``ps''
.RI ( PostScript ).
You may choose that the figure is
.I "flush left"
or
.I centered
in the
output file.
.I "Export Offset"
These two editable AsciiTextWidgets allow one to export
a figure with an offset.
The figure will be offset by the amounts specified (in inches or cm)
in the X and Y panels.  A negative value in the X offset will shift
the figure to the left, and a negative value in the Y offset will
shift the figure up.
These offsets are in addition to any centering done with the
centering option.
.TP
.I Language
The translation language to use for
.I xfig
output.
The default is
.IR PostScript .
The figure may be saved as an X11 bitmap by choosing
.I "X11 Bitmap"
as the output language.
The bitmap(pixmap) is created from the figure, the size of which is determined
by the enclosing rectangle of all the figure plus a small border.
.br
The figure may also be saved as an color X11 pixmap
(using the XPM3 package) by choosing
.I "X11 Pixmap"
as the output language, or as a
.I GIF
file.
.br
Finally, the figure may be saved as a
.I JPEG
image in a JFIF file.
The quality factor for exporting JPEG is fixed at 75.  This seems to be
fine for figures containing only solid objects (no images) and adequate
for figures containing imported images (GIF, JPEG, etc.).
.TP
.I "Default Output Filename"
This is read-only AsciiTextWidget which contains the filename that will be used
to write output to a file
.I "if there is no name specified in"
Output File.
The default is the figure name plus an extension that reflects the output
language used, e.g.
.B myfigure.ps
if
.I PostScript
is the current language used.
If the file already exists a confirmation popup menu will appear
asking the user to confirm or cancel the save.
.TP
.I "Output Filename"
This is an editable AsciiTextWidget which contains the filename to use
to write output to a file.
Pressing return in this window will
.I Export
the file and copy the name to the
.I "Default Output Filename"
widget.
If the file already exists a confirmation popup menu will appear
asking the user to confirm or cancel the save.
.TP
.I "(File) Alternatives"
Pressing mouse button 1 on a filename in the file alternatives
window will select that file by copying the filename into
.I Filename
window.
Pressing return in this window will
.I Export
the file and copy
the name to the
.I "Default Output Filename"
widget.
.TP
.I "Filename Mask"
A wildcard mask may be typed into this editable AsciiTextWidget to restrict
the search of filenames to a subset ala the
.I ls
command.
Pressing return in this window will automatically
rescan the current directory.
This string may be set by setting the X toolkit resource
.BR Fig*export_panel*mask*string .
.TP
.I "Current Directory"
This is an editable AsciiTextWidget which shows the current directory.
It may be modified by the user to manually set a directory name.
When
return is pressed in this window the directory specified is scanned for
files matching the
.IR Filenamemask ,
if any.
.IP \&
It is automatically updated
to follow the current File directory when a File Load or Save is done.
.IP \&
The
.B ~
(tilde) character may be used to specify a user's home directory, ala
unix shell tilde expansion.
.TP
.I "(Directory) Alternatives"
Pressing mouse button 1 on a directory name in the directory
alternatives list will do a ``change directory'' to that directory.
.IP \&
Pressing mouse button 3 in either the file or
.I "Directory Alternatives"
window will do a ``change directory'' to the
parent directory.
.TP
.I Home
Pressing this button will change the directory to the
.I $HOME
directory of the user.
.TP
.I Rescan
Pressing this button or
.I <Meta>r
will rescan the current directory.
.TP
.I Cancel
Pressing this button or
.I <Meta>c
will pop down the
.I Export
menu without doing any print operation.
.TP
.I Export
Pressing this button or
.I <Meta>e
will write (export) the figure
to the file using the selected language.
If the file already exists, a confirmation window will popup to ask the
user to confirm the write or cancel.
Pressing return in the Output Filename window will also Export the file.
.PP
.po -.5i
.nr LL 6.5i
.TP
.I Print
Pressing mouse button 3 on this button invokes
.I "Print to Printer"
function without popping up the print panel.
Pressing the
.I Shift
key and mouse button 3 invokes the
.I "Print to Batch"
function.
Pressing mouse button 1 or
.I <Meta>p
pops up a menu with several
print-related functions:
.PP
.po +.5i
.nr LL 6i
.TP
.I Magnification
This is an AsciiTextWidget which contains the magnification to use
when translating figure to the output language.
.TP
.I Orientation
This button will toggle the output orientation between Landscape (horizontal)
and Portrait (vertical).
The default orientation is the same as the mode that
.I xfig
was started with, or the orientation in the Fig file when loading a Fig
file of version 3.0 or higher.
.TP
.I Justification
This button will bring up a sub-menu from which you may choose
.I center
or
.I "flush left"
to justify the figure on the page.
The default is
.IR "flush left" .
.TP
.I Printer
This is an AsciiTextWidget which contains the printer to
use if output is directed to a printer.
The name of the printer may be set setting the X toolkit resource
.BR Fig*printer*string .
If no resource is set, the environment variable
.I PRINTER
is used.
.TP
.I "Print Job Params"
This is an AsciiTextWidget which into which you may put any extra
command-line parameters that your lpr or lp program needs for printing.
If the meta sequence
.I %f
appears in the string the current figure name will be substituted.
It may appear more than once.
This may be set using the resource
.BR Fig*job_params*string .
.TP
.I "Figures in batch"
This indicator shows how many figures have been put in the batch file
for printing
.TP
.I Dismiss
Pressing this button or
.I <Meta>c
will pop down the
.I Print
menu.
.TP
.I "Print FIGURE/BATCH to Printer"
Pressing this button or
.I <Meta>p
will send the current figure
(or the batch file if it is has any figures in it) to the printer,
by passing it through
.I fig2dev
to convert it to
.I PostScript
then to the unix
.I lpr
(on BSD equivalent Unixes)
or
.I lp
(on SYSV systems) program.
If the batch file is printed by this
button then it is removed after printing.
The message in the button changes to reflect whether the batch file
will be printed (when there are any figures in the batch file)
or the current figure.
.IP \&
Note that the figure that is printed is what you see on the canvas,
not necessarily the figure file.
I.e., if you haven't saved the figure
since the last changes, the figure from the canvas is printed.
.I Xfig
writes the figure to a temporary file to do this.
The name of the file is
.IB XFIGTMPDIR /xfig-print\c
.IR PID ,
where
.I XFIGTMPDIR
is the value of the environment variable by that name and
.I PID
is the process ID of
.IR xfig .
If the environment variable
.I XFIGTMPDIR
is empty or not set, the
.B /tmp
directory is used.
.I "Print FIGURE to Batch"
Pressing this button or
.I <Meta>b
will append the figure (in
.I PostScript
form)
to a batch file.
The
.I "Print to Printer"
button will send the batch file to the printer.
.TP
.I "Clear Batch"
Pressing this button or
.I <Meta>x
will erase the accumulated figures from the batch file.
.PP
.po -.5i
.nr LL 6.5i
.SH "INDICATOR PANEL COMMAND DESCRIPTIONS"
.PP
The indicator panel contains buttons to set certain drawing parameters
such as line thickness, canvas grid, rotation angle etc.
All of the buttons use the same mouse buttons for setting values.
Pressing mouse button 1 on the indicator will pop up a panel
in which either a value may be typed (e.g. for a line thickness) or the
mouse may be clicked on one of several buttons (e.g. for grid style or
font name).
For those that expect a value, pressing return in the value
part of the window will set the new value and pop down the menu.
.PP
Pressing mouse button 2 on an indicator will decrement the value
(e.g. for line thickness)
or cycle through the options in one direction (e.g. font names), while pressing
mouse button 3 will increment the value or cycle through the options
in the other direction.
.TP
.I "ZOOM SCALE"
The canvas zoom scale may be set/increased/decreased with this button.
The zoom scale is displayed within the zoom button.
Ruler, grid and linewidth are scaled, too.
Pressing mouse button 2 will decrease the zoom factor by 1.0 unless it
is less than 1.0 already in which case it will reduce to the nearest 0.25.
Pressing mouse button 3 will increase the zoom factor by 1.0 unless it
is less than 1.0 in which case it will increase it to the nearest 0.25.
Pressing the control key and mouse button 3 together will
set the zoom scale to 1.
.Sp
The figure may also be zoomed by defining a zoom rectangle by pressing
the control key and mouse button 1 together.
This will define one corner of the zoom rectangle.
Move the mouse and click mouse button 1 again to
define the opposite corner of the zoom rectangle.
.TP
.I "GRID MODE"
With this button the user may select no grid,
1/4 inch (5mm in metric mode) grid 1/2 inch (10mm) grid, or 1 inch (20mm).
.TP
.I "POINT POSITION"
This button controls the coarseness of object placement on the canvas.
The options are exact (on pixel) placement, 1/16 inch (1mm in metric mode), 1/4
inch (5mm) or 1/2 inch (10mm).
This allows the user to easily place objects
in horizontal or vertical alignment.
.IP \&
This also restricts which objects may be ``picked up'' by the mouse when editing.
If a corner of an object is not positioned on the canvas on a multiple
of the point positioning resolution you may not be able to pick it.
If this happens, a black square will temporarily appear above the mouse cursor.
This square will also appear anytime the user tries to pick a nonexistent
object.
.TP
.I "ROTATION ANGLE"
The rotation angle for rotating objects may be set/increased/decreased
with this button.
Note that not all objects may be rotated, and certain objects
may only be rotated by certain angles.
Pressing mouse button 2 will decrease the angle in steps of 15 degrees,
while mouse button 3 will increase the angle the same amount.
To select other angles, press mouse button 1 and
enter the angle in the popup menu.
.TP
.I DEPTH
The depth at which new objects will be created may be set/increased/decreased
with this button.
.TP
.I "NUMBER OF POLYGON SIDES"
The number of sides used in creating a
.I "REGULAR POLYGON"
is set with this button.
.TP
.I "NUMBER OF COPIES"
The number of copies to make when doing a
.I "COPY & ROTATE"
function on an object.  Each copy will be rotated an additional
.I "ROTATION ANGLE"
angle from the previous.
.TP
.I "NUMBER OF X (or Y) COPIES"
The number of copies to make in the X (or Y) direction when doing a
.I COPY
function on an object.
.TP
.I "SMART-LINKS MODE"
This button controls the smart-links mode.
When turned on, lines which
link box-like objects together (henceforth called
.IR links )
are treated
specially when one of the box-like objects is moved.
When set to
.I MOVE
mode, the end point of the link which touches
(or is very near) the perimeter of the box is moved with the
box so that the box and the end point remain linked.
When set to
.I SLIDE
mode, the end segment of the link slides so
that the box remains linked and the angle of the end segment is maintained.
This is useful for keeping the last segment of a link horizontal or vertical.
.IP \&
(At the moment, this mode only works for the
.I MOVE
and
.I COPY
functions and only works for
.I POLYLINE
links and box-like objects.
Another limitation at the moment is that if both ends of a link touch
the box being operated on, only one end of the link will be adjusted.)
.TP
.I "VERTICAL ALIGN"
This sets the vertical alignment mode for the
.I ALIGN
button in the editing mode panel.
The choices are no vertical alignment, align to top edge,
middle or bottom edge of compound, distribute the centres or edges
evenly, or abut the vertical edges together.
The
.I "HORIZONTAL ALIGN"
and
.I "VERTICAL ALIGN"
indicator settings are
used together to align objects inside a compound or in canvas.
.TP
.I "HORIZONTAL ALIGN"
This sets the horizontal alignment mode for the
.I ALIGN
button in the editing mode panel.
The choices are no horizontal alignment, align to left edge,
middle or right edge of compound, distribute the centres or edges
evenly, or abut the horizonaal edges together.
The
.I "HORIZONTAL ALIGN"
and
.I "VERTICAL ALIGN"
indicator settings are used together to align objects
inside a compound or in canvas.
.TP
.I "ANGLE GEOMETRY"
The following settings are available to restrict the drawing angle of line
segments in
.IR POLYLINES ,
.I POLYGONS
and
.IR SPLINES .
.po +.5i
.nr LL 6i
.TP
.I UNRESTRICTED
Allow lines to be drawn with any slope.
This is the default setting.
.TP
.I "LATEX LINE"
Allow lines to be drawn only at slopes which can be handled by
.I LaTeX
picture environment lines: slope =
.IR x / y ,
where
.RI x , y
are integers in the range [\-6,6].
.TP
.I "LATEX VECTOR"
Allow lines to be drawn only at slopes which can be handled by
.I LaTeX
picture
environment vectors: slope =
.IR x / y ,
where
.RI x , y
are integers in the range [\-4,4].
.TP
.I MANHATTAN-MOUNTAIN
Allow lines to be drawn in the horizontal, vertical or diagonal direction only.
.TP
.I MANHATTAN
Enforce drawing of lines in the horizontal and vertical direction only.
The name
.I Manhattan
comes from the horizontal/vertical look of the Manhattan
(New York City) skyline.
.TP
.I MOUNTAIN
Enforce drawing of only diagonal lines.
The name comes from the pointed shape of mountains.
.PP
.po -.5i
.nr LL 6.5i
.TP
.I "FILL STYLE"
This button allows the user to select the area fill darkness (grey scale
or color intensity) or fill patterns for all objects except
.I TEXT
and
.IR PICTURE ,
or to turn off area fill altogether.
.sp
There are 21 ``shades'' going from black to full saturation of the fill color,
and 21 more ``tints'' from full saturation + 1 to white.
In addition, there are 16 patterns (currently only available for PostScript,
GIF, JPEG, XPM and X11 bitmap output):
.in +.5i
.nf
30 degree left-leaning diagonal lines,
30 degree right-leaning diagonal lines,
30 degree crosshatch,
45 degree left-leaning diagonal lines,
45 degree right-leaning diagonal lines,
45 degree crosshatch,
bricks,
circles
horizontal lines,
vertical lines,
90 degree crosshatch,
fishscales,
small fishscales,
octagons,
horizontal ``sawtooth'' and
vertical ``sawtooth''.
.fi
.in
.TP
.I "PEN COLOR"
This button is used to select one of 32 standard colors for the borders
of objects, or one of the user-defined colors
.TP
.I "FILL COLOR"
This button is used to select one of 32 standard colors or user-defined
color to fill objects with if they have a fill style.
.sp
Pressing mouse button 1 on either the fill or pen color buttons will popup
an extended color panel, allowing the user to select either a standard
color or a user-defined color from menus.
.sp
The 32 standard colors are black, yellow, white, gold,
five shades of blue, four shades of green,
four shades of cyan, four shades of red, five shades of magenta,
four shades of brown, and four shades of pink.
.sp
To select one of the standard colors either click mouse button 1 on the
desired color and either press Return or click mouse button 1 on the "Ok" button.
The latter step will pop down the color panel.
You may also double click mouse button 1 on the desired color to select
it and pop down the color panel in one step.
.sp
To add a user-defined color press mouse button on the ``Add Color'' button
in the ``User Defined Colors'' section.  User defined colors are assigned
values sequentially starting from 32 for a maximum of 512 colors.
.sp
A user color may be deleted by pressing mouse button 1 on the color box to
select it and then pressing the ``Del Color'' button.
.sp
The last color deleted may be undeleted by pressing the ``UnDel Color'' button.
.sp
To edit a user color first select the color square by pressing mouse button 1
on the desired square. A solid or dashed line will be drawn around the box to show
that it is selected.  Then choose the color either by
using the RGB (red, green, blue) or the HSV (hue, saturation, value) sliders.
or by typing a hexadecimal value into the window under the pen or fill
color boxes representing the red,
green and blue components (00 to FF).  If the latter is used, typing carriage
return in the hexadecimal window will set the color.
.sp
Additionally, there is a button above each of the RGB sliders which when
activated will ``lock'' two or more sliders together at their current setting
and allow you to increase or decrease their values together with the ``lock''
slider.
.sp
If the user color being edited was just created, a dashed line will be drawn
around the box instead of a solid line to indicate that it is new.  The color
that is currently in the pen or fill boxes will be copied into the user color
cell for modification.  In this way you may start with a standard color or other
user color and modify it from there.
.sp
The user color is said to be ``defined'' when any of the sliders is moved or
a carriage return is typed into the hexadecimal window.  This will be shown
by a solid line being drawn around the square instead of dashed.
.sp
The pen or fill color choice is activated when the panel is popped up by
the respective button in the indicator panel, but you may switch to editing the
other color by pressing either the ``Edit Pen'' or ``Edit Fill'' button.
.sp
Note that
.I TransFig
supports color output for
.IR PostScript .
On monochrome screens the objects are created with the selected color,
but black (or white) is used to draw the objects on the canvas.
.TP
.I "LINE WIDTH"
The width of lines may be selected with this button.
Zero width lines may be
drawn for the purpose of having filled areas without outlines.
.TP
.I "LINE STYLE"
The choices for line style are solid, dashed and dotted.
Once created, a dashed or dotted line may be edited
to change the length of dashes or the spacing of dots respectively.
The dash length and dot gap can be changed from the default
using the popup menu.
.TP
.I "JOIN STYLE"
Lines may be joined with a
.IR miter ,
.I rounded
or
.I bevel
joint.  This is only used for
.I POLYLINE
or
.I POLYGON
objects.
.TP
.I "CAP STYLE"
The ends of lines may be capped with
.IR butt ,
.I round
or
.I projecting
cap.  This is only used for
.IR POLYLINE ,
.I SPLINE
or
.I "OPEN ARC"
objects.
.TP
.I "ARROW MODE"
This button selects the auto-arrow mode for drawing lines.
The options are no arrow heads, backward-pointing arrow head,
forward-pointing arrow head or both.
If one or both arrow head modes are turned on, then
arrow heads are automatically drawn when drawing
.IR POLYLINE ,
.I SPLINE
or
.I "OPEN ARC"
objects.
.TP
.I "ARROW TYPE"
There are four types of arrows which may be filled with
white or the object color.
.TP
.I "BOX CURVE"
The radius of the corners on
.I ARC-BOX
objects may be set with this button.
.TP
.I "TEXT JUSTIFICATION"
The adjustment of text may be set to
.IR left ,
.I center
or
.IR "right justification" .
.TP
.I "TEXT SIZE"
The text size may be set/increased/decreased with this button.
The default is 12 points.
.TP
.I "TEXT STEP"
The interline spacing of text may be set/increased/decreased with this button.
The number displayed gives the multiple of the font height
that will be placed between lines on hitting
.IR <return> .
The default is a factor of 1.2 times the current font size.
.TP
.I "TEXT FONT"
This button allows a selection of 35 fonts available for most Apple
.I PostScript
printers.
There are two buttons at the top of the menu.
The
.I cancel
button pops down the menu without changing the current font.
The
.I "use latex fonts"
will switch the menu to the
.I LaTeX
font choices.
When the
.I LaTeX
font menu is up, besides a
.I cancel
button there is a button to switch back to the
.I PostScript
fonts.
.IP \&
The name of the font is printed in the font itself so that one may see
what that font looks like.
If a corresponding X11 font exists, new text is created
on the canvas using that font.
.I xfig
uses the size of X11 font closest to that selected
by the font size button.
If the X11 font doesn't exist,
.I xfig
uses the font selected by the
.B \-normal
option.
To abort selection of a font, click mouse button 1 on
.IR cancel .
.TP
.I "TEXT FLAGS"
This button displays the current setting of the text flags.
You may use mouse buttons 2 and 3 to step back and forth
through the three flag settings:
.IR Hidden ,
.I Rigid
and
.IR Special .
To change any of the flags
you must use mouse button 1 to popup a menu from which you may change any
or all of the flags.
.IP \&
The
.I Hidden
flag is used for figures that will be used with
.I LaTeX
and is applicable only to the display of the document in
.IR xfig .
It means that the text itself is not shown onscreen, but only the string
"<text>".  This is to keep long sequences of
.I LaTeX
formatting commands from making the screen messy and hard to read.
The default for the
.I Hidden
flag is
.IR off .
.sp
The
.I Special
Special flag means that special characters in the string are not specially
processed but are passed directly to
.IR LaTeX .
If this flag is not set, then the backslash character '\\' is changed
to the \\backslash command, a brace '{' is turned into a brace command \\{, etc.
The default for the
.I Special
flag is
.I off
unless
.I xfig
is started
with the command-line parameter
.B \-specialtext
(resource specialtext).
.IP \&
The
.I Rigid
attribute forces text to remain the same size even if
inside a compound object that is scaled up or down.
The default is
.IR off .
.SH "DRAWING AND EDITING MODE PANELS"
Icons in the drawing and editing mode panel windows represent
object manipulation functions,
modes and other drawing or modification aids.
Manipulation functions are selected by positioning the cursor over the icon
representing the desired drawing/editing function and
clicking mouse button 1.
The selected icon is highlighted, and
a message describing its function appears in the message window.
The hilighting remains on until another function is selected.
.SH "DRAWING MODE PANEL COMMAND DESCRIPTIONS"
.PP
The drawing mode panel contains buttons used to create the various
.I xfig
objects.
Once the drawing mode is selected, the object is created by moving
the mouse to the point on the canvas where the object is to be placed
and pressing and releasing mouse button 1.
After that the mouse is moved to the second point and
mouse button 1 is again pressed for the next point.
For those objects which may have more than two points (e.g. a line),
mouse button 1 may be pressed for each successive point, and
mouse button 2 must be pressed to finish the object.
To create a single point using the
.I POLYLINE
button, press and release mouse button 2.
Newly created points may be deleted by pressing the shift key and mouse button 1.
For the
.I ARC
object, which requires exactly three
points mouse button 1 is used for all three points.
.PP
At any time mouse button 3 may be pressed to cancel the
creation of the object.
.TP
.I ARC
Create an arc.
Specify three points using mouse button 1.
The first and last points will form the endpoints of the arc
and the second specifies any point on the arc.
There are two types of arcs, open and pie-wedge.
.TP
.I BOX
Create rectangular boxes.
Start by clicking mouse button 1 on any corner of the desired box and
finish with the same mouse button on the diagonally opposite corner of
the box.
.TP
.I ARC-BOX
Create rectangular boxes with rounded corners.
Start and finish with mouse button 1 in the same way as
.IR BOX .
The radius of the corners is selected by the
.I "BOX CURVE"
button.
.TP
.I CIRCLE
Create circles by specifying their radii or diameters.
Click mouse button 1 on the center of the circle and drag the mouse
until the desired radius or diameter is attained.
Click mouse button 1 again to finish the circle.
.TP
.I ELLIPSE
Create ellipses using the same procedure as for the drawing of circles.
.TP
.I "PICTURE OBJECT (PIC)"
This has been changed from the previous (2.1) version to be more generic,
allowing GIF files, JPEG (JFIF) files, X11 bitmap (monochrome) files and
X11 pixmap (XPM3) color files in
addition to Encapsulated PostScript files to be imported.
Compressed (.Z) and gzipped (.z or .gz) files are also handled.
You must have the XPM3 libraries installed to use the XPM import/export
features.  See the README and Imakefile files.
.Sp
A Floyd-Steinberg dithering is applied to color images for monochrome displays.
.Sp
For EPS files, xfig will attempt to use
.I Ghostscript
to generate a
color image if xfig is running on an color display.
.I Ghostscript
must be compiled with with the "gif8" and "pbmraw" drivers.
The pbm driver is used when you run xfig on a monochrome display and the gif8
driver is used on a color display.
.Sp
.I Ghostscript
is available from
.IR prep.ai.mit.edu .
.Sp
A neural network color allocation scheme is used when the number of colors
for all the color images on the canvas exceeds the lesser of
the number of free colorcells or the value in the resource Max_image_colors
(command-line parameter -max_image_colors).  Whenever a new color image
is added to the canvas, the colors for all the images on the canvas are
reallocated and the images are redrawn.  No reallocation is done when
images are deleted from the canvas.
.Sp
Click mouse button 1 on any corner for the
.I PIC
object and finish by clicking mouse button 1
again on the diagonally opposite corner.
The
.I EDIT
popup panel will appear and the file name of the
.I PIC
object may be entered.
After pressing
.I DONE
or
.I APPLY
(see the description of the
.I EDIT
panel for the difference between the
.I DONE
and
.I APPLY
buttons) the bitmap part of the
.I PIC
object will appear in the box just created.
If no
.I PIC
file is available yet or no name is entered or
in the case of an Encapsulated PostScript file
there is no
.I "preview bitmap"
pressing
.I DONE
will pop down the edit panel and the word
.I <empty>
or the
.I PIC
file name will remain in the
.I PIC
box.  Later, when the name of the
.I PIC
file is known or the file is available,
you may re-read the
.I PIC
file using the popup edit panel and the bitmap part of the
.I PIC
file will replace the name in the box.
.Sp
If you want the original size of the
.I PIC
object, press the
``Use orig size'' button and the eps bitmap will enlarge or shrink to
the size specified in the preview bitmap of the
.I PIC
file.
If you want the
.I PIC
object to be approximately the size of
the rectangle specified with the mouse but want the aspect ratio
to be same as the original, press either ``Shrink to orig'' or
``Enlarge to orig'' buttons.
You must press the
.I APPLY
button to see these effects.
.Sp
The
.I Screen Capture
button will unmap the xfig windows, allowing you to capture a rectangular
section of the screen to a GIF file, which becomes the current import
file.  After pressing the
.I Screen Capture
button you press and release mouse button 1 at one corner of the area of the
screen you want to capture, drag out the rectangle and press and release
mouse button 1 to finish.  You may cancel the operation by pressing
either of the two other mouse buttons.
.Sp
The
.I Edit Image
button will call an external image viewer/editor (see resource Fig.image_editor:
in the Fig.ad file) to allow you to edit the current image.  The file
is reimported automatically after exiting the editor.
The xfig windows are automatically unmapped during the call of the editor.
.Sp
The
.I Reread
button will cause xfig to re-read the image file in case it has 
changed.  This is useful (e.g.) when you have made changes to the image
file in a program external to xfig and you wish to update the imported
image.
.Sp
The
.I Browse
button which will popup a file browser to allow
you to search directories for image files.  The default search mask
will match *.gif*, *.jpg*, *.xpm*, *.xbm* and *.eps*.  This
mask is in the Fig.ad application defaults file.
.TP
.I "INTERPOLATED SPLINE"
Create (cubic spline) spline objects.
Enter control vectors in the same way as for creation of a
.I POLYLINE
object.
At least three points (two control vectors) must be entered.
The spline will pass through the entered points.
Newly created points may be deleted by pressing the shift key and mouse button 1
before pressing mouse button 2.
.TP
.I POLYLINE
Create polylines (line segments connecting a sequence of points).
Enter points by clicking mouse button 1 at the desired positions on the
canvas window.
Click mouse button 2 to finish.
Newly created points may be deleted by pressing the shift key and mouse button 1
before pressing mouse button 2.
.TP
.I POLYGON
Same as
.I POLYLINE
except that a line segment is drawn connecting the first and last
points entered.
.TP
.I "REGULAR POLYGON"
The number of sides is first selected with the
.I "NUM SIDES"
button in the indicator panel.
Then mouse button 1 is clicked on
the center and the mouse dragged to the desired size.
The object may be rotated as it is being created
by moving the mouse up or down relative to the starting point.
Click mouse button 1 to finish.
.TP
.I "CLOSED INTERPOLATED SPLINE"
Create closed or periodic splines.
The function is similar to
.I POLYGON
except that a closed interpolated spline is drawn.
The spline will pass through the points (knots).
.TP
.I "CLOSED SPLINE"
Create closed or periodic spline objects.
The function is similar to
.I POLYGON
except that a closed spline will be drawn instead of polygon.
The entered points are just control points; i.e. the spline will
not pass any of these points.
Newly created points may be deleted by pressing the shift key and mouse button 1
before pressing mouse button 2.
.TP
.I SPLINE
Create (quadratic spline) spline objects.
Enter control vectors in the same way as for creation of a
.I POLYLINE
object.
At least three points (two control vectors) must be entered.
The spline will only pass through the two end points.
Newly created points may be deleted by pressing the shift key and mouse button 1
before pressing mouse button 2.
.TP
.I TEXT
Create text strings.
Click mouse button 1 at the desired position on
the canvas window, then enter text from the keyboard.
Text may be pasted
from the PRIMARY cut buffer
.RI ( xterm
cut/paste buffer) by pressing the
.I F18
function key (the
.I Paste
key on Sun keyboards) or any key/button defined in the translation
table for the canvas.
See the default
.B Fig.ad
file for example.
Text is drawn using the current font, font size and justification settings.
A DEL or ^H (backspace) will delete a character, while a ^X will
erase the entire line.
Finish by clicking mouse button 2 or typing the
.I <return>
key.
If
.I <return>
is used, the text pointer automatically moves to the next ``line'',
a distance of the font height times the value in the
.I "TEXT STEP"
button,
and text input mode is re-entered.
To finish text fully, click
mouse button 2 or choose any panel button that changes
modes (e.g. box, save, etc).
To edit text, click on an existing text string with mouse button 1.
Insertion of characters will take place at that point.
Or, use the popup
.I EDIT
mode to modify the text.
.Sp
Eight-bit characters may be entered using the meta (compose) key.
For example, to create an ``a umlaut'', press and release the meta key, then
the letter ``a'', then " (quote).
To create a ``c cedilla'', use <meta>c followed by comma.
The following is a list of all special characters available using the meta key:
.Sp
.\"--------------------------------------------------------------------
.\" Table Begin
.\"--------------------------------------------------------------------
.nr t0 \w'Keys\0\0\0\0'u
.ta \n(t0u
.nf
.\" set n to length of longest line
.di xx
!!	upside-down exclamation point
.nr n \n(.nu
.di
.rm xx
.\" HEADER
Keys	Character Name
.if n \l'\nnu\&-'
.if t \l'\nnu'
.\" BODY
!!	upside-down exclamation point
??	upside-down question mark
C/	cent sign
L\-	British pound
OX	currency
Y\-	yen
__	broken vertical bar
SO	section
""	dieresis
CO	copyright
RO	registered trademark
_a	ordfeminine
_o	ordmasculine
<<	guillemotleft
>>	guillemotright
\-|	notsign
\-\-	hyphen
+\-	plusminus
^\-	macron
^*	degree
^.	periodcentered
^1	onesuperior
^2	twosuperior
^3	threesuperior
14	onequarter
12	onehalf
34	threequarters
**	multiply
\-:	division
/u	mu
P!	paragraph
A`	A accent grave
A'	A accent acute
A^	A accent circumflex
A~	A accent tilde
A"	A dieresis
A*	A ring
AE	AE
a`	a accent grave
a'	a accent acute
a^	a accent circumflex
a~	a accent tilde
a"	a dieresis
a*	a ring
ae	ae
C,	C cedilla
c,	c cedilla
D\-	Eth
d\-	eth
E`	E accent grave
E'	E accent acute
E^	E accent circumflex
E"	E dieresis
e`	e accent grave
e'	e accent acute
e^	e accent circumflex
e"	e dieresis
I`	I accent grave
I'	I accent acute
I^	I accent circumflex
I"	I accent dieresis
i`	i accent grave
i'	i accent acute
i^	i accent circumflex
i"	i dieresis
N~	N tilde
n~	n tilde
O`	O accent grave
O'	O accent acute
O^	O accent circumflex
O~	O accent tilde
O"	O dieresis
O/	O slash
OE	OE
o`	o accent grave
o/	o accent acute
o^	o accent circumflex
o~	o accent tilde
o"	o dieresis
o/	o slash
oe	oe
P|	Thorn
p|	thorn
ss	German ss (s-zed)
U`	U accent grave
U'	U accent acute
U^	U accent circumflex
U"	U dieresis
u`	u accent grave
u'	u accent acute
u^	u accent circumflex
u"	u dieresis
Y'	Y accent acute
y'	y accent acute
y"	y dieresis
.if n \l'\nnu\&-'
.if t \l'\nnu'
.DT
.fi
.sp
Note: the two special characters OE and oe are not displayed
on the screen, but they are printed by fig2dev.
.\"--------------------------------------------------------------------
.\" Table End
.\"--------------------------------------------------------------------
.SH "EDITING MODE PANEL COMMAND DESCRIPTIONS"
When a button in the editing mode panel is pressed, any
objects that may be affected by that editing operation will show their
corner markers.
Only those objects may be affected by the particular edit mode.
In cases where two edit modes exist for one button, it
may be that the corner markers will appear for objects that may be
affected by one button but not the other.
.SH "SELECTING OBJECTS"
When multiple objects have points in common, e.g. two boxes that
touch at one corner, only one object can be selected by clicking on
that point.
To select other objects, hold down the shift key while
pressing mouse button 1: the markers of one object will be
temporarily highlighted.
By repeatedly clicking mouse button 1 while
holding down the shift key, it is possible to cycle through all candidates for
selection at that point.
To perform the selected action, e.g.
deleting one box, click on the point without holding down the shift key.
The operation will be performed on the highlighted object.
.PP
.B Note:
If the mouse is not clicked near enough to an object marker
or for whatever reason
.I xfig
cannot ``find'' the object the user is trying to select,
a black square will temporarily appear above the mouse cursor.
.TP
.I "GLUE COMPOUND"
Compound objects are created by first tagging the objects to be compounded
and then pressing mouse button 3 to group the tagged
objects into a compound object.
Single objects are tagged by clicking on them with mouse button 1.
A number of objects can be tagged at once by using mouse button 2
to define the upper-left and lower-right corners of a region
enclosing the objects.
Tagged objects are shown with highlighted markers.
Tagged objects which are selected (see the
.B "SELECTING OBJECTS"
section above)
will be temporarily unhighlighted.
There is currently no special command to tag or untag all of the objects
within a figure.
You can untag all of the objects by changing from
.I GLUE
mode to some other mode (apart from
.IR BREAK )
and back again.
.TP
.I "BREAK COMPOUND"
Break a compound object to allow manipulation of its component parts.
Click mouse button 1 on one of the corner markers of the compound
object or along one of the imaginary lines defining the compound box.
Clicking with mouse button 2 will achieve the same effect
but will also tag the component parts (although you will not see the
tags until you change to the
.I GLUE
mode).
You can use this feature to easily alter the objects within a compound.
.TP
.I "SCALE OBJECT"
Any object may be scaled.
If mouse button 1 is pressed on any corner of a
.I BOX
or
.I ARC-BOX
object, then that object will be scaled
proportionally to its aspect ratio.  If pressed on an edge
then that dimension will be scaled.
For other objects only mouse button 2 may be used for scaling;
said object will be scaled larger or smaller about its center.
Mouse button 2 may be used on boxes too.
Text may only be scaled if inside a compound object and then only if its
.I RIGID
flag is set to
.I NORMAL
(using the popup edit panel).
See the
.I TransFig
manual for description of text options.
.TP
.I ALIGN
Align objects.
Click mouse button 1 to align objects inside a compound object
or mouse button 2 to align all objects on canvas according to the
setting in the
.I "VERTICAL ALIGN"
and
.I "HORIZONTAL ALIGN"
indicators.
Note that alignment with respect to the canvas doesn't work for
distributing or abutting.
The choices are the cumulative effect
of vertically aligning the objects to the
.IR TOP ,
.I MIDDLE
or
.I BOTTOM
edge and horizontally aligning to the
.IR LEFT ,
.I MIDDLE
or
.I RIGHT
edge of the compound, along with distributing or abutting the objects
vertically or horizontally.
.TP
.I "MOVE POINT"
Modify the position of a point of any object except
.I TEXT
and
.I COMPOUND
objects.
For unrestrained movement, click mouse button 1 over the desired
point, reposition the point, and click the
.I left
button again.
For horizontally or vertically constrained move, click mouse button 2
on the desired point and move either horizontally or vertically.
Notice that once you choose the direction (horizontal or vertical),
movement is constrained in that direction.
If, after moving the mouse initially, it
is moved in the other direction a greater distance than the current position
of the mouse relative to the starting point, then that will be the new
constraint direction.
In other words if you first move the mouse
.I horizontally
one inch (say) then move it
.I vertically
1.3 inches, the direction will switch to
.I vertical
until any
.I horizontal
motion exceeds 1.3 inches.
When the object is positioned where desired, click mouse button 1 to
place it if that button was used to start the move (unconstrained),
or mouse button 2 (constrained) if that button was used.
.TP
.I MOVE
Move object.
Click mouse button 1 (unconstrained move) or mouse button 2
(constrained move) on any corner marker of the object to be moved.
The horizontal/vertical constrained movement (mouse button 2) works
exactly as described for
.IR "MOVE POINT" .
.TP
.I "ADD POINTS"
Add points to
.IR POLYLINE ,
.IR POLYGON ,
.IR SPLINE ,
or
.I "CLOSED SPLINE"
objects (points of a
.I BOX
can not be added or deleted).
Note that a
.I "REGULAR POLYGON"
is really an ordinary
.IR POLYGON ,
so adding points to this object is allowed and does NOT keep
the polygon regular.
.TP
.I "COPY / CUT TO CUT BUFFER"
Copy object to canvas or cut buffer.
Click mouse button 1 (unconstrained copy)
or mouse button 2 (constrained copy) on any corner marker of
the object to be copied (for
.I CIRCLE
and
.I ELLIPSE
objects, mouse may also be clicked on their circumferences).
The object will be duplicated and then moved exactly as in
.IR MOVE .
.sp
If the number of X or Y copies is non-zero (from the bottom panel)
then that many copies will be made in each respective direction,
spaced evenly by the amount of the distance the object is placed
from the original object.
.sp
If mouse button 3 is clicked on an object, that object is copied
to the cut buffer for pasting into this or another figure.
The file used for the cut buffer is called
.B .xfig
in the user's
.I $HOME
directory.
This allows a user to run two or more
.I xfig
processes and cut/paste objects between them.
If there is no
.IR $HOME ,
a file is created in a temporary directory called
.BI xfig PID
where
.I PID
is the
.I xfig
process ID.
The temporary directory used is specified in the environment variable
.IR XFIGTMPDIR .
If that variable is empty or not set then
.B /tmp
is used.
.TP
.I "DELETE POINTS"
Delete points from
.IR POLYLINE ,
.IR POLYGON ,
.IR SPLINE ,
or
.IR "CLOSED SPLINE" .
Objects (points of a
.I BOX
or
.I ARC-BOX
can not be added or deleted).
Note that a
.I "REGULAR POLYGON"
is really an ordinary
.IR POLYGON ,
so deleting points from this object is allowed and does NOT
keep the polygon regular.
.TP
.I DELETE
Click mouse button 1 on an object to delete the object.
Delete a
.I region
of the canvas by clicking mouse button 2
and dragging the mouse to define an area of objects to delete.
Clicking mouse button 3 on an object will copy the object
to the cut buffer (see
.I "COPY/CUT TO CUT BUFFER"
above).
.TP
.I "EDIT OBJECT"
Edit settings for an existing object.
Click mouse button 1 on the object and a pop-up menu will appear
showing existing settings for the object.
Some of the menu entries
may be changed by typing new values in the appropriate windows.
These are editable Ascii\%TextWidgets and allow cut and paste.
Others pop up a sub-menu of multiple choices when pressed and held.
Yet others are buttons which toggle a setting on or off (e.g. arrow
heads on lines).
.IP \&
Press the ``done'' button to apply the changes to the object and finish.
Press the ``apply'' button to apply the changes but keep the menu up for
further changes.
Press the ``cancel'' button to cancel the changes and pop down the menu.
.IP \&
The following table shows which settings are used for the different objects.
.Sp
.\"--------------------------------------------------------------------
.\" Table Begin
.\"--------------------------------------------------------------------
.nr t0 \w'Polygon\0\0\0'u
.nr t1 \n(t0+\w'Angle\0'u
.nr t2 \n(t1+\w'Style\0\0'u
.nr t3 \n(t2+\w'Width\0'u
.nr t4 \n(t3+\w'Style\0'u
.nr t5 \n(t4+\w'Style\0'u
.nr t6 \n(t5+\w'Style\0'u
.nr t7 \n(t6+\w'Curve\0'u
.nr t8 \n(t7+\w'Color\0'u
.nr t9 \n(t8+\w'Color\0'u
.nr ta \n(t9+\w'Radius\0'u
.ta \n(t0u \n(t1u \n(t2u \n(t3u \n(t4u \n(t5u \n(t6u \n(t7u \n(t8u \n(t9u \n(tau
.ds Bu \0\0\(bu
.if n .RS -1i
.if t .RS
.nf
.ne 14
Object	Angle\&\&\&	Fill	Line	Line	Cap	Join	Box	Pen	Fill	Radius
.nr n \n(.nu
	\&\&\&\&	Style	Width	Style	Style	Style	Curve	Color	Color
.if n \l'\nnu\&-'
.if t \l'\nnu'
Arc	\&\&\&\&	\*(Bu	\*(Bu	\*(Bu	\*(Bu	\&	\&	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Arc-Box	\&\&\&\&	\*(Bu	\*(Bu	\*(Bu	\&	\&	\*(Bu	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Circle	\&\&\&\*(Bu	\*(Bu	\*(Bu	\*(Bu	\&	\&	\&	\*(Bu	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Ellipse	\&\&\&\*(Bu	\*(Bu	\*(Bu	\*(Bu	\&	\&	\&	\*(Bu	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
PIC*	\&\&\&\&	\&	\&	\&	\&	\&	\&	\*(Bu	\&
.if n \l'\nnu\&-'
.if t \l'\nnu'
Box	\&\&\&\&	\*(Bu	\*(Bu	\*(Bu	\&	\*(Bu	\&	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Polygon	\&\&\&\&	\*(Bu	\*(Bu	\*(Bu	\&	\*(Bu	\&	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Line	\&\&\&\&	\*(Bu	\*(Bu	\*(Bu	\*(Bu	\*(Bu	\&	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Spline	\&\&\&\&	\*(Bu	\*(Bu	\*(Bu	\*(Bu	\&	\&	\*(Bu	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
Text	\&\&\&\*(Bu	\&	\&	\&	\&	\&	\&	\*(Bu
.if n \l'\nnu\&-'
.if t \l'\nnu'
.DT
.fi
.if n .RE
.if t .RE
.IP \&
* Encapsulated PostScript picture objects don't use any of the above attributes.
The PostScript image is self-defined.  However, X11 bitmap picture objects use
the pen color for coloring the bitmap image.
.\"--------------------------------------------------------------------
.\" Table End
.\"--------------------------------------------------------------------
.TP
.I UPDATE
By pressing mouse button 1 on an object, the current settings for
the indicator buttons (line width, line style, area fill etc.) which
have been selected for update are copied into that object.
When
.I xfig
is started, all indicator buttons which are components of objects
are selected for update.
To unselect an indicator, click on the update button
and click mouse button 1 on the small button in the upper-right
corner of the indicator.
When that indicator is selected the foreground color
(default black) shows.
When it is unselected the background color (default white) shows.
.IP \&
If mouse button 2 is clicked on an object, the settings in the object
that are selected by the indicator buttons are copied into those indicator button
settings.
Thus, one may copy selected attributes of one object to another.
.TP
.I "FLIP VERTICALLY"
Flip the object up/down (mouse button 1) or copy the object and flip it
(mouse button 2).
Point to part of the object, click the appropriate button.
That object will be flipped vertically about that point.
.sp
Optionally, mouse button 3 may be pressed on the canvas to
set an anchor point about which the object will be flipped.
A crosshair indicates the anchor point on the canvas.
Pressing this button again will unset the anchor point.
.TP
.I "FLIP HORIZONTALLY"
Flip the object left/right (mouse button 1) or copy the object and flip it
(mouse button 2).
Point to part of the object, click the appropriate button.
That object will be flipped horizontally about that point.
.sp
Optionally, mouse button 3 may be pressed on the canvas to
set an anchor point about which the object will be flipped.
A crosshair indicates the anchor point on the canvas.
Pressing this button again will unset the anchor point.
.TP
.I "ROTATE CLOCKWISE"
Rotate the object (mouse button 1) or copy and rotate it
(mouse button 2)
.RI \- N
degrees (clockwise), where
.I N
is the amount set in the rotation indicator button.
The object is rotated about the chosen point.
.sp
Optionally, mouse button 3 may be pressed on the canvas to
set a rotation point about which the object will be rotated.
A crosshair indicates the rotation point on the canvas.
Pressing this button again will unset the rotation point.
.sp
Not all objects can be rotated,
and not all can be rotated at arbitrary angles.
For example,
.IR BOX ,
.I ARC-BOX
and
.I PIC
objects may only be rotated by 90 degrees.
Text objects may be rotated and to any angle.
.TP
.I "ROTATE COUNTER-CLOCKWISE"
Rotate the object (mouse button 1) or copy (mouse button 2)
.RI + N
degrees (counter-clockwise), where
.I N
is the amount set in the rotation indicator button.
The object is rotated about the chosen point.
.sp
Optionally, mouse button 3 may be pressed on the canvas to
set a rotation point about which the object will be rotated.
A crosshair indicates the rotation point on the canvas.
Pressing this button again will unset the rotation point.
.TP
.I "SPLINE <\-> POLYLINE"
and
.sp -1
.TP
.I "BOX <\-> ARC-BOX"
Turn a
.I POLYGON
into a
.I "CLOSED INTERPOLATED SPLINE"
, turn a
.I POLYLINE
into a
.I "INTERPOLATED SPLINE"
or turn a
.I BOX
into a
ARC-BOX
or vice versa.
.TP
.I "ADD/DELETE ARROWS"
Add or delete arrow heads of
.IR "OPEN ARC" ,
.I POLYLINE
or
.I SPLINE
objects.
Add an arrow head by clicking mouse button 1 on the endpoint of the object.
Delete an arrow head by clicking mouse button 2 on the endpoint or arrow head.
The length and thickness of the arrowheads may be modified
using the popup edit panel.
.SH PANNING
The figure may be panned by clicking mouse button 1, 2 or 3 in the rulers.
Clicking mouse button 1 in the top ruler will pan the image to the left
by 1/2 inch (1cm in metric mode), adjusted for zoom factor.
Clicking mouse button 3 in the top ruler
will pan the image right by the same amount.
By pressing and
.I holding
mouse button 2 the user may drag the ruler by the amount desired,
thus panning the image by that amount.
.PP
If the Shift key is held down while panning the movement is five (5)
times the normal rate.
.PP
The figure is panned up and down in the same way by clicking the mouse
in the ruler on the right of the canvas.
.PP
If the Shift key is held down while panning the movement is five (5)
times the normal rate.
.PP
The figure can be returned to its origin
by clicking mouse button 1 in the units
(e.g.
.I cm
or
.IR in )
box.
.PP
The arrow keys may also be used to pan the image and the home key to
return the figure to the origin.
Also, pressing the Control Key and mouse button 2
will pan the figure to the origin.
.bp
.SH "X DEFAULTS"
The overall widget name(Class) is xfig(Fig).
These resources correspond to the command line arguments:
.PP
.\"--------------------------------------------------------------------
.\" Table Begin
.\"--------------------------------------------------------------------
.nr t0 \w'internalborderwidth\0'u
.nr t1 \n(t0+\w'InternalBorderWidth\0'u
.nr t2 \n(t1+\w'boolean\0'u
.nr t3 \n(t2+\w'Times-Roman\0'u
.ta \n(t0u \n(t1u \n(t2u \n(t3u
.if n .RS -1i
.if t .RS
.nf
.\"-------
.\" set n to length of table line
.di xx
Name	Class	Type	Default	Command-line
.nr n \n(.nu
.di
.rm xx
.\"-------
.\" HEADER
.\"-------
Name\&\&\&\&\&\&	Class\&\&\&\&\&\&	Type	Default\&\&\&\&\&	Command-line
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&	\&\&\&\&\&\&\&\&	equivalent
.\"-------
.\" BODY
.\"-------
.if n \l'\nnu\&-'
.if t \l'\nnu'
boldFont\&\&\&\&	Font\&\&\&	string	8x13bold\&\&\&\&	\-bold
but_per_row\&\&\&	But_per_row\&\&\&	int	2\&\&\&\&\&\&\&\&	\-but_per_row
buttonFont\&\&\&\&	Font\&\&\&	string	6x13\&\&\&\&	\-button
debug\&\&\&\&\&\&	Debug\&\&\&\&\&\&	boolean	off\&\&\&\&\&\&\&	\-debug
dont_switch_cmap	Dont_switch_cmap	boolean	false\&\&\&\&\&\&	\-dontswitchcmap
exportLanguage\&	ExportLanguage\&	string	eps\&\&\&\&\&\&\&	\-exportLanguage
flushleft\&\&\&\&	FlushLeft\&\&\&\&	boolean	false\&\&\&\&\&\&	\-flushleft
image_editor\&\&	ImageEditor\&\&\&	string	xv\&\&\&\&\&\&\&	\-image_editor
inches\&\&\&\&\&	Inches\&\&\&\&\&	boolean	true\&\&\&\&\&\&	\-inches,
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&\&	\&\&\&\&\&\&\&\&	\-centimeters,
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&\&	\&\&\&\&\&\&\&\&	\-imperial,
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&\&	\&\&\&\&\&\&\&\&	\-metric
internalborderwidth	InternalBorderWidth	integer	1\&\&\&\&\&\&\&\&	\-internalBW
justify\&\&\&\&\&	Justify\&\&\&\&\&	boolean	false\&\&\&\&\&\&	\-left (false),
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&\&	\&\&\&\&\&\&\&\&	\-right (true)
keyFile\&\&\&\&\&	KeyFile\&\&\&\&\&	string	CompKeyDB\&\&\&\&	\-keyFile
landscape\&\&\&\&	Orientation\&\&\&	boolean	true\&\&\&\&\&\&	\-Landscape,
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&\&	\&\&\&\&\&\&\&\&	\-Portrait
latexfonts\&\&\&	Latexfonts\&\&\&	boolean	off\&\&\&\&\&\&\&	\-latexfonts
max_image_colors\&	Max_image_colors	integer	100\&\&\&\&\&\&	\-max_image_colors
monochrome\&\&\&\&	Monochrome\&\&\&	boolean	false\&\&\&\&\&\&	\-monochrome
normalFont\&\&\&	Font\&\&\&	string	6x13\&\&\&\&\&\&	\-normal
pheight\&\&\&\&\&	Height\&\&\&\&\&	float	8(9.5)\&\&\&\&\&	\-pheight
pwidth\&\&\&\&\&	Width\&\&\&\&\&\&	float	10(8)\&\&\&\&\&\&	\-pwidth
reverseVideo\&\&	ReverseVideo\&\&	boolean	off\&\&\&\&\&\&\&	\-inverse
rulerthick\&\&\&	RulerThick\&\&\&	integer	24\&\&\&\&\&\&\&	\-rulerthick
scalablefonts\&\&	ScalableFonts\&\&	boolean	true\&\&\&\&\&\&	\-scalablefonts
showallbuttons\&	ShowAllButtons\&	boolean	false\&\&\&\&\&\&	\-showallbuttons
specialtext\&\&\&	SpecialText\&\&\&	boolean	false\&\&\&\&\&\&	\-specialtext
startfillstyle\&\&	startFillStyle\&	integer	0\&\&\&\&\&\&\&\&	\-startfillstyle
startfontsize\&\&	StartFontSize\&\&	float	12\&\&\&\&\&\&\&	\-startfontsize
startgridmode\&\&	startGridMode\&\&	integer	0\&\&\&\&\&\&\&\&	\-startgridmode
startlatexFont\&	StartlatexFont\&	string	Default\&\&\&\&\&	\-startlatexFont
startlinewidth\&	startLineWidth\&	integer	1\&\&\&\&\&\&\&\&	\-startlinewidth
startpsFont\&\&\&	StartpsFont\&\&\&	string	Times\-Roman\&\&\&	\-startpsFont
starttextstep\&\&	startTextStep\&\&	float	1.2\&\&\&\&\&\&\&	\-starttextstep
trackCursor\&\&\&\&	Track\&\&\&\&\&\&	boolean	on\&\&\&\&\&\&\&	\-track,
\&\&\&\&\&\&\&\&	\&\&\&\&\&\&\&\&	\&\&\&	\&\&\&\&\&\&\&\&	\-notrack
userscale\&\&\&\&	UserScale\&\&\&\&	float	1.0\&\&\&\&\&\&\&	\-userscale
userunit\&\&\&\&	UserUnit\&\&\&\&	string	in(cm)\&\&\&\&\&	\-userunit
.if n \l'\nnu\&-'
.if t \l'\nnu'
.if n .RE
.if t .RE
.fi
.DT
.\"--------------------------------------------------------------------
.\" Table End
.\"--------------------------------------------------------------------
.PP
The following are the default keyboard accelerators as distributed
in the
.B Fig.ad
app-defaults file:
.PP
.\"--------------------------------------------------------------------
.\" Table Begin
.\"--------------------------------------------------------------------
.nf
.nr t0 8m
.\" set tab stop 1 to length of longest entry in column 1
.nr t1 \n(t0u+\w'<Shift>m\0\0\0\0'u
.ta \n(t0u \n(t1u
.\" set n to length of longest line
.di xx
	<Meta>l	(re)Load figure from current file
.nr n \n(.nu
.di
.rm xx
.\" HEADER
(Context)
	Keys	Function
.if n \l'\nnu\&-'
.if t \l'\nnu'
.\" DATA
(Main xfig panels)
	<Meta>q	Quit xfig
	<Meta>d	Delete all objects from canvas
	<Meta>u	Undo
	<Meta>r	Redraw
	<Ctrl>l	Redraw
	<Meta>t	pasTe xfig cutbuffer onto canvas
	<Meta>f	popup File menu
	<Meta>e	popup Export menu
	<Meta>p	popup Print menu
	<Meta>l	(re)Load figure from current file
	<Meta>s	Save figure to current file
.Sp
(Popup units panel in corner of rulers)
	<Meta>c	Cancel popup unit panel
	<Meta>s	Set units
.Sp
(Popup file panel)
	<Meta>r	Rescan current directory
	<Meta>c	Cancel
	<Meta>l	Load figure
	<Meta>s	Save figure
	<Meta>m	Merge read into current figure
.Sp
(Popup export panel)
	<Meta>r	Rescan current dirctory
	<Meta>c	Cancel
	<Meta>e	Export figure
.Sp
(Popup print panel)
	<Meta>c	Cancel
	<Meta>b	print to Batch file
	<Meta>p	Print to printer
	<Meta>x	clear batch file
.Sp
(Canvas)
	<None>c	Draw circle by radius
	<Shift>c	Draw circle by diameter
	<None>e	Draw ellipse by radius
	<Shift>e	Draw ellipse by diameter
	<Shift>s	Draw closed spline
	<None>s	Draw open spline
	<Shift>i	Draw closed interpolated spline
	<None>i	Draw open interpolated spline
	<None>p	Draw polygon
	<None>l	Draw line
	<None>b	Draw box
	<Shift>b	Draw arcbox
	<Shift>p	Draw regular polygon
	<None>r	Draw arc
	<Ctrl>p	Draw picture object
	<None>t	Draw text

	<None>g	Glue compound
	<Shift>g	Break compound
	<Ctrl>s	Scale object
	<None>a	Align object in compound
	<Shift>m	Move point
	<None>m	Move object
	<Ctrl>a	Add point to object
	<Ctrl>c	Copy object
	<Shift>d	Delete point from object
	<None>d	Delete object
	<None>u	Update object or indicator panel
	<Ctrl>e	Edit object
	<None>f	Flip object up/down
	<Shift>f	Flip object left/right
	<Ctrl>r	Rotate object clockwise
	<Shift>r	Rotate object counter-clockwise
	<None>v	Convert object to/from line/spline or box/arc-box
	<Shift>a	Add/delete arrowhead
.<if>n \l'\nnu\&-'
.if t \l'\nnu'
.DT
.fi
.\"--------------------------------------------------------------------
.\" Table End
.\"--------------------------------------------------------------------
.SH WIDGET TREE
Below is the widget structure of
.IR xfig .
The widget class name is given first, followed by the widget instance name.
.nf
.if t .ta .5i +.5i +.5i +.5i +.5i +.5i +.5i +.5i +.5i
.if n .ta 2n  +2n  +2n  +2n  +2n  +2n  +2n  +2n  +2n
.Sp
Fig  xfig
	Form  form
		Form  commands
			Command  quit
			Command  delete_all
			Command  orient
			Command  undo
			Command  redraw
			Command  paste
			Command  file
			Command  export
			Command  print
		Form msg_form
			Text  message
			Label  file_name
		Label  mouse_panel
		Box  mode_panel
			Label  label
			Command  button (one for each of the 16 drawing mode buttons)
			Label  label
			Command  button (one for each of the 18 editing mode buttons)
		Label  topruler
		Label  canvas
		Label  unitbox
		Label  sideruler
		Box  upd_ctrl_form
			Label upd_ctrl_label
			Box   upd_ctrl_btns
				Command  set_upd
				Command  clr_upd
				Command  tog_upd
		Viewport ind_panel
			Core  clip
			Scrollbar  horizontal
			Box  ind_box
				Form  button_form (one for each of the 22 indicator buttons)
					Command  button
					Toggle  update (only those indicators that affect creation
							of objects have update toggles)
.Sp
		TransientShell  ps_font_menu
			Box  menu
				Form  ps_buttons
					Command  cancel
					Command  use_latex_fonts
				Command  pane (one for each of the 35 PostScript font panes)
.Sp
		TransientShell  latex_font_menu
			Box  menu
				Form  latex_buttons
					Command  cancel
					Command  use_postscript_fonts
				Command  pane (one for each of the 6 LaTeX font panes)
.Sp
	TransientShell  file_menu
		Form  file_panel
			Label  file_status
			Label  num_objects
			Label  cur_file_label
			Text  cur_file_name
			Label  file_label
			Text  file_name
			Label file_alt_label
			Viewport  vport
				Core  clip
				Scrollbar  vertical
				List  file_list_panel
			Label  mask_label
			Text  mask
			Label  dir_label
			Text  dir_name
			Label  dir_alt_label
			Command home
			Viewport  dirvport
				Core  clip
				Scrollbar  vertical
				List  dir_list_panel
			Command  rescan
			Command  cancel
			Command  save
			Command  load
			Command  merge
			Label  fig_offset_label
			Label  fig_offset_lbl_x
			Text  fig_offset_x
			MenuButton   Inches  
				SimpleMenu  menu
					SmeBSB   Inches  
					SmeBSB   Centim. 
					SmeBSB  Fig Units
			Label  fig_offset_lbl_x
			Text  fig_offset_x
			MenuButton   Inches  
				SimpleMenu  menu
					SmeBSB   Inches  
					SmeBSB   Centim. 
					SmeBSB  Fig Units
.Sp
	TransientShell  export_menu
		Form  export_panel
			Label  mag_label
			Text  magnification
			Label  orient_label
			MenuButton  orientation
				SimpleMenu  menu
					SmeBSB  portrait
					SmeBSB  landscape
			Label  just_label
			MenuButton  justify
				SimpleMenu  menu
					SmeBSB  Flush left
					SmeBSB  Centered
			Label  export_offset_label
			Label  export_offset_lbl_x
			Text  export_offset_x
			MenuButton   Inches  
				SimpleMenu  menu
					SmeBSB   Inches  
					SmeBSB   Centim. 
					SmeBSB  Fig Units
			Label  export_offset_lbl_y
			Text  export_offset_y
			MenuButton   Inches  
				SimpleMenu  menu
					SmeBSB   Inches  
					SmeBSB   Centim. 
					SmeBSB  Fig Units
			Label  lang_label
			MenuButton  language
				SimpleMenu  menu
					SmeBSB  LaTeX box (figure boundary)
					SmeBSB  LaTeX picture
					SmeBSB  LaTeX picture + epic macros
					SmeBSB  LaTeX picture + eepic macros
					SmeBSB  LaTeX picture + eepicemu macros
					SmeBSB  PiCTeX macros
					SmeBSB  IBMGL (or HPGL)
					SmeBSB  Encapsulated PostScript
					SmeBSB  PostScript
					SmeBSB  Combined PS/LaTeX (PS part)
					SmeBSB  Combined PS/LaTeX (LaTeX part)
					SmeBSB  Textyl \especial commands
					SmeBSB  TPIC
					SmeBSB  PIC
					SmeBSB  MF
					SmeBSB  GIF
					SmeBSB  JPEG
					SmeBSB  X11 Bitmap
					SmeBSB  X11 Pixmap
			Label  def_file_label
			Label  def_file_name
			Label  out_file_name
			Text  file
			Label  file_alt_label
			Viewport  vport
				Core  clip
				Scrollbar  vertical
				List  file_list_panel
			Label  mask_label
			Text  mask
			Label  dir_label
			Text  dir_name
			Label  dir_alt_label
			Command home
			Viewport  dirvport
				Core  clip
				Scrollbar  vertical
				List  dir_list_panel
			Command  rescan
			Command  cancel
			Command  export
.Sp
	TransientShell  print_menu
		Form  print_panel
			Label  printer_image
			Label  print_label
			Label  mag_label
			Text  magnification
			Label  orient_label
			MenuButton  landscape
				SimpleMenu  menu
					SmeBSB  portrait
					SmeBSB  landscape
			Label  just_label
			MenuButton  justify
				SimpleMenu  menu
					SmeBSB  flush left
					SmeBSB  centered
			Label  printer_label
			Text  printer
			Label  job_params_label
			Text  job_params
			Label  num_batch_label
			Label  num_batch
			Command  dismiss
			Command  print
			Command  print_batch
			Command  clear_batch
.Sp
	TransientShell  file_msg
		Form  file_msg_panel
			Text  file_msg_win
			Command  dismiss
			Command  clear
.Sp
	TransientShell  query_popup
		Form  query_form
			Label  message
			Command  yes
			Command  no
			Command  cancel
.Sp
	TransientShell  set_unit_panel
		Form  form
			Label        Unit/Scale settings
			Label  Ruler Units  =
			MenuButton  Imperial (in)
				SimpleMenu  menu
					SmeBSB  Metric (cm)
					SmeBSB  Imperial (in)
			Label  Figure units =
			MenuButton  Ruler units
				SimpleMenu  menu
					SmeBSB  Ruler units
					SmeBSB  User defined
			Label  user_units
			Text        Unit/Scale settings
			Label  Figure scale =
			MenuButton  User defined
				SimpleMenu  menu
					SmeBSB  Unity
					SmeBSB  User defined
			Label  scale_factor
			Text  1.0000
			Command  cancel
			Command  set
.Sp
Popup color panel:
	TransientShell  set_indicator_panel
		Form  form
			Label  Colors
			Command  cancel
			Command  set_color_ok
			Form  mixedForm (for Pen Color)
				Toggle  mixedEdit
				Core  mixedColor
				Text  tripleValue
			Form  mixedForm (for Fill Color)
				Toggle  mixedEdit
				Core  mixedColor
				Text  tripleValue
			Label  stdLabel
			Form  stdForm
				Command  stdColor (one for each of 33 std colors)
			Label  userLabel
			Form  userForm
				Viewport  userViewport
					Core  clip
					Scrollbar  horizontal
					Box  userBox
					   Label  colorMemory (one for each user color)
				Command  addColor
				Command  delColor
				Command  undelColor
				Form  mixingForm
					Label  redLocked
					Label  greenLocked
					Label  blueLocked
					Label  lockedLabel
					Scrollbar  redScroll
					Scrollbar  greenScroll
					Scrollbar  blueScroll
					Scrollbar  lockedScroll
					Label  hueLabel
					Label  satLabel
					Label  valLabel
					Scrollbar  hueScroll
					Scrollbar  satScroll
					Scrollbar  valScroll
.fi
.Sp
NOTE:  The following is a
.I typical
popup edit panel (for
.IR ARC-BOX )
The panel will be different for other objects.
.Sp
.nf
	TransientShell  edit_panel
		Form  form
			Label  POLYLINE:ArcBox
			Label  image
			Command  done
			Command  apply
			Command  cancel
			Label
			Label  Width =
			Text  Width =
			Label  Border color =
			MenuButton  colors
				SimpleMenu  menu
					SmeBSB  Black
					SmeBSB  Blue
					SmeBSB  Green
					SmeBSB  Cyan
					SmeBSB  Red
					SmeBSB  Magenta
					SmeBSB  Yellow
					SmeBSB  White
					SmeBSB  Blue4
					[22 more colors]
					SmeBSB  Default
			Label  Fill color =
			MenuButton  colors
				SimpleMenu  menu
					SmeBSB  Black
					SmeBSB  Blue
					SmeBSB  Green
					SmeBSB  Cyan
					SmeBSB  Red
					SmeBSB  Magenta
					SmeBSB  Yellow
					SmeBSB  White
					SmeBSB  Blue4
					[22 more colors]
					SmeBSB  Default
			Label  Depth =
			Text  Depth =
			Label  Fill style =
			MenuButton  No fill
				SimpleMenu  menu
					SmeBSB  No fill
					SmeBSB  Filled
					SmeBSB  Pattern
			Label  Fill intensity % =
			Text  Fill intensity % =
			Label  Fill pattern = 
			Text  Fill pattern = 
			Label  Line style =
			MenuButton  Solid Line
				SimpleMenu  menu
					SmeBSB  Solid Line
					SmeBSB  Dashed Line
					SmeBSB  Dotted Line
			Label  Dash length/Dot gap =
			Text  Dash length/Dot gap =
			Label  Radius =
			Text  Radius =
			Label  First Corner
			Label  First Corner
			Text  First Corner
			Label  First Corner
			Text  First Corner
			Label  Opposite Corner
			Label  Opposite Corner
			Text  Opposite Corner
			Label  Opposite Corner
			Text  Opposite Corner
.Sp
.fi
The following is the widget structure for the popup browser available
for the
.I Picture Object
edit popup.
.Sp
.nf
	TransientShell  xfig_browse_menu
		Form  browse_panel
			Label  file_label
			Text  file_name
			Label  file_alt_label
			Viewport  vport
				Core  clip
				List  file_list_panel
				Scrollbar  vertical
			Label  mask_label
			Text  mask
			Label  dir_label
			Text  dir_name
			Label  dir_alt_label
			Command  home
			Viewport  dirvport
				Core  clip
				List  dir_list_panel
			Command  rescan
			Command  close
			Command  apply
.fi
.bp
.SH BUGS and RESTRICTIONS
Please send bug reports, fixes, new features etc. to:
.br
bvsmith@lbl.gov
(Brian V. Smith)
.PP
Because of the difference of some fonts in some X servers and the PostScript
fonts on printers, text alignment can be problematic.
.PP
Not all operations employ smart redrawing of objects which are altered
as a by product of the operation.
You may need to use
.I Redraw
in these cases.
.PP
Some servers do not allow bitmaps/pixmaps taller than the screen height
or wider than the screen width.
That is why there is a limit on the width
of the top ruler and height of the side ruler.
If you need wider/taller rulers AND your server allows bigger pixmaps,
you may define
.B MAX_TOPRULER_WD
and/or
.B MAX_SIDERULER_HT
in your Imakefile in the
.I DEFINES
line.
For example,
to have a maximum top ruler width of 1160 pixels, add
.B \-DMAX_TOPRULER_WD=1160
to your
.I DEFINES
line in the Imakefile.
.PP
If the image is panned or the
.I xfig
window iconified and de-iconified
during the middle of an operation (e.g. while drawing a line), the picture
will be distorted.
This can be corrected using
.I Redraw
after the operation is complete.
.PP
Corners of object scaled with point positioning in one of the grid
modes will not always fall on the grid line, but to the closest pixel.
.PP
When zoomed very large, the length of dashes in dashed lines will top out
at 255 pixels long.  This is due to a restriction in X
that the dash list is defined by char (255 pixels maximum for a dash).
The figure will print correctly, however.
.PP
See the
.B README
file for troubleshooting.
.SH "SEE ALSO"
Brian W. Kernighan
.I "PIC \(em A Graphics Language for Typesetting User Manual"
.PP
fig2dev(1)
.RI ( TransFig
package)
.PP
gs(1)
.RI ( Ghostscript
PostScript previewer)
.SH ACKNOWLEDGEMENT
Many thanks goes to Professor Donald E. Fussell who inspired the
creation of this tool.
.SH COPYRIGHT
.nf
Original Copyright (c) 1985 by Supoj Sutanthavibul
Parts Copyright (c) 1994 by Brian V. Smith
Parts Copyright (c) 1991 by Paul King
Other Copyrights may be found in various files
.sp
.fi
.PP
The X Consortium, and any party obtaining a copy of these files from
the X Consortium, directly or indirectly, is granted, free of charge, a
full and unrestricted irrevocable, world-wide, paid up, royalty-free,
nonexclusive right and license to deal in this software and
documentation files (the "Software"), including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons who receive
copies from any such party to do so, with the only requirement being
that this copyright notice remain intact.  This license includes without
limitation a license to do the foregoing actions under any patents of
the party supplying this software to the X Consortium.
.br
No representations are made about suitability of this
software for any purpose.
It is provided ``as is'' without express or
implied warranty.
.PP
.I PostScript
is a trademark of Adobe Systems Incorporated.
.SH FILES
.ft B
.nr n \w'DOC/FORMAT3.1\0\0\0\0'+1n-1/1n
.ft P
.TP \nn
.B CompKeyDB
Data base of compose (meta) key sequences for 8-bit characters.
Must be installed in
.B $(XFIGLIBDIR)
with ``make install'',
or may be specified with command line option
.B \-keyFile
or X toolkit resource keyFile.
See the
.IR Imakefile .
.TP
.B Fig.ad and Fig-color.ad
Application defaults files which are automatically installed
in the system app-defaults directory with the
.I make install
command.
.TP
.B Doc/FORMAT3.1
Description of Fig file format.
.TP
.B CHANGES
Description of bug fixes/new features.
.SH AUTHORS
Many people have contributed to
.IR xfig .
Here is a list of the people who
have contributed the most (in chronological order):
.sp
.B "Version 1:"
.sp 2
.in +4
Original author:
.br
Supoj Sutanthavibul, University of Texas at Austin
.sp
The
.I LaTeX
line drawing modes were contributed by:
.br
Frank Schmuck, Cornell University
.sp
Original X11 port by:
.br
Ken Yap, Rochester
.sp
Variable window sizes, cleanup of X11 port, right hand side panel:
.br
Dana Chee, Bellcore
.sp
Cleanup of color port to X11 by:
.br
John T. Kohl, MIT
.sp
.in -4
.B "Version 2.0:"
.in +4
.sp 2
Area fill, multiple line thicknesses, multiple fonts and font sizes,
bottom panel, line style/thickness,
(and anything else that wasn't written by the others)
by:
.br
Brian Smith
.br
(standard disclaimer applies)
.br
(bvsmith@lbl.gov)
.sp
Popup change-object menu by:
.br
Jon Tombs
.br
Frank Schmuck
.sp
Zooming and panning functions, shift key select mechanism by:
.br
Dieter Pellkofer
.br
Henning Spruth
.sp
Depth feature by:
.br
Mike Lutz
.sp
Cut/Paste by:
.br
Tom Tkacik
.sp
.in -4
.B "Version 2.1:"
.in +4
.sp 2
Indicator panel, file menu popup, print menu popup,
panning with rulers, mouse function window, regular polygon,
rubberbanding of circles/ellipses, filled splines on canvas,
dashed/dotted splines on canvas, update button,
arbitrary angle rotation of objects, alignment in compound,
object scaling, constrained copy/move, corner markers for compound,
context sensitive corner markers, smarter redraw, undo for compound
and point move for boxes, cancel object creation, point positioning
to three resolutions,
.I TransFig
scalable text, hidden text,
special text, save of figure on crash by:
.sp
Paul King (king@cs.uq.oz.au)
.br
with help from:
.br
Brian Smith
and Micah Beck (beck@cs.utk.edu)
.sp
Encapsulated
.I PostScript
importing by:
.br
Brian Boyter
.sp
Pan/zoom with ctrl key/mouse by:
.br
Henning Spruth
.sp
International characters by:
.br
Herve Soulard
.sp
Directory Browser based on XDir by:
.br
Win Treese, Digital Equipment Corporation
.sp
Rotated ellipses by:
.br
James Tough, Dept. of Computer Science, Heriot-Watt University, Scotland
.sp
Rotated text from the
.I xvertext
package by:
.br
Alan Richardson, Space Science Centre, School of MAPS,
University of Sussex
.sp
Popup scale menu and dynamic switching between inches and cm by:
.br
Paul King (king@cs.uq.oz.au)
.sp
Extensive man page formatting revisions by:
.br
David W. Sanderson
.sp
Display Postscript code for IBM RS/6000 by:
.br
Dave Hale (dhale@green.mines.colorado.edu)
.in -4
.sp
.B "Version 3.0:"
.in +4
.sp 2
.br
New arrowhead types, separate pen/fill colors, new file protocol,
more colors with extended color popup panel, new arc style,
new fill patterns (bricks, etc), new line join and cap styles,
export offset and file load offset, XPM import, XBM import and export
(and anything else that wasn't written by the others) by:
.br
Brian Smith
.br
(Note: the color popup panel was based on
.I xcoloredit
by Richard Hesketh)
.sp
GIF output code by:
.br
.nf
E. Chernyaev (chernaev@mx.decnet.ihep.su)                  *
.fi
.sp
GIF import code by:
.br
David Koblas from the giftoppm part of the pbmplus package
.sp
XPM export code (using XPM3 libraries) by:
.br
Karel van Houten (K.H.C.vanHouten@research.ptt.nl)
.sp
Higher figure resolution (1200dpi) by:
.br
Ross Martin (martin@trcsun3.eas.asu.edu)
.sp
Color quantization using neural network by:
.br
Anthony Dekker (dekker@ACM.org)
.br
[NEUQUANT Neural-Net quantization algorithm by Anthony Dekker, 1994.
See "Kohonen neural networks for optimal colour quantization"
in "Network: Computation in Neural Systems" Vol. 5 (1994) pp 351-367.
for a discussion of the algorithm.]
.sp
Floyd-Steinberg algorithm for dithering color images on monochrome
displays lifted from the Pbmplus package by Jef Poskanser.
.sp
rotate/flip objects around/about selected anchor point and multiple
copies of objects by:
.br
Uwe Bonnes (bon@lte.e-technik.uni-erlangen.de)
.in -4
.sp
.B "Version 3.1:"
.sp 2
.in +4
.br
The only difference between protocol version 3.0 and version 3.1 is
that the position of the "magnet" has been shifted by 14 fig units.
In the 2.1 and older versions of xfig the grid was in multiples of 5 fig
units, but they were on intervals 4, 9, 14, 19, etc.
When version 3.0 was created, coordinates were simply multiplied by the
ratio of the resolutions (1200/80 = 15) so values like 4 became 60 instead
of 74 ((4+1)*15 - 1).
.sp
The JPEG import/export code uses the Independent JPEG Group software
(see jpeg/README for details)
.sp
Image browser, editor and screen capture features by:
.br
Jim Daley (jdaley@cix.compulink.co.uk)
.in -4
.sp
Many bug fixes/cleanups etc. by a host of faithful users
.sp
.br
See the
.B CHANGES
file for all the credits
.sp
The
.I TransFig
package was written by Micah Beck and is maintained by Brian Smith
