/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

public class IndexColorModel
extends ColorModel {
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private byte[] a;
    private int[] argb;
    private byte[] cmap;
    private int start;
    private int transparent;
    private int size;

    public IndexColorModel(int bits, int size, byte[] r, byte[] g, byte[] b) {
        super(bits, ColorModel.nArray(bits, 3), ColorSpace.getInstance(1000), false, false, 1, Buffers.smallestAppropriateTransferType(bits));
        this.r = r;
        this.g = g;
        this.b = b;
        this.size = size;
    }

    public IndexColorModel(int bits, int size, byte[] r, byte[] g, byte[] b, int transparent) {
        super(bits, ColorModel.nArray(bits, 4), ColorSpace.getInstance(1000), true, false, 2, Buffers.smallestAppropriateTransferType(bits));
        this.r = r;
        this.g = g;
        this.b = b;
        this.transparent = transparent;
        this.size = size;
    }

    public IndexColorModel(int bits, int size, byte[] r, byte[] g, byte[] b, byte[] a) {
        super(bits, ColorModel.nArray(bits, 4), ColorSpace.getInstance(1000), true, false, 2, Buffers.smallestAppropriateTransferType(bits));
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.size = size;
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha) {
        super(bits, ColorModel.nArray(bits, hasAlpha ? 4 : 3), ColorSpace.getInstance(1000), hasAlpha, false, hasAlpha ? 3 : 1, Buffers.smallestAppropriateTransferType(bits));
        this.cmap = cmap;
        this.start = start;
        this.size = size;
    }

    public IndexColorModel(int bits, int size, byte[] cmap, int start, boolean hasAlpha, int transparent, int transferType) {
        super(bits, ColorModel.nArray(bits, hasAlpha ? 4 : 3), ColorSpace.getInstance(1000), hasAlpha, false, hasAlpha ? 3 : (transparent < 0 ? 1 : 2), transferType);
        this.cmap = cmap;
        this.start = start;
        this.size = size;
    }

    public final int getMapSize() {
        return this.size;
    }

    public final int getTransparentPixel() {
        return this.transparent;
    }

    public final void getReds(byte[] r) {
        if (this.r == null) {
            this.calcRGBArrays();
        }
        System.arraycopy(this.r, 0, r, 0, this.getMapSize());
    }

    public final void getGreens(byte[] g) {
        if (this.g == null) {
            this.calcRGBArrays();
        }
        System.arraycopy(this.g, 0, g, 0, this.getMapSize());
    }

    public final void getBlues(byte[] b) {
        if (this.b == null) {
            this.calcRGBArrays();
        }
        System.arraycopy(this.b, 0, b, 0, this.getMapSize());
    }

    public final void getAlphas(byte[] a) {
        if (this.a == null) {
            this.calcAlphaArray();
        }
        System.arraycopy(this.a, 0, a, 0, this.getMapSize());
    }

    public final void getRGBs(int[] rgb) {
        if (this.argb == null) {
            this.calcARGBArray();
        }
        System.arraycopy(this.argb, 0, rgb, 0, this.getMapSize());
    }

    public int getRed(int pixel) {
        try {
            return this.r[pixel];
        }
        catch (NullPointerException npe) {
            this.calcRGBArrays();
            return this.r[pixel];
        }
    }

    public int getGreen(int pixel) {
        try {
            return this.g[pixel];
        }
        catch (NullPointerException npe) {
            this.calcRGBArrays();
            return this.g[pixel];
        }
    }

    public int getBlue(int pixel) {
        try {
            return this.b[pixel];
        }
        catch (NullPointerException npe) {
            this.calcRGBArrays();
            return this.b[pixel];
        }
    }

    public int getAlpha(int pixel) {
        try {
            return this.a[pixel];
        }
        catch (NullPointerException npe) {
            this.calcAlphaArray();
            return this.a[pixel];
        }
    }

    private void calcRGBArrays() {
        int j = 0;
        boolean hasAlpha = this.hasAlpha();
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        if (hasAlpha) {
            this.a = new byte[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.r[i] = this.cmap[j++];
            this.g[i] = this.cmap[j++];
            this.b[i] = this.cmap[j++];
            if (!this.hasAlpha()) continue;
            this.a[i] = this.cmap[j++];
        }
    }

    private void calcAlphaArray() {
        int transparency = this.getTransparency();
        switch (transparency) {
            case 1: 
            case 2: {
                this.a = ColorModel.nArray((byte)-1, this.size);
                if (transparency != 2) break;
                this.a[this.transparent] = 0;
                break;
            }
            case 3: {
                this.calcRGBArrays();
            }
        }
    }

    private void calcARGBArray() {
        int mapSize = this.getMapSize();
        this.argb = new int[mapSize];
        for (int p = 0; p < mapSize; ++p) {
            this.argb[p] = this.getRGB(p);
        }
    }

    public int getRed(Object inData) {
        return this.getRed(this.getPixelFromArray(inData));
    }

    public int getGreen(Object inData) {
        return this.getGreen(this.getPixelFromArray(inData));
    }

    public int getBlue(Object inData) {
        return this.getBlue(this.getPixelFromArray(inData));
    }

    public int getAlpha(Object inData) {
        return this.getAlpha(this.getPixelFromArray(inData));
    }

    public int getRGB(Object inData) {
        return this.getRGB(this.getPixelFromArray(inData));
    }

    public Object getDataElements(int rgb, Object pixel) {
        int av = rgb >>> 24 & 0xFF;
        int rv = rgb >>> 16 & 0xFF;
        int gv = rgb >>> 8 & 0xFF;
        int bv = rgb >>> 0 & 0xFF;
        int pixelValue = this.getPixelValue(av, rv, gv, bv);
        DataBuffer buffer = Buffers.createBuffer(this.transferType, pixel, 1);
        buffer.setElem(0, pixelValue);
        return Buffers.getData(buffer);
    }

    private int getPixelValue(int av, int rv, int gv, int bv) {
        if (this.r == null) {
            this.calcRGBArrays();
        }
        if (this.a == null) {
            this.calcAlphaArray();
        }
        int minDAlpha = 256;
        int minDRGB = 196608;
        int pixelValue = -1;
        for (int i = 0; i < this.size; ++i) {
            int dB;
            int dG;
            int dR;
            int dRGB;
            int dAlpha = Math.abs(av - (this.a[i] & 0xFF));
            if (dAlpha > minDAlpha || (dRGB = (dR = rv - (this.r[i] & 0xFF)) * dR + (dG = gv - (this.g[i] & 0xFF)) * dG + (dB = bv - (this.b[i] & 0xFF)) * dB) >= minDRGB) continue;
            pixelValue = i;
            minDRGB = dRGB;
        }
        return pixelValue;
    }

    public int[] getComponents(int pixel, int[] components, int offset) {
        int numComponents = this.getNumComponents();
        if (components == null) {
            components = new int[offset + numComponents];
        }
        components[offset++] = this.r[pixel] & 0xFF;
        components[offset++] = this.g[pixel] & 0xFF;
        components[offset++] = this.b[pixel] & 0xFF;
        if (this.hasAlpha()) {
            components[offset++] = this.a[pixel] & 0xFF;
        }
        return components;
    }

    public final int[] getComponents(Object pixel, int[] components, int offset) {
        return this.getComponents(this.getPixelFromArray(pixel), components, offset);
    }

    public int getDataElement(int[] components, int offset) {
        int r = components[offset++];
        int g = components[offset++];
        int b = components[offset++];
        int a = this.hasAlpha() ? components[offset++] : 255;
        return this.getPixelValue(a, r, g, b);
    }

    public Object getDataElements(int[] components, int offset, Object pixel) {
        int pixelValue = this.getDataElement(components, offset);
        DataBuffer buffer = Buffers.createBuffer(this.transferType, pixel, 1);
        buffer.setElem(0, pixelValue);
        return Buffers.getData(buffer);
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        int[] bandOffsets = new int[]{0};
        return new ComponentSampleModel(this.transferType, w, h, 1, w, bandOffsets);
    }
}

