/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Provider;
import java.util.Properties;
import java.util.Vector;

public final class Security {
    private static Vector providers = new Vector();
    private static Properties secprops;

    private Security() {
    }

    private static void loadProviders(String vendor) {
        if (vendor == null) {
            return;
        }
        String separator = System.getProperty("file.separator");
        String secfilestr = System.getProperty("java.home") + separator + "lib" + separator + "security" + separator + vendor + ".security";
        try {
            String name;
            FileInputStream fin = new FileInputStream(secfilestr);
            secprops = new Properties();
            secprops.load(fin);
            int i = 1;
            while ((name = secprops.getProperty("security.provider." + i++)) != null) {
                Exception exception = null;
                try {
                    providers.addElement(Class.forName(name).newInstance());
                    ++i;
                }
                catch (ClassNotFoundException x) {
                    exception = x;
                }
                catch (InstantiationException x) {
                    exception = x;
                }
                catch (IllegalAccessException x) {
                    exception = x;
                }
                if (exception == null) continue;
                System.err.println("Error loading security provider " + name + ": " + exception);
            }
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getAlgorithmProperty(String algName, String propName) {
        return null;
    }

    public static int insertProviderAt(Provider provider, int position) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("insertProvider." + provider.getName());
        }
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            if (((Provider)providers.elementAt(i)).getName() != provider.getName()) continue;
            return -1;
        }
        if (position < 0) {
            position = 0;
        }
        if (position > max) {
            position = max;
        }
        providers.insertElementAt(provider, position);
        return position;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size());
    }

    public static void removeProvider(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("removeProvider." + name);
        }
        Object p = null;
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            if (((Provider)providers.elementAt(i)).getName() != name) continue;
            providers.remove(i);
            break;
        }
    }

    public static Provider[] getProviders() {
        Object[] array = new Provider[providers.size()];
        providers.copyInto(array);
        return array;
    }

    public static Provider getProvider(String name) {
        Provider p = null;
        int max = providers.size();
        for (int i = 0; i < max && (p = (Provider)providers.elementAt(i)).getName() != name; ++i) {
        }
        return p;
    }

    public static String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("getProperty." + key);
        }
        return secprops.getProperty(key);
    }

    public static void setProperty(String key, String datnum) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setProperty." + key);
        }
        secprops.put(key, datnum);
    }

    static {
        Security.loadProviders(System.getProperty("java.vm.name"));
        Security.loadProviders("classpath");
    }
}

