/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public PushbackInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[n2];
        this.pos = n2;
    }

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.buf.length - this.pos;
        if (n4 > 0) {
            if (n3 < n4) {
                n4 = n3;
            }
            System.arraycopy(this.buf, this.pos, byArray, n2, n4);
            this.pos += n4;
            n2 += n4;
            n3 -= n4;
        }
        if (n3 > 0) {
            if ((n3 = super.read(byArray, n2, n3)) == -1) {
                return n4 == 0 ? -1 : n4;
            }
            return n4 + n3;
        }
        return n4;
    }

    public void unread(int n2) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.buf[--this.pos] = (byte)n2;
    }

    public void unread(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n3 > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= n3;
        System.arraycopy(byArray, n2, this.buf, this.pos, n3);
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.buf.length - this.pos + super.available();
    }

    public long skip(long l2) throws IOException {
        this.ensureOpen();
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = this.buf.length - this.pos;
        if (l3 > 0L) {
            if (l2 < l3) {
                l3 = l2;
            }
            this.pos = (int)((long)this.pos + l3);
            l2 -= l3;
        }
        if (l2 > 0L) {
            l3 += super.skip(l2);
        }
        return l3;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

