/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    private Arrays() {
    }

    public static void sort(long[] lArray) {
        Arrays.sort1(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n2, int n3) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        Arrays.sort1(lArray, n2, n3 - n2);
    }

    public static void sort(int[] nArray) {
        Arrays.sort1(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        Arrays.sort1(nArray, n2, n3 - n2);
    }

    public static void sort(short[] sArray) {
        Arrays.sort1(sArray, 0, sArray.length);
    }

    public static void sort(short[] sArray, int n2, int n3) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        Arrays.sort1(sArray, n2, n3 - n2);
    }

    public static void sort(char[] cArray) {
        Arrays.sort1(cArray, 0, cArray.length);
    }

    public static void sort(char[] cArray, int n2, int n3) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        Arrays.sort1(cArray, n2, n3 - n2);
    }

    public static void sort(byte[] byArray) {
        Arrays.sort1(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n2, int n3) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        Arrays.sort1(byArray, n2, n3 - n2);
    }

    public static void sort(double[] dArray) {
        Arrays.sort2(dArray, 0, dArray.length);
    }

    public static void sort(double[] dArray, int n2, int n3) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        Arrays.sort2(dArray, n2, n3);
    }

    public static void sort(float[] fArray) {
        Arrays.sort2(fArray, 0, fArray.length);
    }

    public static void sort(float[] fArray, int n2, int n3) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        Arrays.sort2(fArray, n2, n3);
    }

    private static void sort2(double[] dArray, int n2, int n3) {
        long l2 = Double.doubleToLongBits(-0.0);
        int n4 = 0;
        int n5 = n2;
        int n6 = n3;
        while (n5 < n6) {
            if (dArray[n5] != dArray[n5]) {
                double d2 = dArray[n5];
                dArray[n5] = dArray[--n6];
                dArray[n6] = d2;
                continue;
            }
            if (dArray[n5] == 0.0 && Double.doubleToLongBits(dArray[n5]) == l2) {
                dArray[n5] = 0.0;
                ++n4;
            }
            ++n5;
        }
        Arrays.sort1(dArray, n2, n6 - n2);
        if (n4 != 0) {
            int n7 = Arrays.binarySearch(dArray, 0.0, n2, n6 - 1);
            while (--n7 >= 0 && dArray[n7] == 0.0) {
            }
            int n8 = 0;
            while (n8 < n4) {
                dArray[++n7] = -0.0;
                ++n8;
            }
        }
    }

    private static void sort2(float[] fArray, int n2, int n3) {
        int n4 = Float.floatToIntBits(-0.0f);
        int n5 = 0;
        int n6 = n2;
        int n7 = n3;
        while (n6 < n7) {
            if (fArray[n6] != fArray[n6]) {
                float f2 = fArray[n6];
                fArray[n6] = fArray[--n7];
                fArray[n7] = f2;
                continue;
            }
            if (fArray[n6] == 0.0f && Float.floatToIntBits(fArray[n6]) == n4) {
                fArray[n6] = 0.0f;
                ++n5;
            }
            ++n6;
        }
        Arrays.sort1(fArray, n2, n7 - n2);
        if (n5 != 0) {
            int n8 = Arrays.binarySearch(fArray, 0.0f, n2, n7 - 1);
            while (--n8 >= 0 && fArray[n8] == 0.0f) {
            }
            int n9 = 0;
            while (n9 < n5) {
                fArray[++n8] = -0.0f;
                ++n9;
            }
        }
    }

    private static void sort1(long[] lArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 7) {
            int n6 = n2;
            while (n6 < n3 + n2) {
                int n7 = n6;
                while (n7 > n2 && lArray[n7 - 1] > lArray[n7]) {
                    Arrays.swap(lArray, n7, n7 - 1);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 + (n3 >> 1);
        if (n3 > 7) {
            int n9 = n2;
            int n10 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n9 = Arrays.med3(lArray, n9, n9 + n5, n9 + 2 * n5);
                n8 = Arrays.med3(lArray, n8 - n5, n8, n8 + n5);
                n10 = Arrays.med3(lArray, n10 - 2 * n5, n10 - n5, n10);
            }
            n8 = Arrays.med3(lArray, n9, n8, n10);
        }
        long l2 = lArray[n8];
        int n11 = n5 = n2;
        int n12 = n4 = n2 + n3 - 1;
        while (true) {
            if (n11 <= n4 && lArray[n11] <= l2) {
                if (lArray[n11] == l2) {
                    Arrays.swap(lArray, n5++, n11);
                }
                ++n11;
                continue;
            }
            while (n4 >= n11 && lArray[n4] >= l2) {
                if (lArray[n4] == l2) {
                    Arrays.swap(lArray, n4, n12--);
                }
                --n4;
            }
            if (n11 > n4) break;
            Arrays.swap(lArray, n11++, n4--);
        }
        int n13 = n2 + n3;
        int n14 = Math.min(n5 - n2, n11 - n5);
        Arrays.vecswap(lArray, n2, n11 - n14, n14);
        n14 = Math.min(n12 - n4, n13 - n12 - 1);
        Arrays.vecswap(lArray, n11, n13 - n14, n14);
        n14 = n11 - n5;
        if (n14 > 1) {
            Arrays.sort1(lArray, n2, n14);
        }
        if ((n14 = n12 - n4) > 1) {
            Arrays.sort1(lArray, n13 - n14, n14);
        }
    }

    private static void swap(long[] lArray, int n2, int n3) {
        long l2 = lArray[n2];
        lArray[n2] = lArray[n3];
        lArray[n3] = l2;
    }

    private static void vecswap(long[] lArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(lArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(long[] lArray, int n2, int n3, int n4) {
        return lArray[n2] < lArray[n3] ? (lArray[n3] < lArray[n4] ? n3 : (lArray[n2] < lArray[n4] ? n4 : n2)) : (lArray[n3] > lArray[n4] ? n3 : (lArray[n2] > lArray[n4] ? n4 : n2));
    }

    private static void sort1(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            int n8 = n2;
            while (n8 < n3 + n2) {
                int n9 = n8;
                while (n9 > n2 && nArray[n9 - 1] > nArray[n9]) {
                    Arrays.swap(nArray, n9, n9 - 1);
                    --n9;
                }
                ++n8;
            }
            return;
        }
        int n10 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(nArray, n7, n7 + n5, n7 + 2 * n5);
                n10 = Arrays.med3(nArray, n10 - n5, n10, n10 + n5);
                n6 = Arrays.med3(nArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n10 = Arrays.med3(nArray, n7, n10, n6);
        }
        n7 = nArray[n10];
        n5 = n6 = n2;
        int n11 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && nArray[n5] <= n7) {
                if (nArray[n5] == n7) {
                    Arrays.swap(nArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && nArray[n4] >= n7) {
                if (nArray[n4] == n7) {
                    Arrays.swap(nArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(nArray, n5++, n4--);
        }
        int n12 = n2 + n3;
        int n13 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(nArray, n2, n5 - n13, n13);
        n13 = Math.min(n11 - n4, n12 - n11 - 1);
        Arrays.vecswap(nArray, n5, n12 - n13, n13);
        n13 = n5 - n6;
        if (n13 > 1) {
            Arrays.sort1(nArray, n2, n13);
        }
        if ((n13 = n11 - n4) > 1) {
            Arrays.sort1(nArray, n12 - n13, n13);
        }
    }

    private static void swap(int[] nArray, int n2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
    }

    private static void vecswap(int[] nArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(nArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(int[] nArray, int n2, int n3, int n4) {
        return nArray[n2] < nArray[n3] ? (nArray[n3] < nArray[n4] ? n3 : (nArray[n2] < nArray[n4] ? n4 : n2)) : (nArray[n3] > nArray[n4] ? n3 : (nArray[n2] > nArray[n4] ? n4 : n2));
    }

    private static void sort1(short[] sArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            int n8 = n2;
            while (n8 < n3 + n2) {
                int n9 = n8;
                while (n9 > n2 && sArray[n9 - 1] > sArray[n9]) {
                    Arrays.swap(sArray, n9, n9 - 1);
                    --n9;
                }
                ++n8;
            }
            return;
        }
        int n10 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(sArray, n7, n7 + n5, n7 + 2 * n5);
                n10 = Arrays.med3(sArray, n10 - n5, n10, n10 + n5);
                n6 = Arrays.med3(sArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n10 = Arrays.med3(sArray, n7, n10, n6);
        }
        n7 = sArray[n10];
        n5 = n6 = n2;
        int n11 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && sArray[n5] <= n7) {
                if (sArray[n5] == n7) {
                    Arrays.swap(sArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && sArray[n4] >= n7) {
                if (sArray[n4] == n7) {
                    Arrays.swap(sArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(sArray, n5++, n4--);
        }
        int n12 = n2 + n3;
        int n13 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(sArray, n2, n5 - n13, n13);
        n13 = Math.min(n11 - n4, n12 - n11 - 1);
        Arrays.vecswap(sArray, n5, n12 - n13, n13);
        n13 = n5 - n6;
        if (n13 > 1) {
            Arrays.sort1(sArray, n2, n13);
        }
        if ((n13 = n11 - n4) > 1) {
            Arrays.sort1(sArray, n12 - n13, n13);
        }
    }

    private static void swap(short[] sArray, int n2, int n3) {
        short s2 = sArray[n2];
        sArray[n2] = sArray[n3];
        sArray[n3] = s2;
    }

    private static void vecswap(short[] sArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(sArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(short[] sArray, int n2, int n3, int n4) {
        return sArray[n2] < sArray[n3] ? (sArray[n3] < sArray[n4] ? n3 : (sArray[n2] < sArray[n4] ? n4 : n2)) : (sArray[n3] > sArray[n4] ? n3 : (sArray[n2] > sArray[n4] ? n4 : n2));
    }

    private static void sort1(char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            int n8 = n2;
            while (n8 < n3 + n2) {
                int n9 = n8;
                while (n9 > n2 && cArray[n9 - 1] > cArray[n9]) {
                    Arrays.swap(cArray, n9, n9 - 1);
                    --n9;
                }
                ++n8;
            }
            return;
        }
        int n10 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(cArray, n7, n7 + n5, n7 + 2 * n5);
                n10 = Arrays.med3(cArray, n10 - n5, n10, n10 + n5);
                n6 = Arrays.med3(cArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n10 = Arrays.med3(cArray, n7, n10, n6);
        }
        n7 = cArray[n10];
        n5 = n6 = n2;
        int n11 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && cArray[n5] <= n7) {
                if (cArray[n5] == n7) {
                    Arrays.swap(cArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && cArray[n4] >= n7) {
                if (cArray[n4] == n7) {
                    Arrays.swap(cArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(cArray, n5++, n4--);
        }
        int n12 = n2 + n3;
        int n13 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(cArray, n2, n5 - n13, n13);
        n13 = Math.min(n11 - n4, n12 - n11 - 1);
        Arrays.vecswap(cArray, n5, n12 - n13, n13);
        n13 = n5 - n6;
        if (n13 > 1) {
            Arrays.sort1(cArray, n2, n13);
        }
        if ((n13 = n11 - n4) > 1) {
            Arrays.sort1(cArray, n12 - n13, n13);
        }
    }

    private static void swap(char[] cArray, int n2, int n3) {
        char c2 = cArray[n2];
        cArray[n2] = cArray[n3];
        cArray[n3] = c2;
    }

    private static void vecswap(char[] cArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(cArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(char[] cArray, int n2, int n3, int n4) {
        return cArray[n2] < cArray[n3] ? (cArray[n3] < cArray[n4] ? n3 : (cArray[n2] < cArray[n4] ? n4 : n2)) : (cArray[n3] > cArray[n4] ? n3 : (cArray[n2] > cArray[n4] ? n4 : n2));
    }

    private static void sort1(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n3 < 7) {
            int n8 = n2;
            while (n8 < n3 + n2) {
                int n9 = n8;
                while (n9 > n2 && byArray[n9 - 1] > byArray[n9]) {
                    Arrays.swap(byArray, n9, n9 - 1);
                    --n9;
                }
                ++n8;
            }
            return;
        }
        int n10 = n2 + (n3 >> 1);
        if (n3 > 7) {
            n7 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n7 = Arrays.med3(byArray, n7, n7 + n5, n7 + 2 * n5);
                n10 = Arrays.med3(byArray, n10 - n5, n10, n10 + n5);
                n6 = Arrays.med3(byArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n10 = Arrays.med3(byArray, n7, n10, n6);
        }
        n7 = byArray[n10];
        n5 = n6 = n2;
        int n11 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && byArray[n5] <= n7) {
                if (byArray[n5] == n7) {
                    Arrays.swap(byArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && byArray[n4] >= n7) {
                if (byArray[n4] == n7) {
                    Arrays.swap(byArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(byArray, n5++, n4--);
        }
        int n12 = n2 + n3;
        int n13 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(byArray, n2, n5 - n13, n13);
        n13 = Math.min(n11 - n4, n12 - n11 - 1);
        Arrays.vecswap(byArray, n5, n12 - n13, n13);
        n13 = n5 - n6;
        if (n13 > 1) {
            Arrays.sort1(byArray, n2, n13);
        }
        if ((n13 = n11 - n4) > 1) {
            Arrays.sort1(byArray, n12 - n13, n13);
        }
    }

    private static void swap(byte[] byArray, int n2, int n3) {
        byte by = byArray[n2];
        byArray[n2] = byArray[n3];
        byArray[n3] = by;
    }

    private static void vecswap(byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(byArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(byte[] byArray, int n2, int n3, int n4) {
        return byArray[n2] < byArray[n3] ? (byArray[n3] < byArray[n4] ? n3 : (byArray[n2] < byArray[n4] ? n4 : n2)) : (byArray[n3] > byArray[n4] ? n3 : (byArray[n2] > byArray[n4] ? n4 : n2));
    }

    private static void sort1(double[] dArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < 7) {
            int n6 = n2;
            while (n6 < n3 + n2) {
                int n7 = n6;
                while (n7 > n2 && dArray[n7 - 1] > dArray[n7]) {
                    Arrays.swap(dArray, n7, n7 - 1);
                    --n7;
                }
                ++n6;
            }
            return;
        }
        int n8 = n2 + (n3 >> 1);
        if (n3 > 7) {
            int n9 = n2;
            int n10 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n9 = Arrays.med3(dArray, n9, n9 + n5, n9 + 2 * n5);
                n8 = Arrays.med3(dArray, n8 - n5, n8, n8 + n5);
                n10 = Arrays.med3(dArray, n10 - 2 * n5, n10 - n5, n10);
            }
            n8 = Arrays.med3(dArray, n9, n8, n10);
        }
        double d2 = dArray[n8];
        int n11 = n5 = n2;
        int n12 = n4 = n2 + n3 - 1;
        while (true) {
            if (n11 <= n4 && dArray[n11] <= d2) {
                if (dArray[n11] == d2) {
                    Arrays.swap(dArray, n5++, n11);
                }
                ++n11;
                continue;
            }
            while (n4 >= n11 && dArray[n4] >= d2) {
                if (dArray[n4] == d2) {
                    Arrays.swap(dArray, n4, n12--);
                }
                --n4;
            }
            if (n11 > n4) break;
            Arrays.swap(dArray, n11++, n4--);
        }
        int n13 = n2 + n3;
        int n14 = Math.min(n5 - n2, n11 - n5);
        Arrays.vecswap(dArray, n2, n11 - n14, n14);
        n14 = Math.min(n12 - n4, n13 - n12 - 1);
        Arrays.vecswap(dArray, n11, n13 - n14, n14);
        n14 = n11 - n5;
        if (n14 > 1) {
            Arrays.sort1(dArray, n2, n14);
        }
        if ((n14 = n12 - n4) > 1) {
            Arrays.sort1(dArray, n13 - n14, n14);
        }
    }

    private static void swap(double[] dArray, int n2, int n3) {
        double d2 = dArray[n2];
        dArray[n2] = dArray[n3];
        dArray[n3] = d2;
    }

    private static void vecswap(double[] dArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(dArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(double[] dArray, int n2, int n3, int n4) {
        return dArray[n2] < dArray[n3] ? (dArray[n3] < dArray[n4] ? n3 : (dArray[n2] < dArray[n4] ? n4 : n2)) : (dArray[n3] > dArray[n4] ? n3 : (dArray[n2] > dArray[n4] ? n4 : n2));
    }

    private static void sort1(float[] fArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 < 7) {
            int n7 = n2;
            while (n7 < n3 + n2) {
                int n8 = n7;
                while (n8 > n2 && fArray[n8 - 1] > fArray[n8]) {
                    Arrays.swap(fArray, n8, n8 - 1);
                    --n8;
                }
                ++n7;
            }
            return;
        }
        int n9 = n2 + (n3 >> 1);
        if (n3 > 7) {
            int n10 = n2;
            n6 = n2 + n3 - 1;
            if (n3 > 40) {
                n5 = n3 / 8;
                n10 = Arrays.med3(fArray, n10, n10 + n5, n10 + 2 * n5);
                n9 = Arrays.med3(fArray, n9 - n5, n9, n9 + n5);
                n6 = Arrays.med3(fArray, n6 - 2 * n5, n6 - n5, n6);
            }
            n9 = Arrays.med3(fArray, n10, n9, n6);
        }
        float f2 = fArray[n9];
        n5 = n6 = n2;
        int n11 = n4 = n2 + n3 - 1;
        while (true) {
            if (n5 <= n4 && fArray[n5] <= f2) {
                if (fArray[n5] == f2) {
                    Arrays.swap(fArray, n6++, n5);
                }
                ++n5;
                continue;
            }
            while (n4 >= n5 && fArray[n4] >= f2) {
                if (fArray[n4] == f2) {
                    Arrays.swap(fArray, n4, n11--);
                }
                --n4;
            }
            if (n5 > n4) break;
            Arrays.swap(fArray, n5++, n4--);
        }
        int n12 = n2 + n3;
        int n13 = Math.min(n6 - n2, n5 - n6);
        Arrays.vecswap(fArray, n2, n5 - n13, n13);
        n13 = Math.min(n11 - n4, n12 - n11 - 1);
        Arrays.vecswap(fArray, n5, n12 - n13, n13);
        n13 = n5 - n6;
        if (n13 > 1) {
            Arrays.sort1(fArray, n2, n13);
        }
        if ((n13 = n11 - n4) > 1) {
            Arrays.sort1(fArray, n12 - n13, n13);
        }
    }

    private static void swap(float[] fArray, int n2, int n3) {
        float f2 = fArray[n2];
        fArray[n2] = fArray[n3];
        fArray[n3] = f2;
    }

    private static void vecswap(float[] fArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            Arrays.swap(fArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(float[] fArray, int n2, int n3, int n4) {
        return fArray[n2] < fArray[n3] ? (fArray[n3] < fArray[n4] ? n3 : (fArray[n2] < fArray[n4] ? n4 : n2)) : (fArray[n3] > fArray[n4] ? n3 : (fArray[n2] > fArray[n4] ? n4 : n2));
    }

    public static void sort(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length);
    }

    public static void sort(Object[] objectArray, int n2, int n3) {
        Arrays.rangeCheck(objectArray.length, n2, n3);
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, n2, n3);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 7) {
            int n5 = n2;
            while (n5 < n3) {
                int n6 = n5;
                while (n6 > n2 && ((Comparable)objectArray2[n6 - 1]).compareTo((Comparable)objectArray2[n6]) > 0) {
                    Arrays.swap(objectArray2, n6, n6 - 1);
                    --n6;
                }
                ++n5;
            }
            return;
        }
        int n7 = n2 + n3 >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n2, n7);
        Arrays.mergeSort(objectArray2, objectArray, n7, n3);
        if (((Comparable)objectArray[n7 - 1]).compareTo((Comparable)objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n2, objectArray2, n2, n4);
            return;
        }
        int n8 = n2;
        int n9 = n2;
        int n10 = n7;
        while (n8 < n3) {
            objectArray2[n8] = n10 >= n3 || n9 < n7 && ((Comparable)objectArray[n9]).compareTo(objectArray[n10]) <= 0 ? objectArray[n9++] : objectArray[n10++];
            ++n8;
        }
    }

    private static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    public static void sort(Object[] objectArray, Comparator comparator) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        if (comparator == null) {
            Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length);
        } else {
            Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, comparator);
        }
    }

    public static void sort(Object[] objectArray, int n2, int n3, Comparator comparator) {
        Arrays.rangeCheck(objectArray.length, n2, n3);
        Object[] objectArray2 = (Object[])objectArray.clone();
        if (comparator == null) {
            Arrays.mergeSort(objectArray2, objectArray, n2, n3);
        } else {
            Arrays.mergeSort(objectArray2, objectArray, n2, n3, comparator);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n2, int n3, Comparator comparator) {
        int n4 = n3 - n2;
        if (n4 < 7) {
            int n5 = n2;
            while (n5 < n3) {
                int n6 = n5;
                while (n6 > n2 && comparator.compare(objectArray2[n6 - 1], objectArray2[n6]) > 0) {
                    Arrays.swap(objectArray2, n6, n6 - 1);
                    --n6;
                }
                ++n5;
            }
            return;
        }
        int n7 = n2 + n3 >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n2, n7, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n7, n3, comparator);
        if (comparator.compare(objectArray[n7 - 1], objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n2, objectArray2, n2, n4);
            return;
        }
        int n8 = n2;
        int n9 = n2;
        int n10 = n7;
        while (n8 < n3) {
            objectArray2[n8] = n10 >= n3 || n9 < n7 && comparator.compare(objectArray[n9], objectArray[n10]) <= 0 ? objectArray[n9++] : objectArray[n10++];
            ++n8;
        }
    }

    private static void rangeCheck(int n2, int n3, int n4) {
        if (n3 > n4) {
            throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n4 + ")");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        if (n4 > n2) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
    }

    public static int binarySearch(long[] lArray, long l2) {
        int n2 = 0;
        int n3 = lArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            long l3 = lArray[n4];
            if (l3 < l2) {
                n2 = n4 + 1;
                continue;
            }
            if (l3 > l2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = nArray.length - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            int n6 = nArray[n5];
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(short[] sArray, short s2) {
        int n2 = 0;
        int n3 = sArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            short s3 = sArray[n4];
            if (s3 < s2) {
                n2 = n4 + 1;
                continue;
            }
            if (s3 > s2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(char[] cArray, char c2) {
        int n2 = 0;
        int n3 = cArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            char c3 = cArray[n4];
            if (c3 < c2) {
                n2 = n4 + 1;
                continue;
            }
            if (c3 > c2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        int n2 = 0;
        int n3 = byArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            byte by2 = byArray[n4];
            if (by2 < by) {
                n2 = n4 + 1;
                continue;
            }
            if (by2 > by) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(double[] dArray, double d2) {
        return Arrays.binarySearch(dArray, d2, 0, dArray.length - 1);
    }

    private static int binarySearch(double[] dArray, double d2, int n2, int n3) {
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >> 1;
            double d3 = dArray[n5];
            if (d3 < d2) {
                n4 = -1;
            } else if (d3 > d2) {
                n4 = 1;
            } else {
                long l2;
                long l3 = Double.doubleToLongBits(d3);
                int n6 = l3 == (l2 = Double.doubleToLongBits(d2)) ? 0 : (n4 = l3 < l2 ? -1 : 1);
            }
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(float[] fArray, float f2) {
        return Arrays.binarySearch(fArray, f2, 0, fArray.length - 1);
    }

    private static int binarySearch(float[] fArray, float f2, int n2, int n3) {
        while (n2 <= n3) {
            int n4;
            int n5 = n2 + n3 >> 1;
            float f3 = fArray[n5];
            if (f3 < f2) {
                n4 = -1;
            } else if (f3 > f2) {
                n4 = 1;
            } else {
                int n6;
                int n7 = Float.floatToIntBits(f3);
                int n8 = n7 == (n6 = Float.floatToIntBits(f2)) ? 0 : (n4 = n7 < n6 ? -1 : 1);
            }
            if (n4 < 0) {
                n2 = n5 + 1;
                continue;
            }
            if (n4 > 0) {
                n3 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        int n2 = 0;
        int n3 = objectArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Object object2 = objectArray[n4];
            int n5 = ((Comparable)object2).compareTo(object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        if (comparator == null) {
            return Arrays.binarySearch(objectArray, object);
        }
        int n2 = 0;
        int n3 = objectArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            Object object2 = objectArray[n4];
            int n5 = comparator.compare(object2, object);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        int n2 = lArray.length;
        if (lArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (lArray[n3] != lArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] != nArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        int n2 = sArray.length;
        if (sArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (sArray[n3] != sArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n2 = cArray.length;
        if (cArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (cArray[n3] != cArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n2 = byArray.length;
        if (byArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        int n2 = blArray.length;
        if (blArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (blArray[n3] != blArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n2 = dArray.length;
        if (dArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (Double.doubleToLongBits(dArray[n3]) != Double.doubleToLongBits(dArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        int n2 = fArray.length;
        if (fArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (Float.floatToIntBits(fArray[n3]) != Float.floatToIntBits(fArray2[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n2 = objectArray.length;
        if (objectArray2.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray[n3];
            Object object2 = objectArray2[n3];
            if (!(object != null ? object.equals(object2) : object2 == null)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static void fill(long[] lArray, long l2) {
        Arrays.fill(lArray, 0, lArray.length, l2);
    }

    public static void fill(long[] lArray, int n2, int n3, long l2) {
        Arrays.rangeCheck(lArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            lArray[n4] = l2;
            ++n4;
        }
    }

    public static void fill(int[] nArray, int n2) {
        Arrays.fill(nArray, 0, nArray.length, n2);
    }

    public static void fill(int[] nArray, int n2, int n3, int n4) {
        Arrays.rangeCheck(nArray.length, n2, n3);
        int n5 = n2;
        while (n5 < n3) {
            nArray[n5] = n4;
            ++n5;
        }
    }

    public static void fill(short[] sArray, short s2) {
        Arrays.fill(sArray, 0, sArray.length, s2);
    }

    public static void fill(short[] sArray, int n2, int n3, short s2) {
        Arrays.rangeCheck(sArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            sArray[n4] = s2;
            ++n4;
        }
    }

    public static void fill(char[] cArray, char c2) {
        Arrays.fill(cArray, 0, cArray.length, c2);
    }

    public static void fill(char[] cArray, int n2, int n3, char c2) {
        Arrays.rangeCheck(cArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            cArray[n4] = c2;
            ++n4;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n2, int n3, byte by) {
        Arrays.rangeCheck(byArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            byArray[n4] = by;
            ++n4;
        }
    }

    public static void fill(boolean[] blArray, boolean bl2) {
        Arrays.fill(blArray, 0, blArray.length, bl2);
    }

    public static void fill(boolean[] blArray, int n2, int n3, boolean bl2) {
        Arrays.rangeCheck(blArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            blArray[n4] = bl2;
            ++n4;
        }
    }

    public static void fill(double[] dArray, double d2) {
        Arrays.fill(dArray, 0, dArray.length, d2);
    }

    public static void fill(double[] dArray, int n2, int n3, double d2) {
        Arrays.rangeCheck(dArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            dArray[n4] = d2;
            ++n4;
        }
    }

    public static void fill(float[] fArray, float f2) {
        Arrays.fill(fArray, 0, fArray.length, f2);
    }

    public static void fill(float[] fArray, int n2, int n3, float f2) {
        Arrays.rangeCheck(fArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            fArray[n4] = f2;
            ++n4;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(Object[] objectArray, int n2, int n3, Object object) {
        Arrays.rangeCheck(objectArray.length, n2, n3);
        int n4 = n2;
        while (n4 < n3) {
            objectArray[n4] = object;
            ++n4;
        }
    }

    public static List asList(Object[] objectArray) {
        return new ArrayList(objectArray);
    }

    private static class ArrayList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private Object[] a;

        ArrayList(Object[] objectArray) {
            if (objectArray == null) {
                throw new NullPointerException();
            }
            this.a = objectArray;
        }

        public int size() {
            return this.a.length;
        }

        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        public Object get(int n2) {
            return this.a[n2];
        }

        public Object set(int n2, Object object) {
            Object object2 = this.a[n2];
            this.a[n2] = object;
            return object2;
        }

        public int indexOf(Object object) {
            if (object == null) {
                int n2 = 0;
                while (n2 < this.a.length) {
                    if (this.a[n2] == null) {
                        return n2;
                    }
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < this.a.length) {
                    if (object.equals(this.a[n3])) {
                        return n3;
                    }
                    ++n3;
                }
            }
            return -1;
        }

        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }
    }
}

