/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public final class SwingPropertyChangeSupport
extends PropertyChangeSupport {
    private transient EventListenerList listeners;
    private Hashtable children;
    private Object source;
    static final long serialVersionUID = 7162625831330845068L;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public SwingPropertyChangeSupport(Object object) {
        super(object);
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.addPropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.removePropertyChangeListener(propertyChangeListenerProxy.getPropertyName(), (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.listeners != null) {
            arrayList.addAll(Arrays.asList(this.listeners.getListeners(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener)));
        }
        if (this.children != null) {
            Iterator iterator = this.children.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SwingPropertyChangeSupport swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
                PropertyChangeListener[] propertyChangeListenerArray = swingPropertyChangeSupport.getPropertyChangeListeners();
                int n2 = propertyChangeListenerArray.length - 1;
                while (n2 >= 0) {
                    arrayList.add(new PropertyChangeListenerProxy(string, propertyChangeListenerArray[n2]));
                    --n2;
                }
            }
        }
        return (PropertyChangeListener[])arrayList.toArray(new PropertyChangeListener[arrayList.size()]);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) == null) {
            swingPropertyChangeSupport = new SwingPropertyChangeSupport(this.source);
            this.children.put(string, swingPropertyChangeSupport);
        }
        swingPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.children == null) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
        if (swingPropertyChangeSupport == null) {
            return;
        }
        swingPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        ArrayList arrayList = new ArrayList();
        if (this.children != null && (swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) != null) {
            arrayList.addAll(Arrays.asList(swingPropertyChangeSupport.getPropertyChangeListeners()));
        }
        return (PropertyChangeListener[])arrayList.toArray(new PropertyChangeListener[0]);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray;
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        SwingPropertyChangeSupport swingPropertyChangeSupport = null;
        if (this.children != null) {
            objectArray = this;
            synchronized (objectArray) {
                if (this.children != null && string != null) {
                    swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string);
                }
            }
        }
        if (this.listeners != null) {
            objectArray = this.listeners.getListenerList();
            int n2 = 0;
            while (n2 <= objectArray.length - 2) {
                if (objectArray[n2] == (class$java$beans$PropertyChangeListener == null ? SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                    ((PropertyChangeListener)objectArray[n2 + 1]).propertyChange(propertyChangeEvent);
                }
                n2 += 2;
            }
        }
        if (swingPropertyChangeSupport != null) {
            swingPropertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    public synchronized boolean hasListeners(String string) {
        SwingPropertyChangeSupport swingPropertyChangeSupport;
        if (this.listeners != null && this.listeners.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) > 0) {
            return true;
        }
        if (this.children != null && (swingPropertyChangeSupport = (SwingPropertyChangeSupport)this.children.get(string)) != null) {
            return swingPropertyChangeSupport.hasListeners(string);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.listeners != null) {
            Object[] objectArray = this.listeners.getListenerList();
            int n2 = 0;
            while (n2 <= objectArray.length - 2) {
                if (objectArray[n2] == (class$java$beans$PropertyChangeListener == null ? SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener) && (PropertyChangeListener)objectArray[n2 + 1] instanceof Serializable) {
                    objectOutputStream.writeObject((PropertyChangeListener)objectArray[n2 + 1]);
                }
                n2 += 2;
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

