/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class UnionPathIterator
extends Expression
implements Cloneable,
DTMIterator,
Serializable {
    private boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    transient NodeSetDTM m_cachedNodes = null;
    protected transient int m_next = 0;
    transient int m_lastFetched = -1;
    protected transient boolean m_foundLast = false;
    protected transient XPathContext m_execContext;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected DTMIterator[] m_iterators;
    private transient int m_last = 0;

    public UnionPathIterator() {
        this.m_iterators = null;
    }

    public void setRoot(int n2, Object object) {
        this.m_execContext = (XPathContext)object;
        this.m_currentContextNode = n2;
        this.m_context = n2;
        this.m_lastFetched = -1;
        this.m_next = 0;
        this.m_last = 0;
        this.m_foundLast = false;
        try {
            if (null != this.m_iterators) {
                int n3 = this.m_iterators.length;
                int n4 = 0;
                while (n4 < n3) {
                    this.m_iterators[n4] = ((LocPathIterator)this.m_iterators[n4]).asIterator(this.m_execContext, n2);
                    this.m_iterators[n4].setRoot(n2, object);
                    this.m_iterators[n4].nextNode();
                    ++n4;
                }
            }
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    public void allowDetachToRelease(boolean bl2) {
        this.m_allowDetach = bl2;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_cachedNodes = null;
            this.m_execContext = null;
            if (null != this.m_iterators) {
                int n2 = this.m_iterators.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.m_iterators[n3].detach();
                    ++n3;
                }
            }
            this.m_clones.freeInstance(this);
        }
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.m_clones.getInstance();
        int n2 = xPathContext.getCurrentNode();
        unionPathIterator.setRoot(n2, xPathContext);
        return new XNodeSet(unionPathIterator);
    }

    public void setShouldCacheNodes(boolean bl2) {
        this.m_cachedNodes = bl2 ? new NodeSetDTM(this.getDTMManager()) : null;
    }

    public boolean isMutable() {
        return this.m_cachedNodes != null;
    }

    public void setCurrentPos(int n2) {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.m_next = n2;
        this.m_cachedNodes.setCurrentPos(n2);
    }

    public int size() {
        if (null == this.m_cachedNodes) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public int previousNode() {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public int getWhatToShow() {
        return -17;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void addIterator(LocPathIterator locPathIterator) {
        if (null == this.m_iterators) {
            this.m_iterators = new LocPathIterator[1];
            this.m_iterators[0] = locPathIterator;
        } else {
            DTMIterator[] dTMIteratorArray = this.m_iterators;
            int n2 = this.m_iterators.length;
            this.m_iterators = new LocPathIterator[n2 + 1];
            System.arraycopy(dTMIteratorArray, 0, this.m_iterators, 0, n2);
            this.m_iterators[n2] = locPathIterator;
        }
    }

    public UnionPathIterator(Compiler compiler, int n2) throws TransformerException {
        n2 = Compiler.getFirstChildPos(n2);
        this.loadLocationPaths(compiler, n2, 0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.clone();
        unionPathIterator.reset();
        return unionPathIterator;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)super.clone();
        if (this.m_iterators != null) {
            int n2 = this.m_iterators.length;
            unionPathIterator.m_iterators = new LocPathIterator[n2];
            int n3 = 0;
            while (n3 < n2) {
                unionPathIterator.m_iterators[n3] = (LocPathIterator)this.m_iterators[n3].clone();
                ++n3;
            }
        }
        return unionPathIterator;
    }

    public DTMIterator asIterator(XPathContext xPathContext, int n2) throws TransformerException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)this.m_clones.getInstance();
        unionPathIterator.setRoot(n2, xPathContext);
        return unionPathIterator;
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_next = 0;
        this.m_last = 0;
        this.m_lastFetched = -1;
        if (this.m_iterators != null) {
            int n2 = this.m_iterators.length;
            int n3 = 0;
            while (n3 < n2) {
                this.m_iterators[n3].reset();
                this.m_iterators[n3].nextNode();
                ++n3;
            }
        }
    }

    protected void loadLocationPaths(Compiler compiler, int n2, int n3) throws TransformerException {
        int n4 = compiler.getOpMap()[n2];
        if (n4 == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(n2), n3 + 1);
            this.m_iterators[n3] = this.createDTMIterator(compiler, n2);
        } else {
            switch (n4) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(n2), n3 + 1);
                    WalkingIterator walkingIterator = new WalkingIterator(compiler.getNamespaceContext());
                    if (compiler.getLocationPathDepth() <= 0) {
                        walkingIterator.setIsTopLevel(true);
                    }
                    walkingIterator.m_firstWalker = new FilterExprWalker(walkingIterator);
                    walkingIterator.m_firstWalker.init(compiler, n2, n4);
                    this.m_iterators[n3] = walkingIterator;
                    break;
                }
                default: {
                    this.m_iterators = new LocPathIterator[n3];
                }
            }
        }
    }

    protected DTMIterator createDTMIterator(Compiler compiler, int n2) throws TransformerException {
        DTMIterator dTMIterator = WalkerFactory.newDTMIterator(compiler, n2, compiler.getLocationPathDepth() <= 0);
        return dTMIterator;
    }

    public int nextNode() {
        if (null != this.m_cachedNodes && this.m_next < this.m_cachedNodes.size()) {
            int n2 = this.m_cachedNodes.elementAt(this.m_next);
            ++this.m_next;
            this.m_currentContextNode = n2;
            return n2;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        int n3 = -1;
        if (null != this.m_iterators) {
            int n4 = this.m_iterators.length;
            int n5 = -1;
            int n6 = 0;
            while (n6 < n4) {
                int n7 = this.m_iterators[n6].getCurrentNode();
                if (-1 != n7) {
                    if (-1 == n3) {
                        n5 = n6;
                        n3 = n7;
                    } else if (n7 == n3) {
                        this.m_iterators[n6].nextNode();
                    } else {
                        DTM dTM = this.getDTM(n7);
                        if (dTM.isNodeAfter(n7, n3)) {
                            n5 = n6;
                            n3 = n7;
                        }
                    }
                }
                ++n6;
            }
            if (-1 != n3) {
                this.m_iterators[n5].nextNode();
                if (null != this.m_cachedNodes) {
                    this.m_cachedNodes.addElement(n3);
                }
                ++this.m_next;
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = n3;
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        block3: {
            if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
                return;
            }
            if (-1 != var1_1) ** GOTO lbl-1000
            while (-1 != (var2_2 = this.nextNode())) {
            }
            break block3;
            while (this.getCurrentPos() < var1_1) lbl-1000:
            // 2 sources

            {
                if (-1 != (var2_3 = this.nextNode())) continue;
            }
        }
    }

    public int getCurrentPos() {
        return this.m_next;
    }

    public int getLength() {
        if (this.m_last > 0) {
            return this.m_last;
        }
        this.m_last = null == this.m_cachedNodes || !this.m_foundLast ? this.getLastPos(this.m_execContext) : this.m_cachedNodes.getLength();
        return this.m_last;
    }

    public int getLastPos(XPathContext xPathContext) {
        int n2;
        UnionPathIterator unionPathIterator;
        int n3 = this.m_next;
        int n4 = null != this.m_cachedNodes ? this.m_cachedNodes.getCurrentPos() : -1;
        try {
            unionPathIterator = 0 == n3 && this.m_currentContextNode != -1 ? (UnionPathIterator)this.cloneWithReset() : (UnionPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        n3 = unionPathIterator.getCurrentPos();
        while (-1 != (n2 = unionPathIterator.nextNode())) {
            ++n3;
        }
        if (-1 != n4) {
            this.m_cachedNodes.setCurrentPos(n4);
        }
        return n3;
    }

    public int item(int n2) {
        return this.m_cachedNodes.item(n2);
    }

    public void setItem(int n2, int n3) {
        this.m_cachedNodes.setElementAt(n2, n3);
    }

    public final void setRoot(int n2) {
        this.m_context = n2;
    }

    public void setEnvironment(Object object) {
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    public void fixupVariables(Vector vector, int n2) {
        int n3 = 0;
        while (n3 < this.m_iterators.length) {
            DTMIterator dTMIterator = this.m_iterators[n3];
            if (dTMIterator instanceof Expression) {
                ((Expression)((Object)dTMIterator)).fixupVariables(vector, n2);
            }
            ++n3;
        }
    }

    public DTM getDTM(int n2) {
        return this.m_execContext.getDTM(n2);
    }

    public int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int n2) {
        this.m_last = n2;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int getAxis() {
        return -1;
    }
}

