/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.TextLine;

public class MTextAreaPeer
extends MComponentPeer
implements TextAreaPeer {
    static final int MARGIN = 2;
    static final int BORDER = 1;
    static final int SCROLLBAR = 16;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int topLine = 0;
    int numLines = 0;
    int textLength = 0;
    Vector lines;
    int selStart = 0;
    int selEnd = 0;
    int movedRight = 0;

    native void create(MComponentPeer var1);

    void initialize() {
        TextArea textArea = (TextArea)this.target;
        String string = textArea.getText();
        if (string != null) {
            this.setText(string);
        }
        int n2 = textArea.getSelectionStart();
        int n3 = textArea.getSelectionEnd();
        if (n3 > n2) {
            this.select(n2, n3);
        }
        super.pSetScrollbarBackground(MComponentPeer.getParent_NoClientCode(this.target).getBackground());
        if (!this.target.isBackgroundSet()) {
            this.setTargetBackground(SystemColor.text);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setEditable(textArea.isEditable());
        super.initialize();
    }

    public MTextAreaPeer(TextArea textArea) {
        super(textArea);
    }

    public void setEditable(boolean bl2) {
        this.pSetEditable(bl2);
        this.setBackground(this.target.getBackground());
    }

    public void setBackground(Color color) {
        this.setTextBackground(color);
    }

    public void setForeground(Color color) {
        this.pSetInnerForeground(color);
    }

    native int getExtraWidth();

    native int getExtraHeight();

    public native void setTextBackground(Color var1);

    public native void pSetEditable(boolean var1);

    public native void select(int var1, int var2);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native void setText(String var1);

    public native String getText();

    public native void insert(String var1, int var2);

    public native void replaceRange(String var1, int var2, int var3);

    public native void setFont(Font var1);

    public native void setCaretPosition(int var1);

    public native int getCaretPosition();

    public native void pSetCursor(Cursor var1);

    native void pShow2();

    native void pMakeCursorVisible();

    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    public Dimension getPreferredSize(int n2, int n3) {
        return this.getMinimumSize(n2, n3);
    }

    public Dimension getMinimumSize(int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int n4 = fontMetrics.charWidth('0');
        int n5 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        return new Dimension(n3 * n4 + this.getExtraWidth(), n2 * n5 + this.getExtraHeight());
    }

    public boolean isFocusable() {
        return true;
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = this.target.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceRange(string, this.getSelectionStart(), this.getSelectionEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        int n2;
        TextArea textArea = (TextArea)this.target;
        Dimension dimension = textArea.size();
        Color color = textArea.getBackground();
        Color color2 = textArea.getForeground();
        FontMetrics fontMetrics = this.getFontMetrics(textArea.getFont());
        int n3 = 0;
        String string = textArea.getText();
        this.textLength = string.length();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n4 = 0;
        this.lines = new Vector();
        try {
            String string2;
            this.numLines = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                TextLine textLine = new TextLine();
                textLine.text = string2;
                textLine.pos = n4;
                this.lines.addElement(textLine);
                n4 += string2.length() + 1;
                n2 = fontMetrics.stringWidth(string2);
                n3 = Math.max(n3, n2);
                ++this.numLines;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n5 = dimension.width - 18;
        n2 = dimension.height - 18;
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
        int n6 = 0;
        int n7 = 0;
        int n8 = this.linesInWindow(true);
        int n9 = Math.max(this.numLines - n8, 0);
        n2 = dimension.height - 16;
        int n10 = 0;
        n5 = dimension.width - 16;
        int n11 = n5 - 4;
        int n12 = Math.max(n3 - n11, 0);
        int n13 = 0;
        graphics.setColor(color);
        graphics.fillRect(1, 1, n5, n2);
        int n14 = dimension.height - 16;
        graphics.fillRect(dimension.width - 16 - 3, 1, 13, n14 - 1);
        Graphics graphics2 = graphics.create();
        try {
            graphics2.translate(dimension.width - 14, 0);
            this.drawScrollbar(graphics2, color, 14, n14, n6, n9, n10, n8, false);
            Object var25_27 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            graphics2.dispose();
            throw throwable;
        }
        n14 = dimension.width - 16;
        graphics.fillRect(1, dimension.height - 16 - 3, n14 - 1, 13);
        graphics2 = graphics.create();
        try {
            graphics2.translate(0, dimension.height - 14);
            this.drawScrollbar(graphics2, color, 14, n14, n7, n12, n13, n11, true);
            Object var27_30 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var27_31 = null;
            graphics2.dispose();
            throw throwable;
        }
        this.draw3DRect(graphics, color, 0, 0, n5 - 1, n2 - 1, false);
        if (string != null) {
            n14 = this.linesInWindow(true);
            n2 = dimension.height - 20;
            int n15 = Math.min(this.numLines - 1, this.topLine + n14 - 1);
            this.paintLines(graphics, color, color2, this.topLine, n15);
        }
        this.target.print(graphics);
    }

    int linesInWindow(boolean bl2) {
        Dimension dimension = this.target.size();
        int n2 = dimension.height - (4 + (bl2 ? 16 : 0));
        return n2 / this.fontHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintLines(Graphics graphics, Color color, Color color2, int n2, int n3) {
        Dimension dimension = this.target.size();
        int n4 = dimension.width - 18;
        int n5 = dimension.height - 18;
        int n6 = this.linesInWindow(true) + this.topLine;
        n2 = Math.max(this.topLine, n2);
        n3 = Math.min(n3, n6 - 1);
        Graphics graphics2 = graphics.create();
        try {
            graphics2.clipRect(3, 3, n4 - 4, n5 - 4);
            graphics2.setFont(this.target.getFont());
            int n7 = n2;
            while (n7 <= n3) {
                this.paintLine(graphics2, color, color2, n7);
                ++n7;
            }
            Object var13_12 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    void paintLine(Graphics graphics, Color color, Color color2, int n2) {
        Dimension dimension = this.target.size();
        int n3 = this.linesInWindow(true);
        if (n2 < this.topLine || n2 >= n3 + this.topLine) {
            return;
        }
        int n4 = dimension.width - 18;
        int n5 = 2 + this.fontLeading + (n2 - this.topLine) * this.fontHeight;
        String string = ((TextLine)this.lines.elementAt((int)n2)).text;
        int n6 = string.length();
        if (n2 > this.numLines - 1) {
            graphics.setColor(color);
            graphics.fillRect(1, n5 - this.fontLeading, n4, this.fontHeight);
            return;
        }
        int n7 = 0;
        int n8 = n2 < this.numLines - 1 ? n6 : this.textLength;
        int n9 = this.pos2x(this.selStart) - this.movedRight;
        int n10 = this.pos2x(this.selEnd) - this.movedRight;
        Color color3 = color.brighter();
        if (this.selStart < n7 && this.selEnd > n8) {
            graphics.setColor(color3);
            graphics.fillRect(1, n5 - this.fontLeading, n4, this.fontHeight);
        } else {
            graphics.setColor(color);
            graphics.fillRect(1, n5 - this.fontLeading, n4, this.fontHeight);
            if (this.selStart >= n7 && this.selStart <= n8) {
                graphics.setColor(color3);
                if (this.selEnd > n8) {
                    graphics.fillRect(n9, n5 - this.fontLeading, n4 + 1 - n9, this.fontHeight);
                } else if (this.selStart != this.selEnd) {
                    graphics.fillRect(n9, n5 - this.fontLeading, n10 - n9, this.fontHeight);
                }
            } else if (this.selEnd >= n7 && this.selEnd <= n8) {
                graphics.setColor(color3);
                graphics.fillRect(1, n5 - this.fontLeading, n10 - 1, this.fontHeight);
            }
        }
        graphics.setColor(color2);
        graphics.drawString(string, 2 - this.movedRight, n5 + this.fontAscent);
    }

    int pos2x(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int[] nArray = fontMetrics.getWidths();
        TextLine textLine = (TextLine)this.lines.elementAt(0);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.lines.size() - 1) {
            TextLine textLine2 = (TextLine)this.lines.elementAt(n4 + 1);
            if (n2 >= textLine.pos && n2 < textLine2.pos) {
                n3 = n4;
                break;
            }
            textLine = textLine2;
            ++n4;
        }
        int n5 = 2;
        int n6 = 0;
        while (n6 < n2 - textLine.pos - 1) {
            n5 += nArray[textLine.text.charAt(n6)];
            ++n6;
        }
        return n5;
    }

    public void insertText(String string, int n2) {
        this.insert(string, n2);
    }

    public void replaceText(String string, int n2, int n3) {
        this.replaceRange(string, n2, n3);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize(int n2, int n3) {
        return this.getPreferredSize(n2, n3);
    }

    public Dimension minimumSize(int n2, int n3) {
        return this.getMinimumSize(n2, n3);
    }

    public void valueChanged() {
        this.postEvent(new TextEvent(this.target, 900));
    }

    void pShow() {
        this.pShow2();
        this.notifyTextComponentChange(true);
    }

    void pHide() {
        this.notifyTextComponentChange(false);
        super.pHide();
    }

    void pDispose() {
        this.notifyTextComponentChange(false);
        super.pDispose();
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            this.nativeHandleMouseWheel(mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    native void nativeHandleMouseWheel(int var1, int var2, int var3);

    public int getIndexAtPoint(int n2, int n3) {
        return -1;
    }

    public Rectangle getCharacterBounds(int n2) {
        return null;
    }

    public long filterEvents(long l2) {
        return 0L;
    }
}

