/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.ISO_8859_15;
import sun.nio.cs.MS1252;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.UTF_16BE;
import sun.nio.cs.UTF_16LE;
import sun.nio.cs.UTF_8;
import sun.nio.cs.UnicodeDecoder;
import sun.nio.cs.UnicodeEncoder;

class UTF_16
extends Charset
implements HistoricallyNamedCharset {
    public UTF_16() {
        super("UTF-16", StandardCharsets.aliasesFor("UTF-16"));
    }

    public String historicalName() {
        return "UTF-16";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof ISO_8859_15 || charset instanceof MS1252 || charset instanceof UTF_8 || charset instanceof UTF_16 || charset instanceof UTF_16BE || charset instanceof UTF_16LE;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends UnicodeEncoder {
        public Encoder(Charset charset) {
            super(charset, 0, true);
        }

        public boolean canEncode(char c2) {
            if (Surrogate.isHigh(c2) || Surrogate.isLow(c2)) {
                return false;
            }
            return c2 <= '\uffff';
        }
    }

    private static class Decoder
    extends UnicodeDecoder {
        public Decoder(Charset charset) {
            super(charset, 0);
        }
    }
}

