/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Locale;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVAKeyword;
import sun.security.x509.X500Name;
import sun.text.Normalizer;

final class AVA
implements DerEncoder {
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    ObjectIdentifier oid;
    DerValue value;
    private static final String specialChars = ",+=\n<>#;";
    private static final String specialChars2253 = ",+\"\\<>;";
    private static final String hexDigits = "0123456789ABCDEF";

    AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    AVA(Reader reader) throws IOException {
        this(reader, 1);
    }

    AVA(Reader reader, int n2) throws IOException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((n3 = reader.read()) == -1) {
                throw new IOException("Incorrect AVA format");
            }
            if (n3 == 61) break;
            stringBuffer.append((char)n3);
        }
        String string = stringBuffer.toString();
        this.oid = AVAKeyword.getOID(string, n2);
        stringBuffer.setLength(0);
        if (n2 == 3) {
            n3 = reader.read();
        } else {
            while ((n3 = reader.read()) == 32 || n3 == 10) {
            }
        }
        if (n3 == -1) {
            throw new IOException("Incorrect AVA format");
        }
        if (n3 == 35) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = 0;
            int n5 = 0;
            while (!AVA.isTerminator(n3 = reader.read(), n2)) {
                int n6 = hexDigits.indexOf(Character.toUpperCase((char)n3));
                if (n6 == -1) {
                    throw new IOException("AVA parse, invalid hex digit: " + (char)n3);
                }
                if (n5 % 2 == 1) {
                    n4 = (byte)(n4 * 16 + (byte)n6);
                    byteArrayOutputStream.write(n4);
                } else {
                    n4 = (byte)n6;
                }
                ++n5;
            }
            if (n5 == 0) {
                throw new IOException("AVA parse, zero hex digits");
            }
            if (n5 % 2 == 1) {
                throw new IOException("AVA parse, odd number of hex digits");
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.value = new DerValue(byArray);
        } else if (n3 == 34 && n2 != 3) {
            n3 = reader.read();
            if (n3 == -1) {
                throw new IOException("Quoted string did not end in quote");
            }
            boolean bl2 = true;
            while (n3 != 34) {
                if (n3 == 92) {
                    n3 = reader.read();
                    if (n3 == -1) {
                        throw new IOException("Quoted string did not end in quote");
                    }
                    if (n3 != 92 && n3 != 34 && specialChars.indexOf((char)n3) < 0) {
                        throw new IOException("Invalid escaped character in AVA");
                    }
                }
                bl2 &= DerValue.isPrintableStringChar((char)n3);
                stringBuffer.append((char)n3);
                n3 = reader.read();
                if (n3 != -1) continue;
                throw new IOException("Quoted string did not end in quote");
            }
            while ((n3 = reader.read()) == 10 || n3 == 32) {
            }
            if (n3 != -1) {
                throw new IOException("AVA had characters other than whitespace after terminating quote");
            }
            String string2 = stringBuffer.toString().trim();
            this.value = bl2 ? new DerValue(string2) : new DerValue(12, string2);
        } else {
            boolean bl3 = true;
            do {
                if (n3 == 92) {
                    n3 = reader.read();
                    if (n3 == -1) {
                        throw new IOException("Invalid trailing backslash");
                    }
                } else if (n2 == 3 && specialChars2253.indexOf((char)n3) != -1) {
                    throw new IOException("Character " + (char)n3 + " appears without escape");
                }
                bl3 &= DerValue.isPrintableStringChar((char)n3);
                stringBuffer.append((char)n3);
            } while (!AVA.isTerminator(n3 = reader.read(), n2));
            String string3 = stringBuffer.toString();
            if (n2 != 3) {
                string3 = string3.trim();
            }
            this.value = bl3 ? new DerValue(string3) : new DerValue(12, string3);
        }
    }

    private static boolean isTerminator(int n2, int n3) {
        switch (n2) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: 
            case 62: {
                return n3 != 3;
            }
        }
        return false;
    }

    AVA(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("AVA not a sequence");
        }
        this.oid = X500Name.intern(derValue.data.getOID());
        this.value = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new IOException("AVA, extra bytes = " + derValue.data.available());
        }
    }

    AVA(DerInputStream derInputStream) throws IOException {
        this(derInputStream.getDerValue());
    }

    boolean equals(AVA aVA) {
        if (aVA == null) {
            return false;
        }
        return this.toRFC2253CanonicalString().equals(aVA.toRFC2253CanonicalString());
    }

    public boolean equals(Object object) {
        if (object instanceof AVA) {
            return this.equals((AVA)object);
        }
        return false;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    private String toKeyword(int n2) {
        return AVAKeyword.getKeyword(this.oid, n2);
    }

    public String toString() {
        return this.toKeywordValueString(this.toKeyword(1));
    }

    public String toRFC1779String() {
        return this.toKeywordValueString(this.toKeyword(2));
    }

    public String toRFC2253String() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, false)) {
            byte[] byArray = null;
            try {
                byArray = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            int n2 = 0;
            while (n2 < byArray.length) {
                byte by = byArray[n2];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
                ++n2;
            }
        } else {
            String string = null;
            try {
                byte[] byArray = this.value.getDataBytes();
                string = new String(byArray, "UTF8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer2 = new StringBuffer(2 * string.length());
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] != ' ' && cArray[n3] != '\r') break;
                ++n3;
            }
            int n4 = cArray.length - 1;
            while (n4 >= 0) {
                if (cArray[n4] != ' ' && cArray[n4] != '\r') break;
                --n4;
            }
            int n5 = 0;
            while (n5 < cArray.length) {
                char c2 = cArray[n5];
                if (n5 < n3 || n5 > n4 || ",=+<>#;\"\\".indexOf(c2) >= 0) {
                    stringBuffer2.append('\\');
                }
                stringBuffer2.append(c2);
                ++n5;
            }
            stringBuffer.append(new String(stringBuffer2));
        }
        return new String(stringBuffer);
    }

    public String toRFC2253CanonicalString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.toKeyword(3));
        stringBuffer.append('=');
        if (stringBuffer.charAt(0) >= '0' && stringBuffer.charAt(0) <= '9' || !AVA.isDerString(this.value, true)) {
            object = null;
            try {
                object = this.value.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            stringBuffer.append('#');
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                Object object2 = object[n2];
                stringBuffer.append(Character.forDigit(0xF & object2 >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & object2, 16));
                ++n2;
            }
        } else {
            object = null;
            try {
                byte[] byArray = this.value.getDataBytes();
                object = new String(byArray, "UTF8");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("DER Value conversion");
            }
            char[] cArray = ((String)object).toCharArray();
            StringBuffer stringBuffer2 = new StringBuffer(2 * ((String)object).length());
            if (cArray.length > 0 && cArray[0] == '#') {
                stringBuffer2.append('\\');
            }
            int n3 = 0;
            while (n3 < cArray.length) {
                if (!Character.isWhitespace(cArray[n3])) break;
                ++n3;
            }
            int n4 = cArray.length - 1;
            while (n4 >= 0) {
                if (!Character.isWhitespace(cArray[n4])) break;
                --n4;
            }
            boolean bl2 = false;
            int n5 = n3;
            while (n5 <= n4) {
                char c2 = cArray[n5];
                if (!Character.isWhitespace(c2)) {
                    bl2 = false;
                    if (",=<>;\"\\".indexOf(c2) >= 0) {
                        stringBuffer2.append('\\');
                    }
                    stringBuffer2.append(c2);
                } else if (!bl2) {
                    bl2 = true;
                    stringBuffer2.append(c2);
                }
                ++n5;
            }
            stringBuffer.append(new String(stringBuffer2));
        }
        object = new String(stringBuffer);
        object = ((String)object).toUpperCase(Locale.US).toLowerCase(Locale.US);
        return Normalizer.normalize((String)object, Normalizer.DECOMP_COMPAT, 0);
    }

    private static boolean isDerString(DerValue derValue, boolean bl2) {
        if (bl2) {
            switch (derValue.tag) {
                case 12: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        switch (derValue.tag) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(this.oid, 3);
    }

    private String toKeywordValueString(String string) {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(string);
        stringBuffer.append("=");
        try {
            String string2 = this.value.getAsString();
            if (string2 == null) {
                byte[] byArray = this.value.toByteArray();
                stringBuffer.append('#');
                int n2 = 0;
                while (n2 < byArray.length) {
                    stringBuffer.append(hexDigits.charAt(byArray[n2] >> 4 & 0xF));
                    stringBuffer.append(hexDigits.charAt(byArray[n2] & 0xF));
                    ++n2;
                }
            } else {
                char c2;
                boolean bl2 = false;
                int n3 = string2.length();
                int n4 = 0;
                while (n4 < specialChars.length()) {
                    if (string2.indexOf(specialChars.charAt(n4)) != -1) {
                        bl2 = true;
                        break;
                    }
                    ++n4;
                }
                if (!(n3 <= 0 || bl2 || string2.charAt(0) != ' ' && string2.charAt(0) != '\n' && string2.charAt(n3 - 1) != ' ' && string2.charAt(n3 - 1) != '\n')) {
                    bl2 = true;
                }
                if (n3 > 0 && !bl2) {
                    c2 = '\u0000';
                    n4 = 1;
                    while (n4 < n3 - 2) {
                        if (string2.charAt(n4) == ' ' || string2.charAt(n4) == '\n') {
                            if (c2 != '\u0000') {
                                bl2 = true;
                                break;
                            }
                            c2 = '\u0001';
                        } else {
                            c2 = '\u0000';
                        }
                        ++n4;
                    }
                }
                if (bl2) {
                    stringBuffer.append('\"');
                }
                n4 = 0;
                while (n4 < n3) {
                    c2 = string2.charAt(n4);
                    if (c2 == '\"' || c2 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    ++n4;
                }
                if (bl2) {
                    stringBuffer.append('\"');
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("DER Value conversion");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }
}

