/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;

class GrayBoxProcesser
implements Runnable {
    private ArrayList requests = new ArrayList();
    private ThreadGroup tg = null;
    private Thread processerThread = null;
    private Timer timer = null;

    GrayBoxProcesser(ThreadGroup threadGroup, final Component component) {
        this.tg = threadGroup;
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                component.repaint();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequest(Runnable runnable) {
        Thread thread = this.processerThread;
        if (thread != null && !thread.isInterrupted()) {
            ArrayList arrayList = this.requests;
            synchronized (arrayList) {
                this.requests.add(runnable);
                this.requests.notifyAll();
            }
        }
    }

    public void start() {
        this.processerThread = new Thread(this.tg, this, "GrayBoxThread");
        this.processerThread.start();
        if (this.timer != null) {
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.processerThread != null) {
            this.processerThread.interrupt();
            this.processerThread = null;
        }
        ArrayList arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (!thread.isInterrupted()) {
                Object[] objectArray = null;
                ArrayList arrayList = this.requests;
                synchronized (arrayList) {
                    this.requests.wait();
                    objectArray = this.requests.toArray();
                    this.requests.clear();
                }
                int n = 0;
                while (n < objectArray.length) {
                    Runnable runnable = (Runnable)objectArray[n];
                    try {
                        runnable.run();
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

