#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/mtab.new
config etc/motd.new
config etc/group.new
config etc/csh.login.new
config etc/ld.so.conf.new
config etc/profile.new
config etc/hosts.new
config etc/inputrc.new
config etc/shadow.new
config etc/passwd.new
config etc/networks.new
config etc/HOSTNAME.new
config etc/gshadow.new
config etc/issue.new
config etc/securetty.new
config etc/shells.new
config etc/services.new
config etc/issue.net.new
config etc/nsswitch.conf.new
config var/log/lastlog.new
config var/log/wtmp.new

# Clean up useless non-examples:
rm -f etc/mtab.new
rm -f etc/motd.new
rm -f etc/ld.so.conf.new
rm -f etc/hosts.new
#rm -f etc/shadow.new
rm -f etc/networks.new
rm -f etc/HOSTNAME.new
#rm -f etc/gshadow.new
rm -f etc/shells.new
rm -f etc/issue.new
rm -f etc/issue.net.new
rm -f var/log/lastlog.new
rm -f var/log/wtmp.new

if [ ! -r etc/termcap ]; then
 cp -a etc/termcap-Linux etc/termcap
fi

# I don't know why this was ever here, so I better
# leave it, but comment it out
#if [ ! -r etc/passwd.OLD ]; then
#  mv etc/npasswd etc/passwd.OLD
#else
#  rm etc/npasswd
#fi

( cd usr/etc ; rm -rf printcap )
( cd usr/etc ; ln -sf  /etc/printcap printcap )
