/* errors.c - Display errors and let user do stuff.

   Copyright (C) 1998 Tom Tromey

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <config.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>

#include "sync.h"

static int
find_entry (struct database *database, const char *local_file)
{
  int i;

  /* FIXME: this is horrible.  */
  for (i = 0; i < database->list->rows; ++i)
    {
      gchar *t;
      if (gtk_clist_get_text (database->list, i, 0, &t)
	  && ! strcmp (local_file, t))
	return i;
    }

  return -1;
}

void
display_message (struct database *database, const char *local_file,
		 const char *remote_file, const char *message)
{
  int n;

  if (! database->list)
    return;

  n = find_entry (database, local_file);
  if (n == -1)
    {
      const char *text[3];

      text[0] = local_file;
      text[1] = remote_file;
      text[2] = message;
      /* FIXME: cast.  */
      gtk_clist_append (database->list, (gchar **) text);
    }
  else
    {
      /* FIXME: casts.  */
      gtk_clist_set_text (database->list, n, 1, (gchar *) remote_file);
      gtk_clist_set_text (database->list, n, 2, (gchar *) message);
    }
}

void
add_display_entry (struct database *database, const char *local_file,
		   const char *remote_file)
{
  /* FIXME: better text.  */
  display_message (database, local_file, remote_file, _("Initial entry"));
}

void
display_error (struct database *database, const char *local_file,
	       const char *remote_file, const char *error_msg)
{
  database->flags |= FLAG_DB_ERROR;

  /* Force window to exist when displaying error.  */
  if (! database->list)
    new_sync_app (database);

  display_message (database, local_file, remote_file, error_msg);
}

void
display_posix_error (struct database *database, const char *local_file,
		     const char *remote_file, const char *leader)
{
  gchar *msg;

  msg = g_strconcat (leader, ": ", strerror (errno), NULL);
  display_error (database, local_file, remote_file, msg);
  g_free (msg);
}

void
clear_errors (struct database *database)
{
  int i;

  database->flags &= ~FLAG_DB_ERROR;
  if (! database->list)
    return;

  for (i = 0; i < database->list->rows; ++i)
    gtk_clist_set_text (database->list, i, 2, "");
}

/* This is a fatal error related to the database itself.
   FIXME: the function name sucks.  */
void
db_posix_error (const char *message, const char *filename)
{
  gchar *msg;
  GtkWidget *box;

  msg = g_strconcat (message, ": ", filename, ": ",
			strerror (errno), NULL);
  box = gnome_message_box_new (msg, GNOME_MESSAGE_BOX_ERROR,
			       GNOME_STOCK_BUTTON_OK, NULL);
  gnome_dialog_run_and_close (GNOME_DIALOG (box));
}
