/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.corba.EncapsInputStream;
import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.DuplicateServiceContext;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.core.NoSuchServiceContext;
import com.sun.corba.se.internal.core.ServiceContext;
import com.sun.corba.se.internal.core.ServiceContextData;
import com.sun.corba.se.internal.core.ServiceContextRegistry;
import com.sun.corba.se.internal.core.UnknownServiceContext;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.iiop.CDROutputStream;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.SendingContext.CodeBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContexts {
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;
    private ORB orb;
    private Map scMap;
    private boolean addAlignmentOnWrite;
    private CodeBase codeBase;
    private GIOPVersion giopVersion;

    private static boolean isDebugging(OutputStream outputStream) {
        CDROutputStream cDROutputStream = (CDROutputStream)outputStream;
        ORB oRB = (ORB)cDROutputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private static boolean isDebugging(InputStream inputStream) {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        ORB oRB = (ORB)cDRInputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void writeNullServiceContext(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            ORBUtility.dprint("ServiceContexts", "Writing null service context");
        }
        outputStream.write_long(0);
    }

    private void createMapFromInputStream(InputStream inputStream) {
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        int n2 = inputStream.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + n2);
        }
        this.scMap = new HashMap(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Reading service context id " + n4);
            }
            byte[] byArray = OctetSeqHelper.read(inputStream);
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Service context" + n4 + " length: " + byArray.length);
            }
            this.scMap.put(new Integer(n4), byArray);
            ++n3;
        }
    }

    public ServiceContexts(InputStream inputStream) {
        this.addAlignmentOnWrite = false;
        this.orb = (ORB)inputStream.orb();
        this.codeBase = ((CDRInputStream)inputStream).getCodeBase();
        this.giopVersion = ((CDRInputStream)inputStream).getGIOPVersion();
        this.createMapFromInputStream(inputStream);
    }

    private ServiceContext unmarshal(Integer n2, byte[] byArray) {
        ServiceContextRegistry serviceContextRegistry = this.orb.getServiceContextRegistry();
        ServiceContextData serviceContextData = serviceContextRegistry.findServiceContextData(n2);
        ServiceContext serviceContext = null;
        if (serviceContextData == null) {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Could not find ServiceContextData for " + n2 + " using UnknownServiceContext");
            }
            serviceContext = new UnknownServiceContext((int)n2, byArray);
        } else {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Found " + serviceContextData);
            }
            EncapsInputStream encapsInputStream = new EncapsInputStream((org.omg.CORBA.ORB)this.orb, byArray, byArray.length, this.giopVersion, this.codeBase);
            encapsInputStream.consumeEndian();
            try {
                serviceContext = serviceContextData.makeServiceContext(encapsInputStream, this.giopVersion);
            }
            catch (NoSuchServiceContext noSuchServiceContext) {
                throw new INTERNAL(noSuchServiceContext.toString(), 1398079722, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return serviceContext;
    }

    public ServiceContexts(ORB oRB) {
        this.orb = oRB;
        this.scMap = new HashMap();
        this.addAlignmentOnWrite = false;
        this.giopVersion = oRB.getGIOPVersion();
    }

    public void addAlignmentPadding() {
        this.addAlignmentOnWrite = true;
    }

    public void write(OutputStream outputStream, GIOPVersion gIOPVersion) {
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int n2 = this.scMap.size();
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Adding alignment padding");
            }
            ++n2;
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context has " + n2 + " components");
        }
        outputStream.write_long(n2);
        this.writeServiceContextsInOrder(outputStream, gIOPVersion);
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing alignment padding");
            }
            outputStream.write_long(-1106033203);
            outputStream.write_long(4);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context writing complete");
        }
    }

    private void writeServiceContextsInOrder(OutputStream outputStream, GIOPVersion gIOPVersion) {
        Integer n2 = new Integer(9);
        Object object = this.scMap.remove(n2);
        Iterator iterator = this.scMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n3 = (Integer)iterator.next();
            this.writeMapEntry(outputStream, n3, this.scMap.get(n3), gIOPVersion);
        }
        if (object != null) {
            this.writeMapEntry(outputStream, n2, object, gIOPVersion);
            this.scMap.put(n2, object);
        }
    }

    private void writeMapEntry(OutputStream outputStream, Integer n2, Object object, GIOPVersion gIOPVersion) {
        if (Byte.TYPE.equals(object.getClass().getComponentType())) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context bytes for id " + n2);
            }
            OctetSeqHelper.write(outputStream, (byte[])object);
        } else {
            ServiceContext serviceContext = (ServiceContext)object;
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context " + serviceContext);
            }
            serviceContext.write(outputStream, gIOPVersion);
        }
    }

    public void put(ServiceContext serviceContext) throws DuplicateServiceContext {
        Integer n2 = new Integer(serviceContext.getId());
        Object object = this.scMap.get(n2);
        if (object != null) {
            throw new DuplicateServiceContext(n2.toString());
        }
        this.scMap.put(n2, serviceContext);
    }

    public void delete(int n2) throws NoSuchServiceContext {
        this.delete(new Integer(n2));
    }

    public void delete(Integer n2) throws NoSuchServiceContext {
        if (this.scMap.remove(n2) == null) {
            throw new NoSuchServiceContext(n2.toString());
        }
    }

    public ServiceContext get(int n2) throws NoSuchServiceContext {
        return this.get(new Integer(n2));
    }

    public ServiceContext get(Integer n2) throws NoSuchServiceContext {
        Object object = this.scMap.get(n2);
        if (object == null) {
            throw new NoSuchServiceContext();
        }
        if (Byte.TYPE.equals(object.getClass().getComponentType())) {
            ServiceContext serviceContext = this.unmarshal(n2, (byte[])object);
            this.scMap.put(n2, serviceContext);
            return serviceContext;
        }
        return (ServiceContext)object;
    }
}

