/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GIFImageMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "javax_imageio_gif_image_1.0";
    static final String[] disposalMethodNames = new String[]{"none", "doNotDispose", "restoreToBackgroundColor", "restoreToPrevious", "undefinedDisposalMethod4", "undefinedDisposalMethod5", "undefinedDisposalMethod6", "undefinedDisposalMethod7"};
    public int imageLeftPosition;
    public int imageTopPosition;
    public int imageWidth;
    public int imageHeight;
    public boolean interlaceFlag = false;
    public boolean sortFlag = false;
    public byte[] localColorTable = null;
    public int disposalMethod = 0;
    public boolean userInputFlag = false;
    public boolean transparentColorFlag = false;
    public int delayTime = 0;
    public int transparentColorIndex = 0;
    public boolean hasPlainTextExtension = false;
    public int textGridLeft;
    public int textGridTop;
    public int textGridWidth;
    public int textGridHeight;
    public int characterCellWidth;
    public int characterCellHeight;
    public int textForegroundColor;
    public int textBackgroundColor;
    public byte[] text;
    public List applicationIDs = null;
    public List authenticationCodes = null;
    public List applicationData = null;
    public List comments = null;

    public GIFImageMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.imageio.plugins.gif.GIFImageMetadataFormat", null, null);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private String toISO8859(byte[] byArray) {
        try {
            return new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode;
        int n2;
        int n3;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ImageDescriptor");
        iIOMetadataNode3.setAttribute("imageLeftPosition", Integer.toString(this.imageLeftPosition));
        iIOMetadataNode3.setAttribute("imageTopPosition", Integer.toString(this.imageTopPosition));
        iIOMetadataNode3.setAttribute("imageWidth", Integer.toString(this.imageWidth));
        iIOMetadataNode3.setAttribute("imageHeight", Integer.toString(this.imageHeight));
        iIOMetadataNode3.setAttribute("interlaceFlag", this.interlaceFlag ? "true" : "false");
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        if (this.localColorTable != null) {
            iIOMetadataNode3 = new IIOMetadataNode("LocalColorTable");
            n3 = this.localColorTable.length / 3;
            iIOMetadataNode3.setAttribute("sizeOfLocalColorTable", Integer.toString(n3));
            iIOMetadataNode3.setAttribute("sortFlag", this.sortFlag ? "TRUE" : "FALSE");
            n2 = 0;
            while (n2 < n3) {
                iIOMetadataNode = new IIOMetadataNode("ColorTableEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n2));
                int n4 = this.localColorTable[3 * n2] & 0xFF;
                int n5 = this.localColorTable[3 * n2 + 1] & 0xFF;
                int n6 = this.localColorTable[3 * n2 + 2] & 0xFF;
                iIOMetadataNode.setAttribute("red", Integer.toString(n4));
                iIOMetadataNode.setAttribute("green", Integer.toString(n5));
                iIOMetadataNode.setAttribute("blue", Integer.toString(n6));
                iIOMetadataNode3.appendChild(iIOMetadataNode);
                ++n2;
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        iIOMetadataNode3 = new IIOMetadataNode("GraphicControlExtension");
        iIOMetadataNode3.setAttribute("disposalMethod", disposalMethodNames[this.disposalMethod]);
        iIOMetadataNode3.setAttribute("userInputFlag", this.userInputFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("transparentColorFlag", this.transparentColorFlag ? "true" : "false");
        iIOMetadataNode3.setAttribute("delayTime", Integer.toString(this.delayTime));
        iIOMetadataNode3.setAttribute("transparentColorIndex", Integer.toString(this.transparentColorIndex));
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        if (this.hasPlainTextExtension) {
            iIOMetadataNode3 = new IIOMetadataNode("PlainTextExtension");
            iIOMetadataNode3.setAttribute("textGridLeft", Integer.toString(this.textGridLeft));
            iIOMetadataNode3.setAttribute("textGridTop", Integer.toString(this.textGridTop));
            iIOMetadataNode3.setAttribute("textGridWidth", Integer.toString(this.textGridWidth));
            iIOMetadataNode3.setAttribute("textGridHeight", Integer.toString(this.textGridHeight));
            iIOMetadataNode3.setAttribute("characterCellWidth", Integer.toString(this.characterCellWidth));
            iIOMetadataNode3.setAttribute("characterCellHeight", Integer.toString(this.characterCellHeight));
            iIOMetadataNode3.setAttribute("textForegroundColor", Integer.toString(this.textForegroundColor));
            iIOMetadataNode3.setAttribute("textBackgroundColor", Integer.toString(this.textBackgroundColor));
            iIOMetadataNode3.setAttribute("text", this.toISO8859(this.text));
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        int n7 = n3 = this.applicationIDs == null ? 0 : this.applicationIDs.size();
        if (n3 > 0) {
            iIOMetadataNode3 = new IIOMetadataNode("ApplicationExtensions");
            n2 = 0;
            while (n2 < n3) {
                iIOMetadataNode = new IIOMetadataNode("ApplicationExtension");
                byte[] byArray = (byte[])this.applicationIDs.get(n2);
                iIOMetadataNode.setAttribute("applicationID", this.toISO8859(byArray));
                byte[] byArray2 = (byte[])this.authenticationCodes.get(n2);
                iIOMetadataNode.setAttribute("authenticationCode", this.toISO8859(byArray2));
                byte[] byArray3 = (byte[])this.applicationData.get(n2);
                iIOMetadataNode.setUserObject((byte[])byArray3.clone());
                iIOMetadataNode3.appendChild(iIOMetadataNode);
                ++n2;
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        int n8 = n2 = this.comments == null ? 0 : this.comments.size();
        if (n2 > 0) {
            iIOMetadataNode3 = new IIOMetadataNode("CommentExtensions");
            int n9 = 0;
            while (n9 < n2) {
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("CommentExtension");
                byte[] byArray = (byte[])this.comments.get(n9);
                iIOMetadataNode4.setAttribute("value", this.toISO8859(byArray));
                iIOMetadataNode3.appendChild(iIOMetadataNode4);
                ++n9;
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode2;
    }

    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode2.setAttribute("name", "RGB");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode2.setAttribute("value", this.transparentColorFlag ? "4" : "3");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.localColorTable != null) {
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            int n2 = this.localColorTable.length / 3;
            int n3 = 0;
            while (n3 < n2) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n3));
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.localColorTable[3 * n3] & 0xFF));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.localColorTable[3 * n3 + 1] & 0xFF));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.localColorTable[3 * n3 + 2] & 0xFF));
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                ++n3;
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "lzw");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Lossless");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode2.setAttribute("value", this.interlaceFlag ? "4" : "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", "Index");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelOffset");
        iIOMetadataNode2.setAttribute("value", Integer.toString(this.imageLeftPosition));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelOffset");
        iIOMetadataNode2.setAttribute("value", Integer.toString(this.imageTopPosition));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTextNode() {
        if (this.comments == null) {
            return null;
        }
        Iterator iterator = this.comments.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        IIOMetadataNode iIOMetadataNode2 = null;
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            String string = null;
            try {
                string = new String(byArray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Encoding ISO-8859-1 unknown!");
            }
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode2.setAttribute("encoding", "ISO-8859-1");
            iIOMetadataNode2.setAttribute("compression", "none");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        if (!this.transparentColorFlag) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("TransparentIndex");
        iIOMetadataNode2.setAttribute("value", Integer.toString(this.transparentColorIndex));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public void setFromTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void mergeTree(String string, Node node) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

