/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class JFIFMarkerSegment
extends MarkerSegment {
    int majorVersion;
    int minorVersion;
    int resUnits;
    int Xdensity;
    int Ydensity;
    int thumbWidth;
    int thumbHeight;
    JFIFThumbRGB thumb = null;
    ArrayList extSegments = new ArrayList();
    ICCMarkerSegment iccSegment = null;
    private static final int THUMB_JPEG = 16;
    private static final int THUMB_PALETTE = 17;
    private static final int THUMB_UNASSIGNED = 18;
    private static final int THUMB_RGB = 19;
    private static final int DATA_SIZE = 14;
    private static final int ID_SIZE = 5;
    private final int MAX_THUMB_WIDTH = 255;
    private final int MAX_THUMB_HEIGHT = 255;
    private final boolean debug = false;
    private boolean inICC = false;
    private ICCMarkerSegment tempICCSegment = null;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment;

    JFIFMarkerSegment() {
        super(224);
        this.majorVersion = 1;
        this.minorVersion = 2;
        this.resUnits = 0;
        this.Xdensity = 1;
        this.Ydensity = 1;
        this.thumbWidth = 0;
        this.thumbHeight = 0;
    }

    JFIFMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        jPEGBuffer.bufPtr += 5;
        this.majorVersion = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.minorVersion = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.resUnits = jPEGBuffer.buf[jPEGBuffer.bufPtr++];
        this.Xdensity = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.Xdensity |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.Ydensity = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.Ydensity |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.thumbWidth = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        this.thumbHeight = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        jPEGBuffer.bufAvail -= 14;
        if (this.thumbWidth > 0) {
            this.thumb = new JFIFThumbRGB(jPEGBuffer, this.thumbWidth, this.thumbHeight);
        }
    }

    JFIFMarkerSegment(Node node) throws IIOInvalidTreeException {
        this();
        this.updateFromNativeNode(node, true);
    }

    protected Object clone() {
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)super.clone();
        if (!this.extSegments.isEmpty()) {
            jFIFMarkerSegment.extSegments = new ArrayList();
            Iterator iterator = this.extSegments.iterator();
            while (iterator.hasNext()) {
                JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)iterator.next();
                jFIFMarkerSegment.extSegments.add(jFIFExtensionMarkerSegment.clone());
            }
        }
        if (this.iccSegment != null) {
            jFIFMarkerSegment.iccSegment = (ICCMarkerSegment)this.iccSegment.clone();
        }
        return jFIFMarkerSegment;
    }

    void addJFXX(JPEGBuffer jPEGBuffer, JPEGImageReader jPEGImageReader) throws IOException {
        this.extSegments.add(new JFIFExtensionMarkerSegment(jPEGBuffer, jPEGImageReader));
    }

    void addICC(JPEGBuffer jPEGBuffer) throws IOException {
        if (!this.inICC) {
            if (this.iccSegment != null) {
                throw new IIOException("> 1 ICC APP2 Marker Segment not supported");
            }
            this.tempICCSegment = new ICCMarkerSegment(jPEGBuffer);
            if (!this.inICC) {
                this.iccSegment = this.tempICCSegment;
                this.tempICCSegment = null;
            }
        } else if (this.tempICCSegment.addData(jPEGBuffer)) {
            this.iccSegment = this.tempICCSegment;
            this.tempICCSegment = null;
        }
    }

    void addICC(ICC_ColorSpace iCC_ColorSpace) throws IOException {
        if (this.iccSegment != null) {
            throw new IIOException("> 1 ICC APP2 Marker Segment not supported");
        }
        this.iccSegment = new ICCMarkerSegment(iCC_ColorSpace);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app0JFIF");
        iIOMetadataNode.setAttribute("majorVersion", Integer.toString(this.majorVersion));
        iIOMetadataNode.setAttribute("minorVersion", Integer.toString(this.minorVersion));
        iIOMetadataNode.setAttribute("resUnits", Integer.toString(this.resUnits));
        iIOMetadataNode.setAttribute("Xdensity", Integer.toString(this.Xdensity));
        iIOMetadataNode.setAttribute("Ydensity", Integer.toString(this.Ydensity));
        iIOMetadataNode.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
        iIOMetadataNode.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
        if (!this.extSegments.isEmpty()) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("JFXX");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            Iterator iterator = this.extSegments.iterator();
            while (iterator.hasNext()) {
                JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)iterator.next();
                iIOMetadataNode2.appendChild(jFIFExtensionMarkerSegment.getNativeNode());
            }
        }
        if (this.iccSegment != null) {
            iIOMetadataNode.appendChild(this.iccSegment.getNativeNode());
        }
        return iIOMetadataNode;
    }

    void updateFromNativeNode(Node node, boolean bl2) throws IIOInvalidTreeException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            int n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "majorVersion", 0, 255, false);
            this.majorVersion = n2 != -1 ? n2 : this.majorVersion;
            n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "minorVersion", 0, 255, false);
            this.minorVersion = n2 != -1 ? n2 : this.minorVersion;
            n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "resUnits", 0, 2, false);
            this.resUnits = n2 != -1 ? n2 : this.resUnits;
            n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "Xdensity", 1, 65535, false);
            this.Xdensity = n2 != -1 ? n2 : this.Xdensity;
            n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "Ydensity", 1, 65535, false);
            this.Ydensity = n2 != -1 ? n2 : this.Ydensity;
            n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "thumbWidth", 0, 255, false);
            this.thumbWidth = n2 != -1 ? n2 : this.thumbWidth;
            n2 = MarkerSegment.getAttributeValue(node, namedNodeMap, "thumbHeight", 0, 255, false);
            int n3 = this.thumbHeight = n2 != -1 ? n2 : this.thumbHeight;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n4 = nodeList.getLength();
            if (n4 > 2) {
                throw new IIOInvalidTreeException("app0JFIF node cannot have > 2 children", node);
            }
            int n5 = 0;
            while (n5 < n4) {
                Node node2 = nodeList.item(n5);
                String string = node2.getNodeName();
                if (string.equals("JFXX")) {
                    if (!this.extSegments.isEmpty() && bl2) {
                        throw new IIOInvalidTreeException("app0JFIF node cannot have > 1 JFXX node", node);
                    }
                    NodeList nodeList2 = node2.getChildNodes();
                    int n6 = nodeList2.getLength();
                    int n7 = 0;
                    while (n7 < n6) {
                        Node node3 = nodeList2.item(n7);
                        this.extSegments.add(new JFIFExtensionMarkerSegment(node3));
                        ++n7;
                    }
                }
                if (string.equals("app2ICC")) {
                    if (this.iccSegment != null && bl2) {
                        throw new IIOInvalidTreeException("> 1 ICC APP2 Marker Segment not supported", node);
                    }
                    this.iccSegment = new ICCMarkerSegment(node2);
                }
                ++n5;
            }
        }
    }

    int getThumbnailWidth(int n2) {
        if (this.thumb != null) {
            if (n2 == 0) {
                return this.thumb.getWidth();
            }
            --n2;
        }
        JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n2);
        return jFIFExtensionMarkerSegment.thumb.getWidth();
    }

    int getThumbnailHeight(int n2) {
        if (this.thumb != null) {
            if (n2 == 0) {
                return this.thumb.getHeight();
            }
            --n2;
        }
        JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n2);
        return jFIFExtensionMarkerSegment.thumb.getHeight();
    }

    BufferedImage getThumbnail(ImageInputStream imageInputStream, int n2, JPEGImageReader jPEGImageReader) throws IOException {
        jPEGImageReader.thumbnailStarted(n2);
        BufferedImage bufferedImage = null;
        if (this.thumb != null && n2 == 0) {
            bufferedImage = this.thumb.getThumbnail(imageInputStream, jPEGImageReader);
        } else {
            if (this.thumb != null) {
                --n2;
            }
            JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n2);
            bufferedImage = jFIFExtensionMarkerSegment.thumb.getThumbnail(imageInputStream, jPEGImageReader);
        }
        jPEGImageReader.thumbnailComplete();
        return bufferedImage;
    }

    void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
        this.write(imageOutputStream, null, jPEGImageWriter);
    }

    void write(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, JPEGImageWriter jPEGImageWriter) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        if (bufferedImage != null) {
            n2 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
            if (n2 > 255 || n3 > 255) {
                jPEGImageWriter.warningOccurred(12);
            }
            n2 = Math.min(n2, 255);
            n3 = Math.min(n3, 255);
            nArray = bufferedImage.getRaster().getPixels(0, 0, n2, n3, (int[])null);
            n4 = nArray.length;
        }
        this.length = 16 + n4;
        this.writeTag(imageOutputStream);
        byte[] byArray = new byte[]{74, 70, 73, 70, 0};
        imageOutputStream.write(byArray);
        imageOutputStream.write(this.majorVersion);
        imageOutputStream.write(this.minorVersion);
        imageOutputStream.write(this.resUnits);
        MarkerSegment.write2bytes(imageOutputStream, this.Xdensity);
        MarkerSegment.write2bytes(imageOutputStream, this.Ydensity);
        imageOutputStream.write(n2);
        imageOutputStream.write(n3);
        if (nArray != null) {
            jPEGImageWriter.thumbnailStarted(0);
            this.writeThumbnailData(imageOutputStream, nArray, jPEGImageWriter);
            jPEGImageWriter.thumbnailComplete();
        }
    }

    void writeThumbnailData(ImageOutputStream imageOutputStream, int[] nArray, JPEGImageWriter jPEGImageWriter) throws IOException {
        int n2 = nArray.length / 20;
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            imageOutputStream.write(nArray[n3]);
            if (n3 > n2 && n3 % n2 == 0) {
                jPEGImageWriter.thumbnailProgress((float)n3 * 100.0f / (float)nArray.length);
            }
            ++n3;
        }
    }

    void writeWithThumbs(ImageOutputStream imageOutputStream, List list, JPEGImageWriter jPEGImageWriter) throws IOException {
        if (list != null) {
            JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = null;
            if (list.size() == 1) {
                if (!this.extSegments.isEmpty()) {
                    jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(0);
                }
                this.writeThumb(imageOutputStream, (BufferedImage)list.get(0), jFIFExtensionMarkerSegment, 0, true, jPEGImageWriter);
            } else {
                this.write(imageOutputStream, jPEGImageWriter);
                int n2 = 0;
                while (n2 < list.size()) {
                    jFIFExtensionMarkerSegment = null;
                    if (n2 < this.extSegments.size()) {
                        jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)this.extSegments.get(n2);
                    }
                    this.writeThumb(imageOutputStream, (BufferedImage)list.get(n2), jFIFExtensionMarkerSegment, n2, false, jPEGImageWriter);
                    ++n2;
                }
            }
        } else {
            this.write(imageOutputStream, jPEGImageWriter);
        }
    }

    private void writeThumb(ImageOutputStream imageOutputStream, BufferedImage bufferedImage, JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment, int n2, boolean bl2, JPEGImageWriter jPEGImageWriter) throws IOException {
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorModel instanceof IndexColorModel) {
            if (bl2) {
                this.write(imageOutputStream, jPEGImageWriter);
            }
            if (jFIFExtensionMarkerSegment == null || jFIFExtensionMarkerSegment.code == 17) {
                this.writeJFXXSegment(n2, bufferedImage, imageOutputStream, jPEGImageWriter);
            } else {
                BufferedImage bufferedImage2 = ((IndexColorModel)colorModel).convertToIntDiscrete(bufferedImage.getRaster(), false);
                jFIFExtensionMarkerSegment.setThumbnail(bufferedImage2);
                jPEGImageWriter.thumbnailStarted(n2);
                jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
                jPEGImageWriter.thumbnailComplete();
            }
        } else if (colorSpace.getType() == 5) {
            if (jFIFExtensionMarkerSegment == null) {
                if (bl2) {
                    this.write(imageOutputStream, bufferedImage, jPEGImageWriter);
                } else {
                    this.writeJFXXSegment(n2, bufferedImage, imageOutputStream, jPEGImageWriter);
                }
            } else {
                if (bl2) {
                    this.write(imageOutputStream, jPEGImageWriter);
                }
                if (jFIFExtensionMarkerSegment.code == 17) {
                    this.writeJFXXSegment(n2, bufferedImage, imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.warningOccurred(14);
                } else {
                    jFIFExtensionMarkerSegment.setThumbnail(bufferedImage);
                    jPEGImageWriter.thumbnailStarted(n2);
                    jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.thumbnailComplete();
                }
            }
        } else if (colorSpace.getType() == 6) {
            if (jFIFExtensionMarkerSegment == null) {
                if (bl2) {
                    BufferedImage bufferedImage3 = JFIFMarkerSegment.expandGrayThumb(bufferedImage);
                    this.write(imageOutputStream, bufferedImage3, jPEGImageWriter);
                } else {
                    this.writeJFXXSegment(n2, bufferedImage, imageOutputStream, jPEGImageWriter);
                }
            } else {
                if (bl2) {
                    this.write(imageOutputStream, jPEGImageWriter);
                }
                if (jFIFExtensionMarkerSegment.code == 19) {
                    BufferedImage bufferedImage4 = JFIFMarkerSegment.expandGrayThumb(bufferedImage);
                    this.writeJFXXSegment(n2, bufferedImage4, imageOutputStream, jPEGImageWriter);
                } else if (jFIFExtensionMarkerSegment.code == 16) {
                    jFIFExtensionMarkerSegment.setThumbnail(bufferedImage);
                    jPEGImageWriter.thumbnailStarted(n2);
                    jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.thumbnailComplete();
                } else if (jFIFExtensionMarkerSegment.code == 17) {
                    this.writeJFXXSegment(n2, bufferedImage, imageOutputStream, jPEGImageWriter);
                    jPEGImageWriter.warningOccurred(15);
                }
            }
        } else {
            jPEGImageWriter.warningOccurred(9);
        }
    }

    private void writeJFXXSegment(int n2, BufferedImage bufferedImage, ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
        JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = null;
        try {
            jFIFExtensionMarkerSegment = new JFIFExtensionMarkerSegment(bufferedImage);
        }
        catch (IllegalThumbException illegalThumbException) {
            jPEGImageWriter.warningOccurred(9);
            return;
        }
        jPEGImageWriter.thumbnailStarted(n2);
        jFIFExtensionMarkerSegment.write(imageOutputStream, jPEGImageWriter);
        jPEGImageWriter.thumbnailComplete();
    }

    private static BufferedImage expandGrayThumb(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    static void writeDefaultJFIF(ImageOutputStream imageOutputStream, List list, ICC_Profile iCC_Profile, JPEGImageWriter jPEGImageWriter) throws IOException {
        JFIFMarkerSegment jFIFMarkerSegment = new JFIFMarkerSegment();
        jFIFMarkerSegment.writeWithThumbs(imageOutputStream, list, jPEGImageWriter);
        if (iCC_Profile != null) {
            JFIFMarkerSegment.writeICC(iCC_Profile, imageOutputStream);
        }
    }

    void print() {
        this.printTag("JFIF");
        System.out.print("Version ");
        System.out.print(this.majorVersion);
        System.out.println(".0" + Integer.toString(this.minorVersion));
        System.out.print("Resolution units: ");
        System.out.println(this.resUnits);
        System.out.print("X density: ");
        System.out.println(this.Xdensity);
        System.out.print("Y density: ");
        System.out.println(this.Ydensity);
        System.out.print("Thumbnail Width: ");
        System.out.println(this.thumbWidth);
        System.out.print("Thumbnail Height: ");
        System.out.println(this.thumbHeight);
        if (!this.extSegments.isEmpty()) {
            Iterator iterator = this.extSegments.iterator();
            while (iterator.hasNext()) {
                JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)iterator.next();
                jFIFExtensionMarkerSegment.print();
            }
        }
        if (this.iccSegment != null) {
            this.iccSegment.print();
        }
    }

    static void writeICC(ICC_Profile iCC_Profile, ImageOutputStream imageOutputStream) throws IOException {
        int n2 = 2;
        int n3 = "ICC_PROFILE".length() + 1;
        int n4 = 2;
        int n5 = 65535 - n2 - n3 - n4;
        byte[] byArray = iCC_Profile.getData();
        int n6 = byArray.length / n5;
        if (byArray.length % n5 != 0) {
            ++n6;
        }
        int n7 = 1;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            int n10 = Math.min(byArray.length - n8, n5);
            int n11 = n10 + n4 + n3 + n2;
            imageOutputStream.write(255);
            imageOutputStream.write(226);
            MarkerSegment.write2bytes(imageOutputStream, n11);
            byte[] byArray2 = "ICC_PROFILE".getBytes("US-ASCII");
            imageOutputStream.write(byArray2);
            imageOutputStream.write(0);
            imageOutputStream.write(n7++);
            imageOutputStream.write(n6);
            imageOutputStream.write(byArray, n8, n10);
            n8 += n10;
            ++n9;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ICCMarkerSegment
    extends MarkerSegment {
        ArrayList chunks;
        byte[] profile;
        private static final int ID_SIZE = 12;
        int chunksRead;
        int numChunks;

        ICCMarkerSegment(ICC_ColorSpace iCC_ColorSpace) {
            super(226);
            this.chunks = null;
            this.profile = null;
            this.chunks = null;
            this.chunksRead = 0;
            this.numChunks = 0;
            this.profile = iCC_ColorSpace.getProfile().getData();
        }

        ICCMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
            super(jPEGBuffer);
            this.chunks = null;
            this.profile = null;
            jPEGBuffer.bufPtr += 12;
            jPEGBuffer.bufAvail -= 12;
            this.length -= 12;
            int n2 = jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF;
            this.numChunks = jPEGBuffer.buf[jPEGBuffer.bufPtr + 1] & 0xFF;
            if (n2 > this.numChunks) {
                throw new IIOException("Image format Error; chunk num > num chunks");
            }
            if (this.numChunks == 1) {
                this.length -= 2;
                this.profile = new byte[this.length];
                jPEGBuffer.bufPtr += 2;
                jPEGBuffer.bufAvail -= 2;
                jPEGBuffer.readData(this.profile);
                JFIFMarkerSegment.this.inICC = false;
            } else {
                byte[] byArray = new byte[this.length];
                this.length -= 2;
                jPEGBuffer.readData(byArray);
                this.chunks = new ArrayList();
                this.chunks.add(byArray);
                this.chunksRead = 1;
                JFIFMarkerSegment.this.inICC = true;
            }
        }

        ICCMarkerSegment(Node node) throws IIOInvalidTreeException {
            IIOMetadataNode iIOMetadataNode;
            ICC_Profile iCC_Profile;
            super(226);
            this.chunks = null;
            this.profile = null;
            if (node instanceof IIOMetadataNode && (iCC_Profile = (ICC_Profile)(iIOMetadataNode = (IIOMetadataNode)node).getUserObject()) != null) {
                this.profile = iCC_Profile.getData();
            }
        }

        protected Object clone() {
            ICCMarkerSegment iCCMarkerSegment = (ICCMarkerSegment)super.clone();
            if (this.profile != null) {
                iCCMarkerSegment.profile = (byte[])this.profile.clone();
            }
            return iCCMarkerSegment;
        }

        boolean addData(JPEGBuffer jPEGBuffer) throws IOException {
            ++jPEGBuffer.bufPtr;
            --jPEGBuffer.bufAvail;
            int n2 = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
            n2 |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
            jPEGBuffer.bufAvail -= 2;
            n2 -= 2;
            jPEGBuffer.bufPtr += 12;
            jPEGBuffer.bufAvail -= 12;
            n2 -= 12;
            int n3 = jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF;
            if (n3 > this.numChunks) {
                throw new IIOException("Image format Error; chunk num > num chunks");
            }
            int n4 = jPEGBuffer.buf[jPEGBuffer.bufPtr + 1] & 0xFF;
            if (this.numChunks != n4) {
                throw new IIOException("Image format Error; icc num chunks mismatch");
            }
            boolean bl2 = false;
            byte[] byArray = new byte[n2 -= 2];
            jPEGBuffer.readData(byArray);
            this.chunks.add(byArray);
            this.length += n2;
            ++this.chunksRead;
            if (this.chunksRead < this.numChunks) {
                JFIFMarkerSegment.this.inICC = true;
            } else {
                this.profile = new byte[this.length];
                int n5 = 0;
                int n6 = 1;
                while (n6 <= this.numChunks) {
                    boolean bl3 = false;
                    int n7 = 0;
                    while (n7 < this.chunks.size()) {
                        byte[] byArray2 = (byte[])this.chunks.get(n7);
                        if (byArray2[0] == n6) {
                            System.arraycopy(byArray2, 2, this.profile, n5, byArray2.length - 2);
                            n5 += byArray2.length - 2;
                            bl3 = true;
                        }
                        ++n7;
                    }
                    if (!bl3) {
                        throw new IIOException("Image Format Error: Missing ICC chunk num " + n6);
                    }
                    ++n6;
                }
                this.chunks = null;
                this.chunksRead = 0;
                this.numChunks = 0;
                JFIFMarkerSegment.this.inICC = false;
                bl2 = true;
            }
            return bl2;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app2ICC");
            if (this.profile != null) {
                iIOMetadataNode.setUserObject(ICC_Profile.getInstance(this.profile));
            }
            return iIOMetadataNode;
        }

        void write(ImageOutputStream imageOutputStream) throws IOException {
        }

        void print() {
            this.printTag("ICC Profile APP2");
        }
    }

    class JFIFThumbJPEG
    extends JFIFThumb {
        JPEGMetadata thumbMetadata;
        byte[] data;
        private static final int PREAMBLE_SIZE = 6;

        JFIFThumbJPEG(JPEGBuffer jPEGBuffer, int n2, JPEGImageReader jPEGImageReader) throws IOException {
            super(jPEGBuffer);
            this.thumbMetadata = null;
            this.data = null;
            long l2 = this.streamPos + (long)(n2 - 6);
            jPEGBuffer.iis.seek(this.streamPos);
            this.thumbMetadata = new JPEGMetadata(false, true, jPEGBuffer.iis, jPEGImageReader);
            jPEGBuffer.iis.seek(l2);
            jPEGBuffer.bufAvail = 0;
            jPEGBuffer.bufPtr = 0;
        }

        JFIFThumbJPEG(Node node) throws IIOInvalidTreeException {
            this.thumbMetadata = null;
            this.data = null;
            if (node.getChildNodes().getLength() > 1) {
                throw new IIOInvalidTreeException("JFIFThumbJPEG node must have 0 or 1 child", node);
            }
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                String string = node2.getNodeName();
                if (!string.equals("markerSequence")) {
                    throw new IIOInvalidTreeException("JFIFThumbJPEG child must be a markerSequence node", node);
                }
                this.thumbMetadata = new JPEGMetadata(false, true);
                this.thumbMetadata.setFromMarkerSequenceNode(node2);
            }
        }

        JFIFThumbJPEG(BufferedImage bufferedImage) throws IllegalThumbException {
            this.thumbMetadata = null;
            this.data = null;
            int n2 = 4096;
            int n3 = 65527;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
                MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
                JPEGImageWriter jPEGImageWriter = new JPEGImageWriter(null);
                jPEGImageWriter.setOutput(memoryCacheImageOutputStream);
                JPEGMetadata jPEGMetadata = (JPEGMetadata)jPEGImageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), null);
                MarkerSegment markerSegment = jPEGMetadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment = JFIFMarkerSegment.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true);
                if (markerSegment == null) {
                    throw new IllegalThumbException();
                }
                jPEGMetadata.markerSequence.remove(markerSegment);
                jPEGImageWriter.write(new IIOImage(bufferedImage, null, (IIOMetadata)jPEGMetadata));
                jPEGImageWriter.dispose();
                if (byteArrayOutputStream.size() > n3) {
                    throw new IllegalThumbException();
                }
                this.data = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalThumbException();
            }
        }

        int getWidth() {
            int n2 = 0;
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.thumbMetadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment = JFIFMarkerSegment.class$("com.sun.imageio.plugins.jpeg.SOFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment, true);
            if (sOFMarkerSegment != null) {
                n2 = sOFMarkerSegment.samplesPerLine;
            }
            return n2;
        }

        int getHeight() {
            int n2 = 0;
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.thumbMetadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment = JFIFMarkerSegment.class$("com.sun.imageio.plugins.jpeg.SOFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment, true);
            if (sOFMarkerSegment != null) {
                n2 = sOFMarkerSegment.numLines;
            }
            return n2;
        }

        BufferedImage getThumbnail(ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
            imageInputStream.mark();
            imageInputStream.seek(this.streamPos);
            JPEGImageReader jPEGImageReader2 = new JPEGImageReader(null);
            jPEGImageReader2.setInput(imageInputStream);
            jPEGImageReader2.addIIOReadProgressListener(new ThumbnailReadListener(jPEGImageReader));
            BufferedImage bufferedImage = jPEGImageReader2.read(0, null);
            jPEGImageReader2.dispose();
            imageInputStream.reset();
            return bufferedImage;
        }

        protected Object clone() {
            JFIFThumbJPEG jFIFThumbJPEG = (JFIFThumbJPEG)super.clone();
            if (this.thumbMetadata != null) {
                jFIFThumbJPEG.thumbMetadata = (JPEGMetadata)this.thumbMetadata.clone();
            }
            return jFIFThumbJPEG;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("JFIFthumbJPEG");
            if (this.thumbMetadata != null) {
                iIOMetadataNode.appendChild(this.thumbMetadata.getNativeTree());
            }
            return iIOMetadataNode;
        }

        int getLength() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            int n2 = this.data.length / 20;
            if (n2 == 0) {
                n2 = 1;
            }
            int n3 = 0;
            while (n3 < this.data.length) {
                int n4 = Math.min(n2, this.data.length - n3);
                imageOutputStream.write(this.data, n3, n4);
                float f2 = (float)(n3 += n2) * 100.0f / (float)this.data.length;
                if (f2 > 100.0f) {
                    f2 = 100.0f;
                }
                jPEGImageWriter.thumbnailProgress(f2);
            }
        }

        void print() {
            System.out.println("JFIF thumbnail stored as JPEG");
        }

        private class ThumbnailReadListener
        implements IIOReadProgressListener {
            JPEGImageReader reader = null;

            ThumbnailReadListener(JPEGImageReader jPEGImageReader) {
                this.reader = jPEGImageReader;
            }

            public void sequenceStarted(ImageReader imageReader, int n2) {
            }

            public void sequenceComplete(ImageReader imageReader) {
            }

            public void imageStarted(ImageReader imageReader, int n2) {
            }

            public void imageProgress(ImageReader imageReader, float f2) {
                this.reader.thumbnailProgress(f2);
            }

            public void imageComplete(ImageReader imageReader) {
            }

            public void thumbnailStarted(ImageReader imageReader, int n2, int n3) {
            }

            public void thumbnailProgress(ImageReader imageReader, float f2) {
            }

            public void thumbnailComplete(ImageReader imageReader) {
            }

            public void readAborted(ImageReader imageReader) {
            }
        }
    }

    class JFIFThumbPalette
    extends JFIFThumbUncompressed {
        private static final int PALETTE_SIZE = 768;

        JFIFThumbPalette(JPEGBuffer jPEGBuffer, int n2, int n3) throws IOException {
            super(jPEGBuffer, n2, n3, 768 + n2 * n3, "JFIFThumbPalette");
        }

        JFIFThumbPalette(Node node) throws IIOInvalidTreeException {
            super(node, "JFIFThumbPalette");
        }

        JFIFThumbPalette(BufferedImage bufferedImage) throws IllegalThumbException {
            super(bufferedImage);
            IndexColorModel indexColorModel = (IndexColorModel)this.thumbnail.getColorModel();
            if (indexColorModel.getMapSize() > 256) {
                throw new IllegalThumbException();
            }
        }

        int getLength() {
            return this.thumbWidth * this.thumbHeight + 768;
        }

        BufferedImage getThumbnail(ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
            imageInputStream.mark();
            imageInputStream.seek(this.streamPos);
            byte[] byArray = new byte[768];
            float f2 = 768.0f / (float)this.getLength();
            this.readByteBuffer(imageInputStream, byArray, jPEGImageReader, f2, 0.0f);
            DataBufferByte dataBufferByte = new DataBufferByte(this.thumbWidth * this.thumbHeight);
            this.readByteBuffer(imageInputStream, dataBufferByte.getData(), jPEGImageReader, 1.0f - f2, f2);
            imageInputStream.read();
            imageInputStream.reset();
            IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray, 0, false);
            SampleModel sampleModel = indexColorModel.createCompatibleSampleModel(this.thumbWidth, this.thumbHeight);
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
            return new BufferedImage(indexColorModel, writableRaster, false, null);
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            super.write(imageOutputStream, jPEGImageWriter);
            byte[] byArray = new byte[768];
            IndexColorModel indexColorModel = (IndexColorModel)this.thumbnail.getColorModel();
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            byte[] byArray4 = new byte[256];
            indexColorModel.getReds(byArray2);
            indexColorModel.getGreens(byArray3);
            indexColorModel.getBlues(byArray4);
            int n2 = 0;
            while (n2 < 256) {
                byArray[n2 * 3] = byArray2[n2];
                byArray[n2 * 3 + 1] = byArray3[n2];
                byArray[n2 * 3 + 2] = byArray4[n2];
                ++n2;
            }
            imageOutputStream.write(byArray);
            this.writePixels(imageOutputStream, jPEGImageWriter);
        }
    }

    class JFIFThumbRGB
    extends JFIFThumbUncompressed {
        JFIFThumbRGB(JPEGBuffer jPEGBuffer, int n2, int n3) throws IOException {
            super(jPEGBuffer, n2, n3, n2 * n3 * 3, "JFIFthumbRGB");
        }

        JFIFThumbRGB(Node node) throws IIOInvalidTreeException {
            super(node, "JFIFthumbRGB");
        }

        JFIFThumbRGB(BufferedImage bufferedImage) throws IllegalThumbException {
            super(bufferedImage);
        }

        int getLength() {
            return this.thumbWidth * this.thumbHeight * 3;
        }

        BufferedImage getThumbnail(ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
            imageInputStream.mark();
            imageInputStream.seek(this.streamPos);
            DataBufferByte dataBufferByte = new DataBufferByte(this.getLength());
            this.readByteBuffer(imageInputStream, dataBufferByte.getData(), jPEGImageReader, 1.0f, 0.0f);
            imageInputStream.reset();
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, this.thumbWidth, this.thumbHeight, this.thumbWidth * 3, 3, new int[]{0, 1, 2}, null);
            ComponentColorModel componentColorModel = new ComponentColorModel(JPEG.sRGB, false, false, 1, 0);
            return new BufferedImage(componentColorModel, writableRaster, false, null);
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            super.write(imageOutputStream, jPEGImageWriter);
            this.writePixels(imageOutputStream, jPEGImageWriter);
        }
    }

    abstract class JFIFThumbUncompressed
    extends JFIFThumb {
        BufferedImage thumbnail;
        int thumbWidth;
        int thumbHeight;
        String name;

        JFIFThumbUncompressed(JPEGBuffer jPEGBuffer, int n2, int n3, int n4, String string) throws IOException {
            super(jPEGBuffer);
            this.thumbnail = null;
            this.thumbWidth = n2;
            this.thumbHeight = n3;
            jPEGBuffer.skipData(n4);
            this.name = string;
        }

        JFIFThumbUncompressed(Node node, String string) throws IIOInvalidTreeException {
            this.thumbnail = null;
            this.thumbWidth = 0;
            this.thumbHeight = 0;
            this.name = string;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n2 = namedNodeMap.getLength();
            if (n2 > 2) {
                throw new IIOInvalidTreeException(string + " node cannot have > 2 attributes", node);
            }
            if (n2 != 0) {
                int n3 = MarkerSegment.getAttributeValue(node, namedNodeMap, "thumbWidth", 0, 255, false);
                this.thumbWidth = n3 != -1 ? n3 : this.thumbWidth;
                n3 = MarkerSegment.getAttributeValue(node, namedNodeMap, "thumbHeight", 0, 255, false);
                this.thumbHeight = n3 != -1 ? n3 : this.thumbHeight;
            }
        }

        JFIFThumbUncompressed(BufferedImage bufferedImage) {
            this.thumbnail = null;
            this.thumbnail = bufferedImage;
            this.thumbWidth = bufferedImage.getWidth();
            this.thumbHeight = bufferedImage.getHeight();
            this.name = null;
        }

        void readByteBuffer(ImageInputStream imageInputStream, byte[] byArray, JPEGImageReader jPEGImageReader, float f2, float f3) throws IOException {
            int n2 = Math.max((int)((float)(byArray.length / 20) / f2), 1);
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = Math.min(n2, byArray.length - n3);
                imageInputStream.read(byArray, n3, n4);
                float f4 = (float)(n3 += n2) * 100.0f / (float)byArray.length * f2 + f3;
                if (f4 > 100.0f) {
                    f4 = 100.0f;
                }
                jPEGImageReader.thumbnailProgress(f4);
            }
        }

        int getWidth() {
            return this.thumbWidth;
        }

        int getHeight() {
            return this.thumbHeight;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(this.name);
            iIOMetadataNode.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
            iIOMetadataNode.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
            return iIOMetadataNode;
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            if (this.thumbWidth > 255 || this.thumbHeight > 255) {
                jPEGImageWriter.warningOccurred(12);
            }
            this.thumbWidth = Math.min(this.thumbWidth, 255);
            this.thumbHeight = Math.min(this.thumbHeight, 255);
            imageOutputStream.write(this.thumbWidth);
            imageOutputStream.write(this.thumbHeight);
        }

        void writePixels(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            if (this.thumbWidth > 255 || this.thumbHeight > 255) {
                jPEGImageWriter.warningOccurred(12);
            }
            this.thumbWidth = Math.min(this.thumbWidth, 255);
            this.thumbHeight = Math.min(this.thumbHeight, 255);
            int[] nArray = this.thumbnail.getRaster().getPixels(0, 0, this.thumbWidth, this.thumbHeight, (int[])null);
            JFIFMarkerSegment.this.writeThumbnailData(imageOutputStream, nArray, jPEGImageWriter);
        }

        void print() {
            System.out.print(this.name + " width: ");
            System.out.println(this.thumbWidth);
            System.out.print(this.name + " height: ");
            System.out.println(this.thumbHeight);
        }
    }

    abstract class JFIFThumb
    implements Cloneable {
        long streamPos = -1L;

        abstract int getLength();

        abstract int getWidth();

        abstract int getHeight();

        abstract BufferedImage getThumbnail(ImageInputStream var1, JPEGImageReader var2) throws IOException;

        protected JFIFThumb() {
        }

        protected JFIFThumb(JPEGBuffer jPEGBuffer) throws IOException {
            this.streamPos = jPEGBuffer.getStreamPosition();
        }

        abstract void print();

        abstract IIOMetadataNode getNativeNode();

        abstract void write(ImageOutputStream var1, JPEGImageWriter var2) throws IOException;

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    class JFIFExtensionMarkerSegment
    extends MarkerSegment {
        int code;
        JFIFThumb thumb;
        private static final int DATA_SIZE = 6;
        private static final int ID_SIZE = 5;

        JFIFExtensionMarkerSegment(JPEGBuffer jPEGBuffer, JPEGImageReader jPEGImageReader) throws IOException {
            super(jPEGBuffer);
            jPEGBuffer.bufPtr += 5;
            this.code = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
            jPEGBuffer.bufAvail -= 6;
            if (this.code == 16) {
                this.thumb = new JFIFThumbJPEG(jPEGBuffer, this.length, jPEGImageReader);
            } else {
                jPEGBuffer.loadBuf(2);
                int n2 = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
                int n3 = jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
                jPEGBuffer.bufAvail -= 2;
                this.thumb = this.code == 17 ? new JFIFThumbPalette(jPEGBuffer, n2, n3) : new JFIFThumbRGB(jPEGBuffer, n2, n3);
            }
        }

        JFIFExtensionMarkerSegment(Node node) throws IIOInvalidTreeException {
            super(224);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap.getLength() > 0) {
                this.code = MarkerSegment.getAttributeValue(node, namedNodeMap, "extensionCode", 16, 19, false);
                if (this.code == 18) {
                    throw new IIOInvalidTreeException("invalid extensionCode attribute value", node);
                }
            } else {
                this.code = 18;
            }
            if (node.getChildNodes().getLength() != 1) {
                throw new IIOInvalidTreeException("app0JFXX node must have exactly 1 child", node);
            }
            Node node2 = node.getFirstChild();
            String string = node2.getNodeName();
            if (string.equals("JFIFthumbJPEG")) {
                if (this.code == 18) {
                    this.code = 16;
                }
                this.thumb = new JFIFThumbJPEG(node2);
            } else if (string.equals("JFIFthumbPalette")) {
                if (this.code == 18) {
                    this.code = 17;
                }
                this.thumb = new JFIFThumbPalette(node2);
            } else if (string.equals("JFIFthumbRGB")) {
                if (this.code == 18) {
                    this.code = 19;
                }
                this.thumb = new JFIFThumbRGB(node2);
            } else {
                throw new IIOInvalidTreeException("unrecognized app0JFXX child node", node);
            }
        }

        JFIFExtensionMarkerSegment(BufferedImage bufferedImage) throws IllegalThumbException {
            super(224);
            ColorModel colorModel = bufferedImage.getColorModel();
            int n2 = colorModel.getColorSpace().getType();
            if (colorModel.hasAlpha()) {
                throw new IllegalThumbException();
            }
            if (colorModel instanceof IndexColorModel) {
                this.code = 17;
                this.thumb = new JFIFThumbPalette(bufferedImage);
            } else if (n2 == 5) {
                this.code = 19;
                this.thumb = new JFIFThumbRGB(bufferedImage);
            } else if (n2 == 6) {
                this.code = 16;
                this.thumb = new JFIFThumbJPEG(bufferedImage);
            } else {
                throw new IllegalThumbException();
            }
        }

        void setThumbnail(BufferedImage bufferedImage) {
            try {
                switch (this.code) {
                    case 17: {
                        this.thumb = new JFIFThumbPalette(bufferedImage);
                        break;
                    }
                    case 19: {
                        this.thumb = new JFIFThumbRGB(bufferedImage);
                        break;
                    }
                    case 16: {
                        this.thumb = new JFIFThumbJPEG(bufferedImage);
                    }
                }
            }
            catch (IllegalThumbException illegalThumbException) {
                throw new InternalError("Illegal thumb in setThumbnail!");
            }
        }

        protected Object clone() {
            JFIFExtensionMarkerSegment jFIFExtensionMarkerSegment = (JFIFExtensionMarkerSegment)super.clone();
            if (this.thumb != null) {
                jFIFExtensionMarkerSegment.thumb = (JFIFThumb)this.thumb.clone();
            }
            return jFIFExtensionMarkerSegment;
        }

        IIOMetadataNode getNativeNode() {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("app0JFXX");
            iIOMetadataNode.setAttribute("extensionCode", Integer.toString(this.code));
            iIOMetadataNode.appendChild(this.thumb.getNativeNode());
            return iIOMetadataNode;
        }

        void write(ImageOutputStream imageOutputStream, JPEGImageWriter jPEGImageWriter) throws IOException {
            this.length = 8 + this.thumb.getLength();
            this.writeTag(imageOutputStream);
            byte[] byArray = new byte[]{74, 70, 88, 88, 0};
            imageOutputStream.write(byArray);
            imageOutputStream.write(this.code);
            this.thumb.write(imageOutputStream, jPEGImageWriter);
        }

        void print() {
            this.printTag("JFXX");
            this.thumb.print();
        }
    }

    private class IllegalThumbException
    extends Exception {
        private IllegalThumbException() {
        }
    }
}

