/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsClient;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class Resolver {
    private DnsClient dnsClient;
    private int timeout;
    private int retries;

    Resolver(String[] stringArray, int n2, int n3) throws NamingException {
        this.timeout = n2;
        this.retries = n3;
        this.dnsClient = new DnsClient(stringArray, n2, n3);
    }

    public void close() {
        this.dnsClient.close();
    }

    ResourceRecords query(String string, int n2, int n3, boolean bl2, boolean bl3) throws NamingException {
        return this.dnsClient.query(string, n2, n3, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(String string, int n2, boolean bl2) throws NamingException {
        DnsClient dnsClient = new DnsClient(this.findNameServers(string, bl2), this.timeout, this.retries);
        try {
            ResourceRecords resourceRecords = dnsClient.queryZone(string, n2, bl2);
            Object var7_6 = null;
            dnsClient.close();
            return resourceRecords;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            dnsClient.close();
            throw throwable;
        }
    }

    String findZoneName(String string, int n2, boolean bl2) throws NamingException {
        if (string.equals(".")) {
            return string;
        }
        DnsName dnsName = new DnsName(string);
        while (dnsName.size() > 0) {
            String string2 = ((Object)dnsName).toString();
            ResourceRecords resourceRecords = null;
            try {
                resourceRecords = this.query(string2, n2, 6, bl2, false);
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (resourceRecords != null) {
                if (resourceRecords.answer.size() > 0) {
                    return string2;
                }
                int n3 = 0;
                while (n3 < resourceRecords.authority.size()) {
                    String string3;
                    ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.authority.elementAt(n3);
                    if (resourceRecord.getType() == 6 && ((string3 = resourceRecord.getName()).equals(".") || Resolver.isSuffix(string3, string2))) {
                        return string3;
                    }
                    ++n3;
                }
            }
            dnsName.remove(dnsName.size() - 1);
        }
        return ".";
    }

    private static boolean isSuffix(String string, String string2) {
        int n2;
        int n3 = string.length();
        return n3 <= (n2 = string2.length()) && string.equalsIgnoreCase(string2.substring(n2 - n3));
    }

    private String[] findNameServers(String string, boolean bl2) throws NamingException {
        ResourceRecords resourceRecords = this.query(string, 1, 2, bl2, false);
        String[] stringArray = new String[resourceRecords.answer.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(n2);
            if (resourceRecord.getType() != 2) {
                throw new CommunicationException("Corrupted DNS message");
            }
            stringArray[n2] = (String)resourceRecord.getRdata();
            ++n2;
        }
        return stringArray;
    }
}

