/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public abstract class AbstractMidiDeviceProvider
extends MidiDeviceProvider {
    protected synchronized void readDeviceInfos() {
        int n2;
        Info[] infoArray = this.getInfoCache();
        MidiDevice[] midiDeviceArray = this.getDeviceCache();
        int n3 = infoArray == null ? -1 : infoArray.length;
        if (n3 != (n2 = this.getNumDevices())) {
            Info[] infoArray2 = new Info[n2];
            MidiDevice[] midiDeviceArray2 = new MidiDevice[n2];
            int n4 = 0;
            while (n4 < n2) {
                Info info = this.createInfo(n4);
                if (infoArray != null) {
                    int n5 = 0;
                    while (n5 < infoArray.length) {
                        Info info2 = infoArray[n5];
                        if (info2 != null && info2.equalStrings(info)) {
                            infoArray2[n4] = info2;
                            info2.setIndex(n4);
                            infoArray[n5] = null;
                            midiDeviceArray2[n4] = midiDeviceArray[n5];
                            midiDeviceArray[n5] = null;
                            break;
                        }
                        ++n5;
                    }
                }
                if (infoArray2[n4] == null) {
                    infoArray2[n4] = info;
                }
                ++n4;
            }
            if (infoArray != null) {
                int n6 = 0;
                while (n6 < infoArray.length) {
                    if (infoArray[n6] != null) {
                        infoArray[n6].setIndex(-1);
                    }
                    ++n6;
                }
            }
            this.setInfoCache(infoArray2);
            this.setDeviceCache(midiDeviceArray2);
        }
    }

    public MidiDevice.Info[] getDeviceInfo() {
        this.readDeviceInfos();
        Info[] infoArray = this.getInfoCache();
        MidiDevice.Info[] infoArray2 = new MidiDevice.Info[infoArray.length];
        System.arraycopy(infoArray, 0, infoArray2, 0, infoArray.length);
        return infoArray2;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        if (info instanceof Info) {
            this.readDeviceInfos();
            MidiDevice[] midiDeviceArray = this.getDeviceCache();
            Info[] infoArray = this.getInfoCache();
            Info info2 = (Info)info;
            int n2 = info2.getIndex();
            if (n2 >= 0 && n2 < midiDeviceArray.length && infoArray[n2] == info) {
                if (midiDeviceArray[n2] == null) {
                    midiDeviceArray[n2] = this.createDevice(info2);
                }
                if (midiDeviceArray[n2] != null) {
                    return midiDeviceArray[n2];
                }
            }
        }
        throw new IllegalArgumentException("MidiDevice " + info.toString() + " not supported by this provider.");
    }

    protected abstract int getNumDevices();

    protected abstract MidiDevice[] getDeviceCache();

    protected abstract void setDeviceCache(MidiDevice[] var1);

    protected abstract Info[] getInfoCache();

    protected abstract void setInfoCache(Info[] var1);

    protected abstract Info createInfo(int var1);

    protected abstract MidiDevice createDevice(Info var1);

    static {
        Platform.initialize();
    }

    static class Info
    extends MidiDevice.Info {
        private int index;

        Info(String string, String string2, String string3, String string4, int n2) {
            super(string, string2, string3, string4);
            this.index = n2;
        }

        boolean equalStrings(Info info) {
            return info != null && this.getName().equals(info.getName()) && this.getVendor().equals(info.getVendor()) && this.getDescription().equals(info.getDescription()) && this.getVersion().equals(info.getVersion());
        }

        int getIndex() {
            return this.index;
        }

        void setIndex(int n2) {
            this.index = n2;
        }
    }
}

