/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.AreaIterator;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.AreaOp;
import sun.awt.geom.Crossings;
import sun.awt.geom.Curve;

public class Area
implements Shape,
Cloneable {
    private static Vector EmptyCurves = new Vector();
    private Vector curves;
    private Rectangle2D cachedBounds;

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(Shape shape) {
        if (shape instanceof Area) {
            this.curves = ((Area)shape).curves;
            return;
        }
        this.curves = new Vector();
        PathIterator pathIterator = shape.getPathIterator(null);
        int n2 = pathIterator.getWindingRule();
        double[] dArray = new double[23];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    Curve.insertLine(this.curves, d4, d5, d2, d3);
                    d4 = d2 = dArray[0];
                    d5 = d3 = dArray[1];
                    Curve.insertMove(this.curves, d2, d3);
                    break;
                }
                case 1: {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    Curve.insertLine(this.curves, d4, d5, d6, d7);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 2: {
                    double d6 = dArray[2];
                    double d7 = dArray[3];
                    Curve.insertQuad(this.curves, d4, d5, dArray);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 3: {
                    double d6 = dArray[4];
                    double d7 = dArray[5];
                    Curve.insertCubic(this.curves, d4, d5, dArray);
                    d4 = d6;
                    d5 = d7;
                    break;
                }
                case 4: {
                    Curve.insertLine(this.curves, d4, d5, d2, d3);
                    d4 = d2;
                    d5 = d3;
                }
            }
            pathIterator.next();
        }
        Curve.insertLine(this.curves, d4, d5, d2, d3);
        AreaOp areaOp = n2 == 0 ? new AreaOp.EOWindOp() : new AreaOp.NZWindOp();
        this.curves = areaOp.calculate(this.curves, EmptyCurves);
    }

    public void add(Area area) {
        this.curves = new AreaOp.AddOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void subtract(Area area) {
        this.curves = new AreaOp.SubOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void intersect(Area area) {
        this.curves = new AreaOp.IntOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void exclusiveOr(Area area) {
        this.curves = new AreaOp.XorOp().calculate(this.curves, area.curves);
        this.invalidateBounds();
    }

    public void reset() {
        this.curves = new Vector();
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    public boolean isPolygonal() {
        Enumeration enumeration = this.curves.elements();
        while (enumeration.hasMoreElements()) {
            if (((Curve)enumeration.nextElement()).getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        int n2 = this.curves.size();
        if (n2 == 0) {
            return true;
        }
        if (n2 > 3) {
            return false;
        }
        Curve curve = (Curve)this.curves.get(1);
        Curve curve2 = (Curve)this.curves.get(2);
        if (curve.getOrder() != 1 || curve2.getOrder() != 1) {
            return false;
        }
        if (curve.getXTop() != curve.getXBot() || curve2.getXTop() != curve2.getXBot()) {
            return false;
        }
        return curve.getYTop() == curve2.getYTop() && curve.getYBot() == curve2.getYBot();
    }

    public boolean isSingular() {
        if (this.curves.size() < 3) {
            return true;
        }
        Enumeration enumeration = this.curves.elements();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            if (((Curve)enumeration.nextElement()).getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    private void invalidateBounds() {
        this.cachedBounds = null;
    }

    private Rectangle2D getCachedBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.curves.size() > 0) {
            Curve curve = (Curve)this.curves.get(0);
            ((Rectangle2D)double_).setRect(curve.getX0(), curve.getY0(), 0.0, 0.0);
            int n2 = 1;
            while (n2 < this.curves.size()) {
                ((Curve)this.curves.get(n2)).enlarge(double_);
                ++n2;
            }
        }
        this.cachedBounds = double_;
        return this.cachedBounds;
    }

    public Rectangle2D getBounds2D() {
        return this.getCachedBounds().getBounds2D();
    }

    public Rectangle getBounds() {
        return this.getCachedBounds().getBounds();
    }

    public Object clone() {
        return new Area(this);
    }

    public boolean equals(Area area) {
        if (area == this) {
            return true;
        }
        if (area == null) {
            return false;
        }
        Vector vector = new AreaOp.XorOp().calculate(this.curves, area.curves);
        return vector.isEmpty();
    }

    public void transform(AffineTransform affineTransform) {
        this.curves = new Area((Shape)affineTransform.createTransformedShape((Shape)this)).curves;
        this.invalidateBounds();
    }

    public Area createTransformedArea(AffineTransform affineTransform) {
        return new Area(affineTransform.createTransformedShape(this));
    }

    public boolean contains(double d2, double d3) {
        if (!this.getCachedBounds().contains(d2, d3)) {
            return false;
        }
        Enumeration enumeration = this.curves.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            n2 += curve.crossingsFor(d2, d3);
        }
        return n2 & true;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        if (d4 < 0.0 || d5 < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().contains(d2, d3, d4, d5)) {
            return false;
        }
        Crossings crossings = Crossings.findCrossings(this.curves, d2, d3, d2 + d4, d3 + d5);
        return crossings != null && crossings.covers(d3, d3 + d5);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (d4 < 0.0 || d5 < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().intersects(d2, d3, d4, d5)) {
            return false;
        }
        Crossings crossings = Crossings.findCrossings(this.curves, d2, d3, d2 + d4, d3 + d5);
        return crossings == null || !crossings.isEmpty();
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new AreaIterator(this.curves, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d2);
    }
}

