/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.EllipseIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public abstract class Ellipse2D
extends RectangularShape {
    protected Ellipse2D() {
    }

    public boolean contains(double d2, double d3) {
        double d4 = this.getWidth();
        if (d4 <= 0.0) {
            return false;
        }
        double d5 = (d2 - this.getX()) / d4 - 0.5;
        double d6 = this.getHeight();
        if (d6 <= 0.0) {
            return false;
        }
        double d7 = (d3 - this.getY()) / d6 - 0.5;
        return d5 * d5 + d7 * d7 < 0.25;
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (d4 <= 0.0 || d5 <= 0.0) {
            return false;
        }
        double d6 = this.getWidth();
        if (d6 <= 0.0) {
            return false;
        }
        double d7 = (d2 - this.getX()) / d6 - 0.5;
        double d8 = d7 + d4 / d6;
        double d9 = this.getHeight();
        if (d9 <= 0.0) {
            return false;
        }
        double d10 = (d3 - this.getY()) / d9 - 0.5;
        double d11 = d10 + d5 / d9;
        double d12 = d7 > 0.0 ? d7 : (d8 < 0.0 ? d8 : 0.0);
        double d13 = d10 > 0.0 ? d10 : (d11 < 0.0 ? d11 : 0.0);
        return d12 * d12 + d13 * d13 < 0.25;
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.contains(d2, d3) && this.contains(d2 + d4, d3) && this.contains(d2, d3 + d5) && this.contains(d2 + d4, d3 + d5);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new EllipseIterator(this, affineTransform);
    }

    public static class Double
    extends Ellipse2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double d2, double d3, double d4, double d5) {
            this.setFrame(d2, d3, d4, d5);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setFrame(double d2, double d3, double d4, double d5) {
            this.x = d2;
            this.y = d3;
            this.width = d4;
            this.height = d5;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    public static class Float
    extends Ellipse2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float f2, float f3, float f4, float f5) {
            this.setFrame(f2, f3, f4, f5);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return (double)this.width <= 0.0 || (double)this.height <= 0.0;
        }

        public void setFrame(float f2, float f3, float f4, float f5) {
            this.x = f2;
            this.y = f3;
            this.width = f4;
            this.height = f5;
        }

        public void setFrame(double d2, double d3, double d4, double d5) {
            this.x = (float)d2;
            this.y = (float)d3;
            this.width = (float)d4;
            this.height = (float)d5;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }
    }
}

