/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public abstract class PackedColorModel
extends ColorModel {
    int[] maskArray;
    int[] maskOffsets;
    float[] scaleFactors;

    public PackedColorModel(ColorSpace colorSpace, int n2, int[] nArray, int n3, boolean bl2, int n4, int n5) {
        super(n2, PackedColorModel.createBitsArray(nArray, n3), colorSpace, n3 != 0, bl2, n4, n5);
        if (n2 < 1 || n2 > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        this.maskArray = new int[this.numComponents];
        this.maskOffsets = new int[this.numComponents];
        this.scaleFactors = new float[this.numComponents];
        int n6 = 0;
        while (n6 < this.numColorComponents) {
            this.DecomposeMask(nArray[n6], n6, colorSpace.getName(n6));
            ++n6;
        }
        if (n3 != 0) {
            this.DecomposeMask(n3, this.numColorComponents, "alpha");
            if (this.nBits[this.numComponents - 1] == 1) {
                this.transparency = 2;
            }
        }
    }

    public PackedColorModel(ColorSpace colorSpace, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7, int n8) {
        super(n2, PackedColorModel.createBitsArray(n3, n4, n5, n6), colorSpace, n6 != 0, bl2, n7, n8);
        if (colorSpace.getType() != 5) {
            throw new IllegalArgumentException("ColorSpace must be TYPE_RGB.");
        }
        this.maskArray = new int[this.numComponents];
        this.maskOffsets = new int[this.numComponents];
        this.scaleFactors = new float[this.numComponents];
        this.DecomposeMask(n3, 0, "red");
        this.DecomposeMask(n4, 1, "green");
        this.DecomposeMask(n5, 2, "blue");
        if (n6 != 0) {
            this.DecomposeMask(n6, 3, "alpha");
            if (this.nBits[3] == 1) {
                this.transparency = 2;
            }
        }
    }

    public final int getMask(int n2) {
        return this.maskArray[n2];
    }

    public final int[] getMasks() {
        return (int[])this.maskArray.clone();
    }

    private void DecomposeMask(int n2, int n3, String string) {
        int n4 = 0;
        int n5 = this.nBits[n3];
        this.maskArray[n3] = n2;
        if (n2 != 0) {
            while ((n2 & 1) == 0) {
                n2 >>>= 1;
                ++n4;
            }
        }
        if (n4 + n5 > this.pixel_bits) {
            throw new IllegalArgumentException(string + " mask " + Integer.toHexString(this.maskArray[n3]) + " overflows pixel (expecting " + this.pixel_bits + " bits");
        }
        this.maskOffsets[n3] = n4;
        this.scaleFactors[n3] = n5 == 0 ? 256.0f : 255.0f / (float)((1 << n5) - 1);
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        return new SinglePixelPackedSampleModel(this.transferType, n2, n3, this.maskArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (this.numComponents != sampleModel.getNumBands()) {
            return false;
        }
        if (sampleModel.getTransferType() != this.transferType) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != this.maskArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != this.maskArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int[] nArray = new int[]{writableRaster.getNumBands() - 1};
        return writableRaster.createWritableChild(n2, n3, writableRaster.getWidth(), writableRaster.getHeight(), n2, n3, nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PackedColorModel)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PackedColorModel packedColorModel = (PackedColorModel)object;
        int n2 = packedColorModel.getNumComponents();
        if (n2 != this.numComponents) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.maskArray[n3] != packedColorModel.getMask(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static final int[] createBitsArray(int[] nArray, int n2) {
        int n3 = nArray.length;
        int n4 = n2 == 0 ? 0 : 1;
        int[] nArray2 = new int[n3 + n4];
        int n5 = 0;
        while (n5 < n3) {
            nArray2[n5] = PackedColorModel.countBits(nArray[n5]);
            if (nArray2[n5] < 0) {
                throw new IllegalArgumentException("Noncontiguous color mask (" + Integer.toHexString(nArray[n5]) + "at index " + n5);
            }
            ++n5;
        }
        if (n2 != 0) {
            nArray2[n3] = PackedColorModel.countBits(n2);
            if (nArray2[n3] < 0) {
                throw new IllegalArgumentException("Noncontiguous alpha mask (" + Integer.toHexString(n2));
            }
        }
        return nArray2;
    }

    private static final int[] createBitsArray(int n2, int n3, int n4, int n5) {
        int[] nArray = new int[3 + (n5 == 0 ? 0 : 1)];
        nArray[0] = PackedColorModel.countBits(n2);
        nArray[1] = PackedColorModel.countBits(n3);
        nArray[2] = PackedColorModel.countBits(n4);
        if (nArray[0] < 0) {
            throw new IllegalArgumentException("Noncontiguous red mask (" + Integer.toHexString(n2));
        }
        if (nArray[1] < 0) {
            throw new IllegalArgumentException("Noncontiguous green mask (" + Integer.toHexString(n3));
        }
        if (nArray[2] < 0) {
            throw new IllegalArgumentException("Noncontiguous blue mask (" + Integer.toHexString(n4));
        }
        if (n5 != 0) {
            nArray[3] = PackedColorModel.countBits(n5);
            if (nArray[3] < 0) {
                throw new IllegalArgumentException("Noncontiguous alpha mask (" + Integer.toHexString(n5));
            }
        }
        return nArray;
    }

    private static final int countBits(int n2) {
        int n3 = 0;
        if (n2 != 0) {
            while ((n2 & 1) == 0) {
                n2 >>>= 1;
            }
            while ((n2 & 1) == 1) {
                n2 >>>= 1;
                ++n3;
            }
        }
        if (n2 != 0) {
            return -1;
        }
        return n3;
    }
}

