/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;

class ObjectInputStreamWithLoader
extends ObjectInputStream {
    private ClassLoader loader;

    public ObjectInputStreamWithLoader(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (classLoader == null) {
            throw new IllegalArgumentException("Illegal null argument to ObjectInputStreamWithLoader");
        }
        this.loader = classLoader;
    }

    private Class primitiveType(char c2) {
        switch (c2) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class clazz;
            int n2 = 1;
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            if (string.charAt(n2) == 'L') {
                clazz = this.loader.loadClass(string.substring(n2 + 1, string.length() - 1));
            } else {
                if (string.length() != n2 + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n2));
            }
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 0;
                ++n3;
            }
            return Array.newInstance(clazz, nArray).getClass();
        }
        return this.loader.loadClass(string);
    }
}

