/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ObjectStreamClass;
import java.lang.reflect.Field;

public class ObjectStreamField
implements Comparable {
    private final String name;
    private final String signature;
    private final Class type;
    private final boolean unshared;
    private final Field field;
    private int offset = 0;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectStreamField(String string, Class clazz) {
        this(string, clazz, false);
    }

    public ObjectStreamField(String string, Class clazz, boolean bl2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.type = clazz;
        this.unshared = bl2;
        this.signature = ObjectStreamClass.getClassSignature(clazz).intern();
        this.field = null;
    }

    ObjectStreamField(String string, String string2, boolean bl2) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.signature = string2.intern();
        this.unshared = bl2;
        this.field = null;
        switch (string2.charAt(0)) {
            case 'Z': {
                this.type = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.type = Byte.TYPE;
                break;
            }
            case 'C': {
                this.type = Character.TYPE;
                break;
            }
            case 'S': {
                this.type = Short.TYPE;
                break;
            }
            case 'I': {
                this.type = Integer.TYPE;
                break;
            }
            case 'J': {
                this.type = Long.TYPE;
                break;
            }
            case 'F': {
                this.type = Float.TYPE;
                break;
            }
            case 'D': {
                this.type = Double.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.type = class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamField.class$("java.lang.Object")) : class$java$lang$Object;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal signature");
            }
        }
    }

    ObjectStreamField(Field field, boolean bl2, boolean bl3) {
        this.field = field;
        this.unshared = bl2;
        this.name = field.getName();
        Class clazz = field.getType();
        this.type = bl3 || clazz.isPrimitive() ? clazz : (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamField.class$("java.lang.Object")) : class$java$lang$Object);
        this.signature = ObjectStreamClass.getClassSignature(clazz).intern();
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public char getTypeCode() {
        return this.signature.charAt(0);
    }

    public String getTypeString() {
        return this.isPrimitive() ? null : this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int n2) {
        this.offset = n2;
    }

    public boolean isPrimitive() {
        char c2 = this.signature.charAt(0);
        return c2 != 'L' && c2 != '[';
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public int compareTo(Object object) {
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl2 = this.isPrimitive();
        if (bl2 != objectStreamField.isPrimitive()) {
            return bl2 ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public String toString() {
        return this.signature + ' ' + this.name;
    }

    Field getField() {
        return this.field;
    }

    String getSignature() {
        return this.signature;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

