/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class StringBufferInputStream
extends InputStream {
    protected String buffer;
    protected int pos;
    protected int count;

    public StringBufferInputStream(String string) {
        this.buffer = string;
        this.count = string.length();
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buffer.charAt(this.pos++) & 0xFF : -1;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n3 > this.count) {
            n3 = this.count - this.pos;
        }
        if (n3 <= 0) {
            return 0;
        }
        String string = this.buffer;
        int n4 = n3;
        while (--n4 >= 0) {
            byArray[n2++] = (byte)string.charAt(this.pos++);
        }
        return n3;
    }

    public synchronized long skip(long l2) {
        if (l2 < 0L) {
            return 0L;
        }
        if (l2 > (long)(this.count - this.pos)) {
            l2 = this.count - this.pos;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void reset() {
        this.pos = 0;
    }
}

