/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.WeakHashMap;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;

public abstract class Policy {
    private static Policy policy;
    private static final Debug debug;
    private WeakHashMap pdMapping;

    static boolean isSet() {
        return policy != null;
    }

    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getPolicy"));
        }
        return Policy.getPolicyNoCheck();
    }

    static synchronized Policy getPolicyNoCheck() {
        block4: {
            if (policy != null) break block4;
            String string = null;
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("policy.provider");
                }
            });
            if (string == null) {
                string = "sun.security.provider.PolicyFile";
            }
            try {
                policy = (Policy)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                policy = new PolicyFile();
                final String string2 = string;
                Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                            ClassLoader classLoader2 = null;
                            while (classLoader != null) {
                                classLoader2 = classLoader;
                                classLoader = classLoader.getParent();
                            }
                            return classLoader2 != null ? Class.forName(string2, true, classLoader2).newInstance() : null;
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                if (policy != null) {
                    Policy.policy = policy;
                }
                if (policy != null || debug == null) break block4;
                debug.println("policy provider " + string + " not available;using " + "sun.security.provider.PolicyFile");
                exception.printStackTrace();
            }
        }
        return policy;
    }

    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (policy != null) {
            Policy.initPolicy(policy);
        }
        Policy.policy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPolicy(final Policy policy) {
        ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return policy.getClass().getProtectionDomain();
            }
        });
        PermissionCollection permissionCollection = null;
        Policy policy2 = policy;
        synchronized (policy2) {
            if (policy.pdMapping == null) {
                policy.pdMapping = new WeakHashMap();
            }
        }
        if (protectionDomain.getCodeSource() != null) {
            if (Policy.isSet()) {
                permissionCollection = Policy.policy.getPermissions(protectionDomain);
            }
            if (permissionCollection == null) {
                permissionCollection = new Permissions();
                permissionCollection.add(new AllPermission());
            }
            Policy policy3 = policy;
            synchronized (policy3) {
                policy.pdMapping.put(protectionDomain, permissionCollection);
            }
        }
    }

    public abstract PermissionCollection getPermissions(CodeSource var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = null;
        if (protectionDomain == null) {
            return new Permissions();
        }
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            permissionCollection = (PermissionCollection)this.pdMapping.get(protectionDomain);
        }
        if (permissionCollection != null) {
            Permissions permissions = new Permissions();
            Enumeration enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                permissions.add((Permission)enumeration.nextElement());
            }
            return permissions;
        }
        permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
        if (permissionCollection == null) {
            permissionCollection = new Permissions();
        }
        this.addStaticPerms(permissionCollection, protectionDomain.getPermissions());
        return permissionCollection;
    }

    private void addStaticPerms(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        if (permissionCollection2 != null) {
            Enumeration enumeration = permissionCollection2.elements();
            while (enumeration.hasMoreElements()) {
                permissionCollection.add((Permission)enumeration.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        WeakHashMap weakHashMap;
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap weakHashMap2 = weakHashMap = this.pdMapping;
        synchronized (weakHashMap2) {
            permissionCollection = (PermissionCollection)weakHashMap.get(protectionDomain);
        }
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        WeakHashMap weakHashMap3 = weakHashMap;
        synchronized (weakHashMap3) {
            weakHashMap.put(protectionDomain, permissionCollection);
        }
        return permissionCollection.implies(permission);
    }

    public abstract void refresh();

    static {
        debug = Debug.getInstance("policy");
    }
}

