/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static byte[] defaultMessage = new byte[]{-1, 0};
    private int dataLength = 0;

    public MetaMessage() {
        this(defaultMessage);
    }

    protected MetaMessage(byte[] byArray) {
        super(byArray);
        if (byArray.length >= 3) {
            this.dataLength = byArray.length - 3;
            int n2 = 2;
            while (n2 < byArray.length && (byArray[n2] & 0x80) != 0) {
                --this.dataLength;
                ++n2;
            }
        }
    }

    public void setMessage(int n2, byte[] byArray, int n3) throws InvalidMidiDataException {
        if (n2 >= 128) {
            throw new InvalidMidiDataException("Invalid meta event with type " + n2);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(255);
            dataOutputStream.writeByte(n2);
            this.writeVarInt(n3, dataOutputStream);
            dataOutputStream.write(byArray, 0, n3);
            this.data = byteArrayOutputStream.toByteArray();
            this.length = this.data.length;
            this.dataLength = n3;
        }
        catch (IOException iOException) {}
    }

    public int getType() {
        if (this.length >= 2) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.dataLength];
        System.arraycopy(this.data, this.length - this.dataLength, byArray, 0, this.dataLength);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        MetaMessage metaMessage = new MetaMessage(byArray);
        return metaMessage;
    }

    private void writeVarInt(int n2, DataOutputStream dataOutputStream) throws InvalidMidiDataException, IOException {
        int n3 = 6;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n3) {
            byArray[n5] = 0;
            ++n5;
        }
        int n6 = n3 - 1;
        while (n6 >= 0) {
            byArray[n6] = (byte)(n2 & 0x7F);
            n2 >>>= 7;
            if (++n4 > 1) {
                int n7 = n6;
                byArray[n7] = (byte)(byArray[n7] | 0x80);
            }
            if (n2 == 0) break;
            --n6;
        }
        if ((byArray[n3 - 1] & 0x80) != 0) {
            throw new InvalidMidiDataException("Unable to create variable-length integer");
        }
        dataOutputStream.write(byArray, n3 - n4, n4);
    }
}

