/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class MetalInternalFrameUI
extends BasicInternalFrameUI {
    private MetalInternalFrameTitlePane titlePane;
    private static final PropertyChangeListener metalPropertyChangeListener = new MetalPropertyChangeHandler();
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected static String IS_PALETTE = "JInternalFrame.isPalette";
    private static String FRAME_TYPE = "JInternalFrame.frameType";
    private static String NORMAL_FRAME = "normal";
    private static String PALETTE_FRAME = "palette";
    private static String OPTION_DIALOG = "optionDialog";

    public MetalInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(IS_PALETTE);
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
    }

    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        this.frame = (JInternalFrame)jComponent;
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == handyEmptyBorder) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(metalPropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(metalPropertyChangeListener);
        super.uninstallListeners();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(handyEmptyBorder);
        }
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new MetalInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    private void setFrameType(String string) {
        if (string.equals(OPTION_DIALOG)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.optionDialogBorder");
            this.titlePane.setPalette(false);
        } else if (string.equals(PALETTE_FRAME)) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
            this.titlePane.setPalette(true);
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
            this.titlePane.setPalette(false);
        }
    }

    public void setPalette(boolean bl2) {
        if (bl2) {
            LookAndFeel.installBorder(this.frame, "InternalFrame.paletteBorder");
        } else {
            LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        }
        this.titlePane.setPalette(bl2);
    }

    private static class MetalPropertyChangeHandler
    implements PropertyChangeListener {
        private MetalPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            if (!(jInternalFrame.getUI() instanceof MetalInternalFrameUI)) {
                return;
            }
            MetalInternalFrameUI metalInternalFrameUI = (MetalInternalFrameUI)jInternalFrame.getUI();
            if (string.equals(FRAME_TYPE)) {
                if (propertyChangeEvent.getNewValue() instanceof String) {
                    metalInternalFrameUI.setFrameType((String)propertyChangeEvent.getNewValue());
                }
            } else if (string.equals(IS_PALETTE)) {
                if (propertyChangeEvent.getNewValue() != null) {
                    metalInternalFrameUI.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    metalInternalFrameUI.setPalette(false);
                }
            } else if (string.equals("contentPane")) {
                metalInternalFrameUI.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }
    }
}

