/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class IconView
extends View {
    private Icon c;

    public IconView(Element element) {
        super(element);
        AttributeSet attributeSet = element.getAttributes();
        this.c = StyleConstants.getIcon(attributeSet);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.c.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
    }

    public float getPreferredSpan(int n2) {
        switch (n2) {
            case 0: {
                return this.c.getIconWidth();
            }
            case 1: {
                return this.c.getIconHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    public float getAlignment(int n2) {
        switch (n2) {
            case 1: {
                return 1.0f;
            }
        }
        return super.getAlignment(n2);
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        int n3 = this.getStartOffset();
        int n4 = this.getEndOffset();
        if (n2 >= n3 && n2 <= n4) {
            Rectangle rectangle = shape.getBounds();
            if (n2 == n4) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        throw new BadLocationException(n2 + " not in range " + n3 + "," + n4, n2);
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f2 < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }
}

