/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;

public class PasswordView
extends FieldView {
    static char[] ONE = new char[1];

    public PasswordView(Element element) {
        super(element);
    }

    protected int drawUnselectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.drawUnselectedText(graphics, n2, n3, n4, n5);
            }
            if (jPasswordField.isEnabled()) {
                graphics.setColor(jPasswordField.getForeground());
            } else {
                graphics.setColor(jPasswordField.getDisabledTextColor());
            }
            char c2 = jPasswordField.getEchoChar();
            int n6 = n5 - n4;
            int n7 = 0;
            while (n7 < n6) {
                n2 = this.drawEchoCharacter(graphics, n2, n3, c2);
                ++n7;
            }
        }
        return n2;
    }

    protected int drawSelectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.selected);
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.drawSelectedText(graphics, n2, n3, n4, n5);
            }
            char c2 = jPasswordField.getEchoChar();
            int n6 = n5 - n4;
            int n7 = 0;
            while (n7 < n6) {
                n2 = this.drawEchoCharacter(graphics, n2, n3, c2);
                ++n7;
            }
        }
        return n2;
    }

    protected int drawEchoCharacter(Graphics graphics, int n2, int n3, char c2) {
        PasswordView.ONE[0] = c2;
        graphics.drawChars(ONE, 0, 1, n2, n3);
        return n2 + graphics.getFontMetrics().charWidth(c2);
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.modelToView(n2, shape, bias);
            }
            char c2 = jPasswordField.getEchoChar();
            FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
            Rectangle rectangle = this.adjustAllocation(shape).getBounds();
            int n3 = (n2 - this.getStartOffset()) * fontMetrics.charWidth(c2);
            rectangle.x += n3;
            rectangle.width = 1;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        int n2 = 0;
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.viewToModel(f2, f3, shape, biasArray);
            }
            char c2 = jPasswordField.getEchoChar();
            FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
            Rectangle rectangle = (shape = this.adjustAllocation(shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            n2 = ((int)f2 - rectangle.x) / fontMetrics.charWidth(c2);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.getStartOffset() + this.getDocument().getLength()) {
                n2 = this.getDocument().getLength() - this.getStartOffset();
            }
        }
        return this.getStartOffset() + n2;
    }

    public float getPreferredSpan(int n2) {
        switch (n2) {
            case 0: {
                JPasswordField jPasswordField;
                Container container = this.getContainer();
                if (!(container instanceof JPasswordField) || !(jPasswordField = (JPasswordField)container).echoCharIsSet()) break;
                char c2 = jPasswordField.getEchoChar();
                FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
                Document document = this.getDocument();
                return fontMetrics.charWidth(c2) * this.getDocument().getLength();
            }
        }
        return super.getPreferredSpan(n2);
    }
}

