/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFAttribute;
import javax.swing.text.rtf.RTFGenerator;

class RTFAttributes {
    static RTFAttribute[] attributes;

    RTFAttributes() {
    }

    static Dictionary attributesByKeyword() {
        Hashtable hashtable = new Hashtable(attributes.length);
        int n2 = attributes.length;
        int n3 = 0;
        while (n3 < n2) {
            ((Dictionary)hashtable).put(attributes[n3].rtfName(), attributes[n3]);
            ++n3;
        }
        return hashtable;
    }

    static {
        Vector vector = new Vector();
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        int n6 = 4;
        Boolean bl2 = true;
        Boolean bl3 = false;
        vector.addElement(new BooleanAttribute(n2, StyleConstants.Italic, "i"));
        vector.addElement(new BooleanAttribute(n2, StyleConstants.Bold, "b"));
        vector.addElement(new BooleanAttribute(n2, StyleConstants.Underline, "ul"));
        vector.addElement(NumericAttribute.NewTwips(n3, StyleConstants.LeftIndent, "li", 0.0f, 0));
        vector.addElement(NumericAttribute.NewTwips(n3, StyleConstants.RightIndent, "ri", 0.0f, 0));
        vector.addElement(NumericAttribute.NewTwips(n3, StyleConstants.FirstLineIndent, "fi", 0.0f, 0));
        vector.addElement(new AssertiveAttribute(n3, StyleConstants.Alignment, "ql", 0));
        vector.addElement(new AssertiveAttribute(n3, StyleConstants.Alignment, "qr", 2));
        vector.addElement(new AssertiveAttribute(n3, StyleConstants.Alignment, "qc", 1));
        vector.addElement(new AssertiveAttribute(n3, StyleConstants.Alignment, "qj", 3));
        vector.addElement(NumericAttribute.NewTwips(n3, StyleConstants.SpaceAbove, "sa", 0));
        vector.addElement(NumericAttribute.NewTwips(n3, StyleConstants.SpaceBelow, "sb", 0));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_alignment", "tqr", 1));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_alignment", "tqc", 2));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_alignment", "tqdec", 4));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_leader", "tldot", 1));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_leader", "tlhyph", 2));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_leader", "tlul", 3));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_leader", "tlth", 4));
        vector.addElement(new AssertiveAttribute(n6, (Object)"tab_leader", "tleq", 5));
        vector.addElement(new BooleanAttribute(n2, "caps", "caps"));
        vector.addElement(new BooleanAttribute(n2, "outl", "outl"));
        vector.addElement(new BooleanAttribute(n2, "scaps", "scaps"));
        vector.addElement(new BooleanAttribute(n2, "shad", "shad"));
        vector.addElement(new BooleanAttribute(n2, "v", "v"));
        vector.addElement(new BooleanAttribute(n2, "strike", "strike"));
        vector.addElement(new BooleanAttribute(n2, "deleted", "deleted"));
        vector.addElement(new AssertiveAttribute(n5, (Object)"saveformat", "defformat", "RTF"));
        vector.addElement(new AssertiveAttribute(n5, "landscape", "landscape"));
        vector.addElement(NumericAttribute.NewTwips(n5, "paperw", "paperw", 12240));
        vector.addElement(NumericAttribute.NewTwips(n5, "paperh", "paperh", 15840));
        vector.addElement(NumericAttribute.NewTwips(n5, "margl", "margl", 1800));
        vector.addElement(NumericAttribute.NewTwips(n5, "margr", "margr", 1800));
        vector.addElement(NumericAttribute.NewTwips(n5, "margt", "margt", 1440));
        vector.addElement(NumericAttribute.NewTwips(n5, "margb", "margb", 1440));
        vector.addElement(NumericAttribute.NewTwips(n5, "gutter", "gutter", 0));
        vector.addElement(new AssertiveAttribute(n3, (Object)"widowctrl", "nowidctlpar", bl3));
        vector.addElement(new AssertiveAttribute(n3, (Object)"widowctrl", "widctlpar", bl2));
        vector.addElement(new AssertiveAttribute(n5, (Object)"widowctrl", "widowctrl", bl2));
        Object[] objectArray = new RTFAttribute[vector.size()];
        vector.copyInto(objectArray);
        attributes = objectArray;
    }

    static class NumericAttribute
    extends GenericAttribute
    implements RTFAttribute {
        int rtfDefault;
        Number swingDefault;
        float scale;

        protected NumericAttribute(int n2, Object object, String string) {
            super(n2, object, string);
            this.rtfDefault = 0;
            this.swingDefault = null;
            this.scale = 1.0f;
        }

        public NumericAttribute(int n2, Object object, String string, int n3, int n4) {
            this(n2, object, string, new Integer(n3), n4, 1.0f);
        }

        public NumericAttribute(int n2, Object object, String string, Number number, int n3, float f2) {
            super(n2, object, string);
            this.swingDefault = number;
            this.rtfDefault = n3;
            this.scale = f2;
        }

        public static NumericAttribute NewTwips(int n2, Object object, String string, float f2, int n3) {
            return new NumericAttribute(n2, object, string, new Float(f2), n3, 20.0f);
        }

        public static NumericAttribute NewTwips(int n2, Object object, String string, int n3) {
            return new NumericAttribute(n2, object, string, null, n3, 20.0f);
        }

        public boolean set(MutableAttributeSet mutableAttributeSet) {
            return false;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet, int n2) {
            Number number = this.scale == 1.0f ? (Number)new Integer(n2) : (Number)new Float((float)n2 / this.scale);
            mutableAttributeSet.addAttribute(this.swingName, number);
            return true;
        }

        public boolean setDefault(MutableAttributeSet mutableAttributeSet) {
            Number number = (Number)mutableAttributeSet.getAttribute(this.swingName);
            if (number == null) {
                number = this.swingDefault;
            }
            if (number != null && (this.scale == 1.0f && number.intValue() == this.rtfDefault || Math.round(number.floatValue() * this.scale) == this.rtfDefault)) {
                return true;
            }
            this.set(mutableAttributeSet, this.rtfDefault);
            return true;
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl2) throws IOException {
            Number number = (Number)object;
            if (number == null) {
                number = this.swingDefault;
            }
            if (number == null) {
                return true;
            }
            int n2 = Math.round(number.floatValue() * this.scale);
            if (bl2 || n2 != this.rtfDefault) {
                rTFGenerator.writeControlWord(this.rtfName, n2);
            }
            return true;
        }
    }

    static class AssertiveAttribute
    extends GenericAttribute
    implements RTFAttribute {
        Object swingValue;

        public AssertiveAttribute(int n2, Object object, String string) {
            super(n2, object, string);
            this.swingValue = true;
        }

        public AssertiveAttribute(int n2, Object object, String string, Object object2) {
            super(n2, object, string);
            this.swingValue = object2;
        }

        public AssertiveAttribute(int n2, Object object, String string, int n3) {
            super(n2, object, string);
            this.swingValue = new Integer(n3);
        }

        public boolean set(MutableAttributeSet mutableAttributeSet) {
            if (this.swingValue == null) {
                mutableAttributeSet.removeAttribute(this.swingName);
            } else {
                mutableAttributeSet.addAttribute(this.swingName, this.swingValue);
            }
            return true;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet, int n2) {
            return false;
        }

        public boolean setDefault(MutableAttributeSet mutableAttributeSet) {
            mutableAttributeSet.removeAttribute(this.swingName);
            return true;
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl2) throws IOException {
            if (object == null) {
                return !bl2;
            }
            if (object.equals(this.swingValue)) {
                rTFGenerator.writeControlWord(this.rtfName);
                return true;
            }
            return !bl2;
        }
    }

    static class BooleanAttribute
    extends GenericAttribute
    implements RTFAttribute {
        boolean rtfDefault;
        boolean swingDefault;
        protected static final Boolean True = true;
        protected static final Boolean False = false;

        public BooleanAttribute(int n2, Object object, String string, boolean bl2, boolean bl3) {
            super(n2, object, string);
            this.swingDefault = bl2;
            this.rtfDefault = bl3;
        }

        public BooleanAttribute(int n2, Object object, String string) {
            super(n2, object, string);
            this.swingDefault = false;
            this.rtfDefault = false;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet) {
            mutableAttributeSet.addAttribute(this.swingName, True);
            return true;
        }

        public boolean set(MutableAttributeSet mutableAttributeSet, int n2) {
            Boolean bl2 = n2 != 0 ? True : False;
            mutableAttributeSet.addAttribute(this.swingName, bl2);
            return true;
        }

        public boolean setDefault(MutableAttributeSet mutableAttributeSet) {
            if (this.swingDefault != this.rtfDefault || mutableAttributeSet.getAttribute(this.swingName) != null) {
                mutableAttributeSet.addAttribute(this.swingName, this.rtfDefault);
            }
            return true;
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl2) throws IOException {
            Boolean bl3 = object == null ? Boolean.valueOf(this.swingDefault) : (Boolean)object;
            if (bl2 || bl3 != this.rtfDefault) {
                if (bl3.booleanValue()) {
                    rTFGenerator.writeControlWord(this.rtfName);
                } else {
                    rTFGenerator.writeControlWord(this.rtfName, 0);
                }
            }
            return true;
        }
    }

    static abstract class GenericAttribute {
        int domain;
        Object swingName;
        String rtfName;

        protected GenericAttribute(int n2, Object object, String string) {
            this.domain = n2;
            this.swingName = object;
            this.rtfName = string;
        }

        public int domain() {
            return this.domain;
        }

        public Object swingName() {
            return this.swingName;
        }

        public String rtfName() {
            return this.rtfName;
        }

        abstract boolean set(MutableAttributeSet var1);

        abstract boolean set(MutableAttributeSet var1, int var2);

        abstract boolean setDefault(MutableAttributeSet var1);

        public boolean write(AttributeSet attributeSet, RTFGenerator rTFGenerator, boolean bl2) throws IOException {
            return this.writeValue(attributeSet.getAttribute(this.swingName), rTFGenerator, bl2);
        }

        public boolean writeValue(Object object, RTFGenerator rTFGenerator, boolean bl2) throws IOException {
            return false;
        }
    }
}

