/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected MutableTreeNode parent = null;
    protected Vector children;
    protected transient Object userObject;
    protected boolean allowsChildren;

    public DefaultMutableTreeNode() {
        this(null);
    }

    public DefaultMutableTreeNode(Object object) {
        this(object, true);
    }

    public DefaultMutableTreeNode(Object object, boolean bl2) {
        this.allowsChildren = bl2;
        this.userObject = object;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n2) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
        if (mutableTreeNode2 != null) {
            mutableTreeNode2.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(mutableTreeNode, n2);
    }

    public void remove(int n2) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getChildAt(n2);
        this.children.removeElementAt(n2);
        mutableTreeNode.setParent(null);
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChildAt(int n2) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)this.children.elementAt(n2);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(treeNode)) {
            return -1;
        }
        return this.children.indexOf(treeNode);
    }

    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setAllowsChildren(boolean bl2) {
        if (bl2 != this.allowsChildren) {
            this.allowsChildren = bl2;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getParent();
        if (mutableTreeNode != null) {
            mutableTreeNode.remove(this);
        }
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(mutableTreeNode));
    }

    public void removeAllChildren() {
        int n2 = this.getChildCount() - 1;
        while (n2 >= 0) {
            this.remove(n2);
            --n2;
        }
    }

    public void add(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode != null && mutableTreeNode.getParent() == this) {
            this.insert(mutableTreeNode, this.getChildCount() - 1);
        } else {
            this.insert(mutableTreeNode, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        do {
            if (treeNode2 != treeNode) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        return defaultMutableTreeNode.isNodeAncestor(this);
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode;
        TreeNode treeNode2;
        int n2;
        if (defaultMutableTreeNode == this) {
            return this;
        }
        if (defaultMutableTreeNode == null) {
            return null;
        }
        int n3 = this.getLevel();
        int n4 = defaultMutableTreeNode.getLevel();
        if (n4 > n3) {
            n2 = n4 - n3;
            treeNode2 = defaultMutableTreeNode;
            treeNode = this;
        } else {
            n2 = n3 - n4;
            treeNode2 = this;
            treeNode = defaultMutableTreeNode;
        }
        while (n2 > 0) {
            treeNode2 = treeNode2.getParent();
            --n2;
        }
        do {
            if (treeNode2 == treeNode) {
                return treeNode2;
            }
            treeNode2 = treeNode2.getParent();
            treeNode = treeNode.getParent();
        } while (treeNode2 != null);
        if (treeNode2 != null || treeNode != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode != null && this.getRoot() == defaultMutableTreeNode.getRoot();
    }

    public int getDepth() {
        Object object = null;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
        }
        if (object == null) {
            throw new Error("nodes should be null");
        }
        return ((DefaultMutableTreeNode)object).getLevel() - this.getLevel();
    }

    public int getLevel() {
        int n2 = 0;
        TreeNode treeNode = this;
        while ((treeNode = treeNode.getParent()) != null) {
            ++n2;
        }
        return n2;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n2) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n2 == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n2];
        } else {
            treeNodeArray = this.getPathToRoot(treeNode.getParent(), ++n2);
            treeNodeArray[treeNodeArray.length - n2] = treeNode;
        }
        return treeNodeArray;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] treeNodeArray = this.getPath();
        Object[] objectArray = new Object[treeNodeArray.length];
        int n2 = 0;
        while (n2 < treeNodeArray.length) {
            objectArray[n2] = ((DefaultMutableTreeNode)treeNodeArray[n2]).getUserObject();
            ++n2;
        }
        return objectArray;
    }

    public TreeNode getRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreeNode treeNode = this;
        do {
            defaultMutableTreeNode = treeNode;
        } while ((treeNode = treeNode.getParent()) != null);
        return defaultMutableTreeNode;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public DefaultMutableTreeNode getNextNode() {
        if (this.getChildCount() == 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNextSibling();
            if (defaultMutableTreeNode == null) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.getParent();
                while (true) {
                    if (defaultMutableTreeNode2 == null) {
                        return null;
                    }
                    defaultMutableTreeNode = defaultMutableTreeNode2.getNextSibling();
                    if (defaultMutableTreeNode != null) {
                        return defaultMutableTreeNode;
                    }
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                }
            }
            return defaultMutableTreeNode;
        }
        return (DefaultMutableTreeNode)this.getChildAt(0);
    }

    public DefaultMutableTreeNode getPreviousNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getPreviousSibling();
        if (defaultMutableTreeNode2 != null) {
            if (defaultMutableTreeNode2.getChildCount() == 0) {
                return defaultMutableTreeNode2;
            }
            return defaultMutableTreeNode2.getLastLeaf();
        }
        return defaultMutableTreeNode;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode treeNode) {
        return new PathBetweenNodesEnumeration(treeNode, this);
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl2 = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl2;
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public TreeNode getChildAfter(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n2 = this.getIndex(treeNode);
        if (n2 == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (n2 < this.getChildCount() - 1) {
            return this.getChildAt(n2 + 1);
        }
        return null;
    }

    public TreeNode getChildBefore(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int n2 = this.getIndex(treeNode);
        if (n2 == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (n2 > 0) {
            return this.getChildAt(n2 - 1);
        }
        return null;
    }

    public boolean isNodeSibling(TreeNode treeNode) {
        boolean bl2;
        if (treeNode == null) {
            bl2 = false;
        } else if (treeNode == this) {
            bl2 = true;
        } else {
            TreeNode treeNode2 = this.getParent();
            boolean bl3 = bl2 = treeNode2 != null && treeNode2 == treeNode.getParent();
            if (bl2 && !((DefaultMutableTreeNode)this.getParent()).isNodeChild(treeNode)) {
                throw new Error("sibling has different parent");
            }
        }
        return bl2;
    }

    public int getSiblingCount() {
        TreeNode treeNode = this.getParent();
        if (treeNode == null) {
            return 1;
        }
        return treeNode.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode == null ? null : (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAfter(this);
        if (defaultMutableTreeNode2 != null && !this.isNodeSibling(defaultMutableTreeNode2)) {
            throw new Error("child of parent is not a sibling");
        }
        return defaultMutableTreeNode2;
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode == null ? null : (DefaultMutableTreeNode)defaultMutableTreeNode.getChildBefore(this);
        if (defaultMutableTreeNode2 != null && !this.isNodeSibling(defaultMutableTreeNode2)) {
            throw new Error("child of parent is not a sibling");
        }
        return defaultMutableTreeNode2;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this;
        while (!defaultMutableTreeNode.isLeaf()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = this;
        while (!defaultMutableTreeNode.isLeaf()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild();
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNextSibling();
        if (defaultMutableTreeNode2 != null) {
            return defaultMutableTreeNode2.getFirstLeaf();
        }
        return defaultMutableTreeNode.getNextLeaf();
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getPreviousSibling();
        if (defaultMutableTreeNode2 != null) {
            return defaultMutableTreeNode2.getLastLeaf();
        }
        return defaultMutableTreeNode.getPreviousLeaf();
    }

    public int getLeafCount() {
        int n2 = 0;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            if (!treeNode.isLeaf()) continue;
            ++n2;
        }
        if (n2 < 1) {
            throw new Error("tree has zero leaves");
        }
        return n2;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public Object clone() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        try {
            defaultMutableTreeNode = (DefaultMutableTreeNode)super.clone();
            defaultMutableTreeNode.children = null;
            defaultMutableTreeNode.parent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
        return defaultMutableTreeNode;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.userObject != null && this.userObject instanceof Serializable ? new Object[]{"userObject", this.userObject} : new Object[]{};
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length > 0 && objectArray[0].equals("userObject")) {
            this.userObject = objectArray[1];
        }
    }

    final class PathBetweenNodesEnumeration
    implements Enumeration {
        protected Stack stack;

        public PathBetweenNodesEnumeration(TreeNode treeNode, TreeNode treeNode2) {
            if (treeNode == null || treeNode2 == null) {
                throw new IllegalArgumentException("argument is null");
            }
            this.stack = new Stack();
            this.stack.push(treeNode2);
            TreeNode treeNode3 = treeNode2;
            while (treeNode3 != treeNode) {
                if ((treeNode3 = treeNode3.getParent()) == null && treeNode2 != treeNode) {
                    throw new IllegalArgumentException("node " + treeNode + " is not an ancestor of " + treeNode2);
                }
                this.stack.push(treeNode3);
            }
        }

        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        public Object nextElement() {
            try {
                return this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    final class BreadthFirstEnumeration
    implements Enumeration {
        protected Queue queue;

        public BreadthFirstEnumeration(TreeNode treeNode) {
            Vector vector = new Vector(1);
            vector.addElement(treeNode);
            this.queue = new Queue();
            this.queue.enqueue(vector.elements());
        }

        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumeration = (Enumeration)this.queue.firstObject();
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            Enumeration enumeration2 = treeNode.children();
            if (!enumeration.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (enumeration2.hasMoreElements()) {
                this.queue.enqueue(enumeration2);
            }
            return treeNode;
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object object) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(object, null);
                } else {
                    this.tail = this.tail.next = new QNode(object, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object object = this.head.object;
                QNode qNode = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    qNode.next = null;
                }
                return object;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode qNode) {
                    this.object = object;
                    this.next = qNode;
                }
            }
        }
    }

    final class PostorderEnumeration
    implements Enumeration {
        protected TreeNode root;
        protected Enumeration children;
        protected Enumeration subtree;

        public PostorderEnumeration(TreeNode treeNode) {
            this.root = treeNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        public boolean hasMoreElements() {
            return this.root != null;
        }

        public Object nextElement() {
            Object object;
            if (this.subtree.hasMoreElements()) {
                object = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration((TreeNode)this.children.nextElement());
                object = this.subtree.nextElement();
            } else {
                object = this.root;
                this.root = null;
            }
            return object;
        }
    }

    final class PreorderEnumeration
    implements Enumeration {
        protected Stack stack;

        public PreorderEnumeration(TreeNode treeNode) {
            Vector vector = new Vector(1);
            vector.addElement(treeNode);
            this.stack = new Stack();
            this.stack.push(vector.elements());
        }

        public boolean hasMoreElements() {
            return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumeration = (Enumeration)this.stack.peek();
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            Enumeration enumeration2 = treeNode.children();
            if (!enumeration.hasMoreElements()) {
                this.stack.pop();
            }
            if (enumeration2.hasMoreElements()) {
                this.stack.push(enumeration2);
            }
            return treeNode;
        }
    }
}

