/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultTreeModel
implements Serializable,
TreeModel {
    protected TreeNode root;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean asksAllowsChildren;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public DefaultTreeModel(TreeNode treeNode) {
        this(treeNode, false);
    }

    public DefaultTreeModel(TreeNode treeNode, boolean bl2) {
        this.root = treeNode;
        this.asksAllowsChildren = bl2;
    }

    public void setAsksAllowsChildren(boolean bl2) {
        this.asksAllowsChildren = bl2;
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setRoot(TreeNode treeNode) {
        TreeNode treeNode2 = this.root;
        this.root = treeNode;
        if (treeNode == null && treeNode2 != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(treeNode);
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    public Object getChild(Object object, int n2) {
        return ((TreeNode)object).getChildAt(n2);
    }

    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    public boolean isLeaf(Object object) {
        if (this.asksAllowsChildren) {
            return !((TreeNode)object).getAllowsChildren();
        }
        return ((TreeNode)object).isLeaf();
    }

    public void reload() {
        this.reload(this.root);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
        mutableTreeNode.setUserObject(object);
        this.nodeChanged(mutableTreeNode);
    }

    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n2) {
        mutableTreeNode2.insert(mutableTreeNode, n2);
        int[] nArray = new int[]{n2};
        this.nodesWereInserted(mutableTreeNode2, nArray);
    }

    public void removeNodeFromParent(MutableTreeNode mutableTreeNode) {
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
        if (mutableTreeNode2 == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        nArray[0] = mutableTreeNode2.getIndex(mutableTreeNode);
        mutableTreeNode2.remove(nArray[0]);
        objectArray[0] = mutableTreeNode;
        this.nodesWereRemoved(mutableTreeNode2, nArray, objectArray);
    }

    public void nodeChanged(TreeNode treeNode) {
        if (this.listenerList != null && treeNode != null) {
            TreeNode treeNode2 = treeNode.getParent();
            if (treeNode2 != null) {
                int n2 = treeNode2.getIndex(treeNode);
                if (n2 != -1) {
                    int[] nArray = new int[]{n2};
                    this.nodesChanged(treeNode2, nArray);
                }
            } else if (treeNode == this.getRoot()) {
                this.nodesChanged(treeNode, null);
            }
        }
    }

    public void reload(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    public void nodesWereInserted(TreeNode treeNode, int[] nArray) {
        if (this.listenerList != null && treeNode != null && nArray != null && nArray.length > 0) {
            int n2 = nArray.length;
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = treeNode.getChildAt(nArray[n3]);
                ++n3;
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(treeNode), nArray, objectArray);
        }
    }

    public void nodesWereRemoved(TreeNode treeNode, int[] nArray, Object[] objectArray) {
        if (treeNode != null && nArray != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(treeNode), nArray, objectArray);
        }
    }

    public void nodesChanged(TreeNode treeNode, int[] nArray) {
        if (treeNode != null) {
            if (nArray != null) {
                int n2 = nArray.length;
                if (n2 > 0) {
                    Object[] objectArray = new Object[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        objectArray[n3] = treeNode.getChildAt(nArray[n3]);
                        ++n3;
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
                }
            } else if (treeNode == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    public TreeNode[] getPathToRoot(TreeNode treeNode) {
        return this.getPathToRoot(treeNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n2) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n2 == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n2];
        } else {
            treeNodeArray = treeNode == this.root ? new TreeNode[n2] : this.getPathToRoot(treeNode.getParent(), ++n2);
            treeNodeArray[treeNodeArray.length - n2] = treeNode;
        }
        return treeNodeArray;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = DefaultTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = DefaultTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = DefaultTreeModel.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n2 = objectArray3.length - 2;
        while (n2 >= 0) {
            if (objectArray3[n2] == (class$javax$swing$event$TreeModelListener == null ? DefaultTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[n2 + 1]).treeNodesChanged(treeModelEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n2 = objectArray3.length - 2;
        while (n2 >= 0) {
            if (objectArray3[n2] == (class$javax$swing$event$TreeModelListener == null ? DefaultTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[n2 + 1]).treeNodesInserted(treeModelEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n2 = objectArray3.length - 2;
        while (n2 >= 0) {
            if (objectArray3[n2] == (class$javax$swing$event$TreeModelListener == null ? DefaultTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[n2 + 1]).treeNodesRemoved(treeModelEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n2 = objectArray3.length - 2;
        while (n2 >= 0) {
            if (objectArray3[n2] == (class$javax$swing$event$TreeModelListener == null ? DefaultTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[n2 + 1]).treeStructureChanged(treeModelEvent);
            }
            n2 -= 2;
        }
    }

    private void fireTreeStructureChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$TreeModelListener == null ? DefaultTreeModel.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, treePath);
                }
                ((TreeModelListener)objectArray[n2 + 1]).treeStructureChanged(treeModelEvent);
            }
            n2 -= 2;
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.root != null && this.root instanceof Serializable) {
            vector.addElement("root");
            vector.addElement(this.root);
        }
        objectOutputStream.writeObject(vector);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n2 = 0;
        int n3 = vector.size();
        if (n2 < n3 && vector.elementAt(n2).equals("root")) {
            this.root = (TreeNode)vector.elementAt(++n2);
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

