/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NSInfo;
import org.apache.xml.utils.StringBufferPool;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMHelper {
    Hashtable m_NSInfos = new Hashtable();
    protected static final NSInfo m_NSInfoUnProcWithXMLNS = new NSInfo(false, true);
    protected static final NSInfo m_NSInfoUnProcWithoutXMLNS = new NSInfo(false, false);
    protected static final NSInfo m_NSInfoUnProcNoAncestorXMLNS = new NSInfo(false, false, 2);
    protected static final NSInfo m_NSInfoNullWithXMLNS = new NSInfo(true, true);
    protected static final NSInfo m_NSInfoNullWithoutXMLNS = new NSInfo(true, false);
    protected static final NSInfo m_NSInfoNullNoAncestorXMLNS = new NSInfo(true, false, 2);
    protected Vector m_candidateNoAncestorXMLNS = new Vector();
    protected Document m_DOMFactory = null;

    public static Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(54, null));
        }
    }

    public boolean shouldStripSourceNode(Node node) throws TransformerException {
        return false;
    }

    public String getUniqueID(Node node) {
        return "N" + Integer.toHexString(node.hashCode()).toUpperCase();
    }

    public static boolean isNodeAfter(Node node, Node node2) {
        Node node3;
        if (node == node2) {
            return true;
        }
        boolean bl2 = true;
        Node node4 = DOMHelper.getParentOfNode(node);
        if (node4 == (node3 = DOMHelper.getParentOfNode(node2))) {
            if (null != node4) {
                bl2 = DOMHelper.isNodeAfterSibling(node4, node, node2);
            }
        } else {
            int n2;
            int n3;
            int n4 = 2;
            int n5 = 2;
            while (node4 != null) {
                ++n4;
                node4 = DOMHelper.getParentOfNode(node4);
            }
            while (node3 != null) {
                ++n5;
                node3 = DOMHelper.getParentOfNode(node3);
            }
            Node node5 = node;
            Node node6 = node2;
            if (n4 < n5) {
                n3 = n5 - n4;
                n2 = 0;
                while (n2 < n3) {
                    node6 = DOMHelper.getParentOfNode(node6);
                    ++n2;
                }
            } else if (n4 > n5) {
                n3 = n4 - n5;
                n2 = 0;
                while (n2 < n3) {
                    node5 = DOMHelper.getParentOfNode(node5);
                    ++n2;
                }
            }
            Node node7 = null;
            Node node8 = null;
            while (null != node5) {
                if (node5 == node6) {
                    if (null == node7) {
                        bl2 = n4 < n5;
                        break;
                    }
                    bl2 = DOMHelper.isNodeAfterSibling(node5, node7, node8);
                    break;
                }
                node7 = node5;
                node5 = DOMHelper.getParentOfNode(node5);
                node8 = node6;
                node6 = DOMHelper.getParentOfNode(node6);
            }
        }
        return bl2;
    }

    private static boolean isNodeAfterSibling(Node node, Node node2, Node node3) {
        boolean bl2 = false;
        short s2 = node2.getNodeType();
        short s3 = node3.getNodeType();
        if (2 != s2 && 2 == s3) {
            bl2 = false;
        } else if (2 == s2 && 2 != s3) {
            bl2 = true;
        } else if (2 == s2) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n2 = namedNodeMap.getLength();
            boolean bl3 = false;
            boolean bl4 = false;
            int n3 = 0;
            while (n3 < n2) {
                Node node4 = namedNodeMap.item(n3);
                if (node2 == node4) {
                    if (bl4) {
                        bl2 = false;
                        break;
                    }
                    bl3 = true;
                } else if (node3 == node4) {
                    if (bl3) {
                        bl2 = true;
                        break;
                    }
                    bl4 = true;
                }
                ++n3;
            }
        } else {
            Node node5 = node.getFirstChild();
            boolean bl5 = false;
            boolean bl6 = false;
            while (null != node5) {
                if (node2 == node5) {
                    if (bl6) {
                        bl2 = false;
                        break;
                    }
                    bl5 = true;
                } else if (node3 == node5) {
                    if (bl5) {
                        bl2 = true;
                        break;
                    }
                    bl6 = true;
                }
                node5 = node5.getNextSibling();
            }
        }
        return bl2;
    }

    public short getLevel(Node node) {
        short s2 = 1;
        while (null != (node = DOMHelper.getParentOfNode(node))) {
            s2 = (short)(s2 + 1);
        }
        return s2;
    }

    public String getNamespaceForPrefix(String string, Element element) {
        Node node = element;
        String string2 = null;
        if (string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else if (string.equals("xmlns")) {
            string2 = "http://www.w3.org/2000/xmlns/";
        } else {
            short s2;
            String string3 = string == "" ? "xmlns" : "xmlns:" + string;
            while (null != node && null == string2 && ((s2 = node.getNodeType()) == 1 || s2 == 5)) {
                Attr attr;
                if (s2 == 1 && (attr = node.getAttributeNode(string3)) != null) {
                    string2 = attr.getNodeValue();
                    break;
                }
                node = DOMHelper.getParentOfNode(node);
            }
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNamespaceOfNode(Node node) {
        String string;
        boolean bl2;
        NSInfo nSInfo;
        Object object;
        short s2 = node.getNodeType();
        if (2 != s2) {
            object = this.m_NSInfos.get(node);
            nSInfo = object == null ? null : (NSInfo)object;
            bl2 = nSInfo == null ? false : nSInfo.m_hasProcessedNS;
        } else {
            bl2 = false;
            nSInfo = null;
        }
        if (bl2) {
            return nSInfo.m_namespace;
        }
        String string2 = null;
        object = node.getNodeName();
        int n2 = ((String)object).indexOf(58);
        if (2 == s2) {
            if (n2 <= 0) return string2;
            string = ((String)object).substring(0, n2);
        } else {
            string = n2 >= 0 ? ((String)object).substring(0, n2) : "";
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (string.equals("xml")) {
            string2 = "http://www.w3.org/XML/1998/namespace";
        } else {
            Node node2 = node;
            while (null != node2 && null == string2) {
                if (null != nSInfo) {
                    if (nSInfo.m_ancestorHasXMLNSAttrs == 2) break;
                }
                short s3 = node2.getNodeType();
                if (null == nSInfo || nSInfo.m_hasXMLNSAttrs) {
                    boolean bl5 = false;
                    if (s3 == 1) {
                        NamedNodeMap namedNodeMap = node2.getAttributes();
                        int n3 = 0;
                        while (n3 < namedNodeMap.getLength()) {
                            Node node3 = namedNodeMap.item(n3);
                            String string3 = node3.getNodeName();
                            if (string3.charAt(0) == 'x') {
                                boolean bl6 = string3.startsWith("xmlns:");
                                if (string3.equals("xmlns") || bl6) {
                                    String string4;
                                    if (node == node2) {
                                        bl4 = true;
                                    }
                                    bl5 = true;
                                    bl3 = true;
                                    String string5 = string4 = bl6 ? string3.substring(6) : "";
                                    if (string4.equals(string)) {
                                        string2 = node3.getNodeValue();
                                        break;
                                    }
                                }
                            }
                            ++n3;
                        }
                    }
                    if (2 != s3 && null == nSInfo && node != node2) {
                        nSInfo = bl5 ? m_NSInfoUnProcWithXMLNS : m_NSInfoUnProcWithoutXMLNS;
                        this.m_NSInfos.put(node2, nSInfo);
                    }
                }
                if (2 == s3) {
                    node2 = DOMHelper.getParentOfNode(node2);
                } else {
                    this.m_candidateNoAncestorXMLNS.addElement(node2);
                    this.m_candidateNoAncestorXMLNS.addElement(nSInfo);
                    node2 = node2.getParentNode();
                }
                if (null == node2) continue;
                Object object2 = this.m_NSInfos.get(node2);
                NSInfo nSInfo2 = nSInfo = object2 == null ? null : (NSInfo)object2;
            }
            int n4 = this.m_candidateNoAncestorXMLNS.size();
            if (n4 > 0) {
                if (!bl3 && null == node2) {
                    int n5 = 0;
                    while (n5 < n4) {
                        Object object3 = this.m_candidateNoAncestorXMLNS.elementAt(n5 + 1);
                        if (object3 == m_NSInfoUnProcWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(n5), m_NSInfoUnProcNoAncestorXMLNS);
                        } else if (object3 == m_NSInfoNullWithoutXMLNS) {
                            this.m_NSInfos.put(this.m_candidateNoAncestorXMLNS.elementAt(n5), m_NSInfoNullNoAncestorXMLNS);
                        }
                        n5 += 2;
                    }
                }
                this.m_candidateNoAncestorXMLNS.removeAllElements();
            }
        }
        if (2 == s2) return string2;
        if (null == string2) {
            if (bl3) {
                if (bl4) {
                    this.m_NSInfos.put(node, m_NSInfoNullWithXMLNS);
                    return string2;
                } else {
                    this.m_NSInfos.put(node, m_NSInfoNullWithoutXMLNS);
                }
                return string2;
            } else {
                this.m_NSInfos.put(node, m_NSInfoNullNoAncestorXMLNS);
            }
            return string2;
        } else {
            this.m_NSInfos.put(node, new NSInfo(string2, bl4));
        }
        return string2;
    }

    public String getLocalNameOfNode(Node node) {
        String string = node.getNodeName();
        int n2 = string.indexOf(58);
        return n2 < 0 ? string : string.substring(n2 + 1);
    }

    public String getExpandedElementName(Element element) {
        String string = this.getNamespaceOfNode(element);
        return null != string ? string + ":" + this.getLocalNameOfNode(element) : this.getLocalNameOfNode(element);
    }

    public String getExpandedAttributeName(Attr attr) {
        String string = this.getNamespaceOfNode(attr);
        return null != string ? string + ":" + this.getLocalNameOfNode(attr) : this.getLocalNameOfNode(attr);
    }

    public boolean isIgnorableWhitespace(Text text) {
        boolean bl2 = false;
        return bl2;
    }

    public Node getRoot(Node node) {
        Node node2 = null;
        while (node != null) {
            node2 = node;
            node = DOMHelper.getParentOfNode(node);
        }
        return node2;
    }

    public Node getRootNode(Node node) {
        short s2 = node.getNodeType();
        return 9 == s2 || 11 == s2 ? node : node.getOwnerDocument();
    }

    public boolean isNamespaceNode(Node node) {
        if (2 == node.getNodeType()) {
            String string = node.getNodeName();
            return string.startsWith("xmlns:") || string.equals("xmlns");
        }
        return false;
    }

    public static Node getParentOfNode(Node node) throws RuntimeException {
        Node node2;
        short s2 = node.getNodeType();
        if (2 == s2) {
            Document document = node.getOwnerDocument();
            DOMImplementation dOMImplementation = document.getImplementation();
            if (dOMImplementation != null && dOMImplementation.hasFeature("Core", "2.0")) {
                Element element = ((Attr)node).getOwnerElement();
                return element;
            }
            Element element = document.getDocumentElement();
            if (null == element) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(56, null));
            }
            node2 = DOMHelper.locateAttrParent(element, node);
        } else {
            node2 = node.getParentNode();
        }
        return node2;
    }

    public Element getElementByID(String string, Document document) {
        return null;
    }

    public String getUnparsedEntityURI(String string, Document document) {
        String string2 = "";
        DocumentType documentType = document.getDoctype();
        if (null != documentType) {
            NamedNodeMap namedNodeMap = documentType.getEntities();
            if (null == namedNodeMap) {
                return string2;
            }
            Entity entity = (Entity)namedNodeMap.getNamedItem(string);
            if (null == entity) {
                return string2;
            }
            String string3 = entity.getNotationName();
            if (null != string3 && null == (string2 = entity.getSystemId())) {
                string2 = entity.getPublicId();
            }
        }
        return string2;
    }

    private static Node locateAttrParent(Element element, Node node) {
        Node node2 = null;
        Attr attr = element.getAttributeNode(node.getNodeName());
        if (attr == node) {
            node2 = element;
        }
        if (null == node2) {
            Node node3 = element.getFirstChild();
            while (null != node3) {
                if (1 == node3.getNodeType() && null != (node2 = DOMHelper.locateAttrParent((Element)node3, node))) break;
                node3 = node3.getNextSibling();
            }
        }
        return node2;
    }

    public void setDOMFactory(Document document) {
        this.m_DOMFactory = document;
    }

    public Document getDOMFactory() {
        if (null == this.m_DOMFactory) {
            this.m_DOMFactory = DOMHelper.createDocument();
        }
        return this.m_DOMFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNodeData(Node node) {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            DOMHelper.getNodeData(node, fastStringBuffer);
            string = fastStringBuffer.length() > 0 ? fastStringBuffer.toString() : "";
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StringBufferPool.free(fastStringBuffer);
            throw throwable;
        }
        StringBufferPool.free(fastStringBuffer);
        return string;
    }

    public static void getNodeData(Node node, FastStringBuffer fastStringBuffer) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                Node node2 = node.getFirstChild();
                while (null != node2) {
                    DOMHelper.getNodeData(node2, fastStringBuffer);
                    node2 = node2.getNextSibling();
                }
                break;
            }
            case 3: 
            case 4: {
                fastStringBuffer.append(node.getNodeValue());
                break;
            }
            case 2: {
                fastStringBuffer.append(node.getNodeValue());
                break;
            }
            case 7: {
                break;
            }
        }
    }
}

