/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.BufferCapabilities;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11SurfaceData;
import sun.awt.motif.X11OffScreenImage;
import sun.awt.motif.X11RemoteOffScreenImage;
import sun.awt.motif.X11VolatileImage;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;

public class X11GraphicsConfig
extends GraphicsConfiguration {
    X11GraphicsDevice screen;
    int visual;
    ColorModel colorModel;
    long aData;
    boolean doubleBuffer;
    private BufferCapabilities bufferCaps;
    private static ImageCapabilities imageCaps = new ImageCapabilities(true);
    private int bitsPerPixel;
    private SurfaceType surfaceType;
    public RenderLoops solidloops;

    public static X11GraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n2, boolean bl2) {
        return new X11GraphicsConfig(x11GraphicsDevice, n2, bl2);
    }

    public static X11GraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n2, int n3) {
        return new X11GraphicsConfig(x11GraphicsDevice, n2, false);
    }

    private native int getNumColors();

    private native void init(int var1, int var2);

    private native ColorModel makeColorModel();

    private X11GraphicsConfig(X11GraphicsDevice x11GraphicsDevice, int n2, boolean bl2) {
        this.screen = x11GraphicsDevice;
        this.visual = n2;
        this.doubleBuffer = bl2;
        this.init(n2, this.screen.getScreen());
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public synchronized SurfaceType getSurfaceType() {
        if (this.surfaceType != null) {
            return this.surfaceType;
        }
        this.surfaceType = X11SurfaceData.getSurfaceType(this, false);
        return this.surfaceType;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
        }
        return this.solidloops;
    }

    public BufferedImage createCompatibleImage(int n2, int n3) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        if (X11SurfaceData.isAccelerationEnabled()) {
            return new X11RemoteOffScreenImage(null, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
        }
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public VolatileImage createCompatibleVolatileImage(int n2, int n3) {
        return new X11VolatileImage(this, n2, n3);
    }

    public BufferedImage createCompatibleImage(int n2, int n3, int n4) {
        switch (n4) {
            case 1: {
                return this.createCompatibleImage(n2, n3);
            }
            case 2: {
                if (X11SurfaceData.isAccelerationEnabled()) {
                    ColorModel colorModel = this.getColorModel(n4);
                    WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
                    return new X11OffScreenImage(null, colorModel, writableRaster, colorModel.isAlphaPremultiplied(), true);
                }
            }
            case 3: {
                ColorModel colorModel = this.getColorModel(n4);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n4);
    }

    public synchronized ColorModel getColorModel() {
        if (this.colorModel == null) {
            SystemColor.window.getRGB();
            this.colorModel = this.makeColorModel();
            if (this.colorModel == null) {
                this.colorModel = Toolkit.getDefaultToolkit().getColorModel();
            }
        }
        return this.colorModel;
    }

    public ColorModel getColorModel(int n2) {
        if (n2 == 1) {
            return this.getColorModel();
        }
        if (n2 == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (n2 == 3) {
            return ColorModel.getRGBdefault();
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d2 = this.getXResolution(this.screen.getScreen()) / 72.0;
        double d3 = this.getYResolution(this.screen.getScreen()) / 72.0;
        return new AffineTransform(d2, 0.0, 0.0, d3, 0.0, 0.0);
    }

    private native double getXResolution(int var1);

    private native double getYResolution(int var1);

    public String toString() {
        return "X11GraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    private static native void initIDs();

    public Rectangle getBounds() {
        return this.pGetBounds(this.screen.getScreen());
    }

    public native Rectangle pGetBounds(int var1);

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = this.doubleBuffer ? new XDBECapabilities() : super.getBufferCapabilities();
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    static {
        X11GraphicsConfig.initIDs();
    }

    private static class XDBECapabilities
    extends BufferCapabilities {
        public XDBECapabilities() {
            super(imageCaps, imageCaps, BufferCapabilities.FlipContents.UNDEFINED);
        }
    }
}

