/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;

class ISO_8859_1
extends Charset
implements HistoricallyNamedCharset {
    static /* synthetic */ Class class$sun$nio$cs$ISO_8859_1;

    public ISO_8859_1() {
        super("ISO-8859-1", StandardCharsets.aliasesFor("ISO-8859-1"));
    }

    public String historicalName() {
        return "ISO8859_1";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Encoder
    extends CharsetEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        static final /* synthetic */ boolean $assertionsDisabled;

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public boolean canEncode(char c2) {
            return c2 <= '\u00ff';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.position();
            int n3 = charBuffer.arrayOffset() + charBuffer.limit();
            if (!$assertionsDisabled && n2 > n3) {
                throw new AssertionError();
            }
            byte[] byArray = byteBuffer.array();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw new AssertionError();
            }
            n4 = n4 <= n5 ? n4 : n5;
            try {
                for (n2 = n2 <= n3 ? n2 : n3; n2 < n3; ++n2) {
                    char c2 = cArray[n2];
                    if (c2 <= '\u00ff') {
                        if (n4 >= n5) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n4++] = (byte)c2;
                        continue;
                    }
                    if (this.sgp.parse(c2, cArray, n2, n3) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2 - charBuffer.arrayOffset());
                byteBuffer.position(n4 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n2;
            block6: {
                CoderResult coderResult2;
                block9: {
                    CoderResult coderResult3;
                    block8: {
                        CoderResult coderResult4;
                        block7: {
                            n2 = charBuffer.position();
                            try {
                                char c2;
                                while (true) {
                                    if (!charBuffer.hasRemaining()) {
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block6;
                                    }
                                    c2 = charBuffer.get();
                                    if (c2 > '\u00ff') break;
                                    if (!byteBuffer.hasRemaining()) {
                                        coderResult4 = CoderResult.OVERFLOW;
                                        Object var8_8 = null;
                                        break block7;
                                    }
                                    byteBuffer.put((byte)c2);
                                    ++n2;
                                }
                                if (this.sgp.parse(c2, charBuffer) < 0) {
                                    coderResult3 = this.sgp.error();
                                    break block8;
                                }
                                coderResult2 = this.sgp.unmappableResult();
                                break block9;
                            }
                            catch (Throwable throwable) {
                                Object var8_12 = null;
                                charBuffer.position(n2);
                                throw throwable;
                            }
                        }
                        charBuffer.position(n2);
                        return coderResult4;
                    }
                    Object var8_9 = null;
                    charBuffer.position(n2);
                    return coderResult3;
                }
                Object var8_10 = null;
                charBuffer.position(n2);
                return coderResult2;
            }
            Object var8_11 = null;
            charBuffer.position(n2);
            return coderResult;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ISO_8859_1 == null ? (class$sun$nio$cs$ISO_8859_1 = ISO_8859_1.class$("sun.nio.cs.ISO_8859_1")) : class$sun$nio$cs$ISO_8859_1).desiredAssertionStatus();
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
            if (!$assertionsDisabled && n2 > n3) {
                throw new AssertionError();
            }
            n2 = n2 <= n3 ? n2 : n3;
            char[] cArray = charBuffer.array();
            int n4 = charBuffer.arrayOffset() + charBuffer.position();
            int n5 = charBuffer.arrayOffset() + charBuffer.limit();
            if (!$assertionsDisabled && n4 > n5) {
                throw new AssertionError();
            }
            n4 = n4 <= n5 ? n4 : n5;
            try {
                while (n2 < n3) {
                    byte by = byArray[n2];
                    if (n4 >= n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n4++] = (char)(by & 0xFF);
                    ++n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                charBuffer.position(n4 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n2;
            block5: {
                CoderResult coderResult2;
                n2 = byteBuffer.position();
                try {
                    while (true) {
                        if (!byteBuffer.hasRemaining()) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block5;
                        }
                        byte by = byteBuffer.get();
                        if (!charBuffer.hasRemaining()) {
                            coderResult2 = CoderResult.OVERFLOW;
                            Object var7_7 = null;
                            break;
                        }
                        charBuffer.put((char)(by & 0xFF));
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    byteBuffer.position(n2);
                    throw throwable;
                }
                byteBuffer.position(n2);
                return coderResult2;
            }
            Object var7_8 = null;
            byteBuffer.position(n2);
            return coderResult;
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ISO_8859_1 == null ? (class$sun$nio$cs$ISO_8859_1 = ISO_8859_1.class$("sun.nio.cs.ISO_8859_1")) : class$sun$nio$cs$ISO_8859_1).desiredAssertionStatus();
        }
    }
}

