/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPEndpoint
implements Endpoint {
    private String host;
    private int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private TCPTransport transport = null;
    private static String localHost;
    private static boolean localHostKnown;
    private static final Map localEndpoints;
    private static final int FORMAT_HOST_PORT = 0;
    private static final int FORMAT_HOST_PORT_FACTORY = 1;

    private static int getInt(String string, int n2) {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n2));
    }

    private static boolean getBoolean(String string) {
        return (Boolean)AccessController.doPrivileged(new GetBooleanAction(string));
    }

    private static String getHostnameProperty() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.hostname"));
    }

    public TCPEndpoint(String string, int n2) {
        this(string, n2, null, null);
    }

    public TCPEndpoint(String string, int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        if (string == null) {
            string = "";
        }
        this.host = string;
        this.port = n2;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
    }

    public static TCPEndpoint getLocalEndpoint(int n2) {
        return TCPEndpoint.getLocalEndpoint(n2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCPEndpoint getLocalEndpoint(int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        TCPEndpoint tCPEndpoint = null;
        Map map = localEndpoints;
        synchronized (map) {
            TCPEndpoint tCPEndpoint2 = new TCPEndpoint(null, n2, rMIClientSocketFactory, rMIServerSocketFactory);
            LinkedList linkedList = (LinkedList)localEndpoints.get(tCPEndpoint2);
            String string = TCPEndpoint.resampleLocalHost();
            if (linkedList == null) {
                tCPEndpoint = new TCPEndpoint(string, n2, rMIClientSocketFactory, rMIServerSocketFactory);
                linkedList = new LinkedList();
                linkedList.add(tCPEndpoint);
                tCPEndpoint.transport = new TCPTransport(linkedList);
                localEndpoints.put(tCPEndpoint2, linkedList);
                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "created local endpoint for socket factory " + rMIServerSocketFactory + " on port " + n2);
                }
            } else {
                LinkedList linkedList2 = linkedList;
                synchronized (linkedList2) {
                    tCPEndpoint = (TCPEndpoint)linkedList.getLast();
                    String string2 = tCPEndpoint.host;
                    int n3 = tCPEndpoint.port;
                    TCPTransport tCPTransport = tCPEndpoint.transport;
                    if (string != null && !string.equals(string2)) {
                        if (n3 != 0) {
                            linkedList.clear();
                        }
                        tCPEndpoint = new TCPEndpoint(string, n3, rMIClientSocketFactory, rMIServerSocketFactory);
                        tCPEndpoint.transport = tCPTransport;
                        linkedList.add(tCPEndpoint);
                    }
                }
            }
        }
        return tCPEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resampleLocalHost() {
        String string = TCPEndpoint.getHostnameProperty();
        Map map = localEndpoints;
        synchronized (map) {
            if (string != null) {
                if (!localHostKnown) {
                    TCPEndpoint.setLocalHost(string);
                } else if (!string.equals(localHost)) {
                    localHost = string;
                    if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                        TCPTransport.tcpLog.log(Log.BRIEF, "updated local hostname to: " + localHost);
                    }
                }
            }
            return localHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setLocalHost(String string) {
        Map map = localEndpoints;
        synchronized (map) {
            if (!localHostKnown) {
                localHost = string;
                localHostKnown = true;
                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "local host set to " + string);
                }
                Collection collection = localEndpoints.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    LinkedList linkedList;
                    LinkedList linkedList2 = linkedList = (LinkedList)iterator.next();
                    synchronized (linkedList2) {
                        Iterator iterator2 = linkedList.iterator();
                        while (iterator2.hasNext()) {
                            TCPEndpoint tCPEndpoint = (TCPEndpoint)iterator2.next();
                            tCPEndpoint.host = string;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultPort(int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        TCPEndpoint tCPEndpoint = new TCPEndpoint(null, 0, rMIClientSocketFactory, rMIServerSocketFactory);
        Map map = localEndpoints;
        synchronized (map) {
            LinkedList linkedList;
            LinkedList linkedList2 = linkedList = (LinkedList)localEndpoints.get(tCPEndpoint);
            synchronized (linkedList2) {
                int n3 = linkedList.size();
                TCPEndpoint tCPEndpoint2 = (TCPEndpoint)linkedList.getLast();
                if (tCPEndpoint2.port != 0) {
                    return;
                }
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    TCPEndpoint tCPEndpoint3 = (TCPEndpoint)iterator.next();
                    tCPEndpoint3.port = n2;
                }
                if (n3 > 1) {
                    linkedList.clear();
                    linkedList.add(tCPEndpoint2);
                }
            }
            TCPEndpoint tCPEndpoint4 = new TCPEndpoint(null, n2, rMIClientSocketFactory, rMIServerSocketFactory);
            localEndpoints.put(tCPEndpoint4, linkedList);
            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                TCPTransport.tcpLog.log(Log.BRIEF, "default port for server socket factory " + rMIServerSocketFactory + " and client socket factory " + rMIClientSocketFactory + " set to " + n2);
            }
        }
    }

    public Transport getOutboundTransport() {
        TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, this.csf, this.ssf);
        return tCPEndpoint.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection allKnownTransports() {
        HashSet hashSet;
        Map map = localEndpoints;
        synchronized (map) {
            hashSet = new HashSet(localEndpoints.size());
            Collection collection = localEndpoints.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                TCPEndpoint tCPEndpoint = (TCPEndpoint)linkedList.getFirst();
                hashSet.add(tCPEndpoint.transport);
            }
        }
        return hashSet;
    }

    public static void shedConnectionCaches() {
        Iterator iterator = TCPEndpoint.allKnownTransports().iterator();
        while (iterator.hasNext()) {
            ((TCPTransport)iterator.next()).shedConnectionCaches();
        }
    }

    public void exportObject(Target target) throws RemoteException {
        this.transport.exportObject(target);
    }

    public Channel getChannel() {
        return this.getOutboundTransport().getChannel(this);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return this.csf;
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.csf != null ? "," + this.csf : "") + "]";
    }

    public int hashCode() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TCPEndpoint) {
            TCPEndpoint tCPEndpoint = (TCPEndpoint)object;
            if (this.port != tCPEndpoint.port || !this.host.equals(tCPEndpoint.host)) {
                return false;
            }
            if (this.csf == null ^ tCPEndpoint.csf == null || this.ssf == null ^ tCPEndpoint.ssf == null) {
                return false;
            }
            if (!(this.csf == null || this.csf.getClass() == tCPEndpoint.csf.getClass() && this.csf.equals(tCPEndpoint.csf))) {
                return false;
            }
            return this.ssf == null || this.ssf.getClass() == tCPEndpoint.ssf.getClass() && this.ssf.equals(tCPEndpoint.ssf);
        }
        return false;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        if (this.csf == null) {
            objectOutput.writeByte(0);
            objectOutput.writeUTF(this.host);
            objectOutput.writeInt(this.port);
        } else {
            objectOutput.writeByte(1);
            objectOutput.writeUTF(this.host);
            objectOutput.writeInt(this.port);
            objectOutput.writeObject(this.csf);
        }
    }

    public static TCPEndpoint read(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        String string;
        RMIClientSocketFactory rMIClientSocketFactory = null;
        byte by = objectInput.readByte();
        switch (by) {
            case 0: {
                string = objectInput.readUTF();
                n2 = objectInput.readInt();
                break;
            }
            case 1: {
                string = objectInput.readUTF();
                n2 = objectInput.readInt();
                rMIClientSocketFactory = (RMIClientSocketFactory)objectInput.readObject();
                break;
            }
            default: {
                throw new IOException("invalid endpoint format");
            }
        }
        return new TCPEndpoint(string, n2, rMIClientSocketFactory, null);
    }

    public void writeHostPortFormat(DataOutput dataOutput) throws IOException {
        if (this.csf != null) {
            throw new InternalError("TCPEndpoint.writeHostPortFormat: called for endpoint with non-null socket factory");
        }
        dataOutput.writeUTF(this.host);
        dataOutput.writeInt(this.port);
    }

    public static TCPEndpoint readHostPortFormat(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        int n2 = dataInput.readInt();
        return new TCPEndpoint(string, n2);
    }

    private static RMISocketFactory chooseFactory() {
        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
        if (rMISocketFactory == null) {
            rMISocketFactory = TCPTransport.defaultSocketFactory;
        }
        return rMISocketFactory;
    }

    Socket newSocket() throws RemoteException {
        Socket socket;
        if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "opening socket to " + this);
        }
        try {
            RMIClientSocketFactory rMIClientSocketFactory = this.csf;
            if (rMIClientSocketFactory == null) {
                rMIClientSocketFactory = TCPEndpoint.chooseFactory();
            }
            socket = rMIClientSocketFactory.createSocket(this.host, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            throw new java.rmi.UnknownHostException("Unknown host: " + this.host, unknownHostException);
        }
        catch (ConnectException connectException) {
            throw new java.rmi.ConnectException("Connection refused to host: " + this.host, connectException);
        }
        catch (IOException iOException) {
            try {
                TCPEndpoint.shedConnectionCaches();
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ConnectIOException("Exception creating connection to: " + this.host, iOException);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (Exception exception) {}
        return socket;
    }

    ServerSocket newServerSocket() throws IOException {
        RMIServerSocketFactory rMIServerSocketFactory;
        if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
            TCPTransport.tcpLog.log(Log.VERBOSE, "creating server socket on " + this);
        }
        if ((rMIServerSocketFactory = this.ssf) == null) {
            rMIServerSocketFactory = TCPEndpoint.chooseFactory();
        }
        ServerSocket serverSocket = rMIServerSocketFactory.createServerSocket(this.port);
        if (this.port == 0) {
            TCPEndpoint.setDefaultPort(serverSocket.getLocalPort(), this.csf, this.ssf);
        }
        return serverSocket;
    }

    static {
        localHostKnown = true;
        localHost = TCPEndpoint.getHostnameProperty();
        if (localHost == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                byte[] byArray = inetAddress.getAddress();
                if (byArray[0] == 127 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 1) {
                    localHostKnown = false;
                }
                localHost = TCPEndpoint.getBoolean("java.rmi.server.useLocalHostName") ? FQDN.attemptFQDN(inetAddress) : inetAddress.getHostAddress();
            }
            catch (Exception exception) {
                localHostKnown = false;
                localHost = null;
            }
        }
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, "localHostKnown = " + localHostKnown + ", localHost = " + localHost);
        }
        localEndpoints = new HashMap(3);
    }

    private static class FQDN
    implements Runnable {
        private String reverseLookup;
        private String hostAddress;

        private FQDN(String string) {
            this.hostAddress = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String attemptFQDN(InetAddress inetAddress) throws UnknownHostException {
            String string = inetAddress.getHostName();
            if (string.indexOf(46) < 0) {
                String string2 = inetAddress.getHostAddress();
                FQDN fQDN = new FQDN(string2);
                int n2 = TCPEndpoint.getInt("sun.rmi.transport.tcp.localHostNameTimeOut", 10000);
                try {
                    FQDN fQDN2 = fQDN;
                    synchronized (fQDN2) {
                        fQDN.getFQDN();
                        fQDN.wait(n2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                string = fQDN.getHost();
                if (string == null || string.equals("") || string.indexOf(46) < 0) {
                    string = string2;
                }
            }
            return string;
        }

        private void getFQDN() {
            Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "FQDN Finder", true));
            thread.start();
        }

        private synchronized String getHost() {
            return this.reverseLookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string = null;
            try {
                string = InetAddress.getByName(this.hostAddress).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                FQDN fQDN = this;
                synchronized (fQDN) {
                    this.reverseLookup = string;
                    this.notify();
                }
            }
            finally {
                FQDN fQDN = this;
                synchronized (fQDN) {
                    this.reverseLookup = string;
                    this.notify();
                }
            }
        }
    }
}

