/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;

public class EUC_JP_LINUX
extends Charset
implements HistoricallyNamedCharset {
    static /* synthetic */ Class class$sun$nio$cs$ext$EUC_JP_LINUX;

    public EUC_JP_LINUX() {
        super("euc-jp-linux", ExtendedCharsets.aliasesFor("euc-jp-linux"));
    }

    public String historicalName() {
        return "EUC_JP_LINUX";
    }

    public boolean contains(Charset charset) {
        return charset instanceof JIS_X_0201 || charset.name().equals("US-ASCII") || charset instanceof JIS_X_0208 || charset instanceof EUC_JP_LINUX;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Encoder
    extends JIS_X_0208.Encoder {
        JIS_X_0201.Encoder encoderJ0201;
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        short[] jis0208Index1;
        String[] jis0208Index2;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            this.encoderJ0201 = new JIS_X_0201.Encoder(charset);
            this.jis0208Index1 = super.getIndex1();
            this.jis0208Index2 = super.getIndex2();
        }

        public boolean canEncode(char c) {
            byte[] byArray = new byte[2];
            return this.encodeSingle(c, byArray) != 0 || this.encodeDouble(c) != 0;
        }

        protected int encodeSingle(char c, byte[] byArray) {
            if (c == '\u0000') {
                byArray[0] = 0;
                return 1;
            }
            byte by = this.encoderJ0201.encode(c);
            if (by == 0) {
                return 0;
            }
            if (by > 0 && by < 128) {
                byArray[0] = by;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = by;
            return 2;
        }

        protected int encodeDouble(char c) {
            int n = this.jis0208Index1[(c & 0xFF00) >> 8] << 8;
            char c2 = this.jis0208Index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
            if (c2 != '\u0000') {
                return c2 + 32896;
            }
            return c2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            if (!$assertionsDisabled && n > n2) {
                throw new AssertionError();
            }
            n = n <= n2 ? n : n2;
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            boolean bl = false;
            byte[] byArray2 = new byte[2];
            try {
                while (n < n2) {
                    byte[] byArray3 = byArray2;
                    char c = cArray[n];
                    if (Surrogate.is(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    n5 = this.encodeSingle(c, byArray3);
                    if (n5 == 0) {
                        int n6 = this.encodeDouble(c);
                        if (n6 != 0 && (n6 & 0xFF0000) == 0) {
                            byArray3[0] = (byte)((n6 & 0xFF00) >> 8);
                            byArray3[1] = (byte)(n6 & 0xFF);
                            n5 = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n4 - n3 < n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    int n7 = 0;
                    while (n7 < n5) {
                        byArray[n3++] = byArray3[n7];
                        ++n7;
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block11: {
                CoderResult coderResult2;
                block14: {
                    CoderResult coderResult3;
                    block13: {
                        CoderResult coderResult4;
                        int n2 = 0;
                        boolean bl = false;
                        byte[] byArray = new byte[4];
                        n = charBuffer.position();
                        try {
                            block2: while (true) {
                                if (!charBuffer.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block11;
                                }
                                byte[] byArray2 = byArray;
                                char c = charBuffer.get();
                                if (Surrogate.is(c)) {
                                    if (this.sgp.parse(c, charBuffer) < 0) {
                                        CoderResult coderResult5 = this.sgp.error();
                                        Object var12_16 = null;
                                        charBuffer.position(n);
                                        return coderResult5;
                                    }
                                    coderResult4 = this.sgp.unmappableResult();
                                    break;
                                }
                                n2 = this.encodeSingle(c, byArray2);
                                if (n2 == 0) {
                                    int n3 = this.encodeDouble(c);
                                    if (n3 == 0) {
                                        coderResult3 = CoderResult.unmappableForLength(1);
                                        break block13;
                                    }
                                    if ((n3 & 0xFF0000) == 0) {
                                        byArray2[0] = (byte)((n3 & 0xFF00) >> 8);
                                        byArray2[1] = (byte)(n3 & 0xFF);
                                        n2 = 2;
                                    }
                                }
                                if (byteBuffer.remaining() < n2) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block14;
                                }
                                int n4 = 0;
                                while (true) {
                                    if (n4 >= n2) continue block2;
                                    byteBuffer.put(byArray2[n4]);
                                    ++n;
                                    ++n4;
                                }
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_21 = null;
                            charBuffer.position(n);
                            throw throwable;
                        }
                        Object var12_17 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var12_18 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var12_19 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var12_20 = null;
            charBuffer.position(n);
            return coderResult;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ext$EUC_JP_LINUX == null ? (class$sun$nio$cs$ext$EUC_JP_LINUX = EUC_JP_LINUX.class$("sun.nio.cs.ext.EUC_JP_LINUX")) : class$sun$nio$cs$ext$EUC_JP_LINUX).desiredAssertionStatus();
        }
    }

    private static class Decoder
    extends JIS_X_0208.Decoder {
        JIS_X_0201.Decoder decoderJ0201;
        short[] jis0208Index1;
        String[] jis0208Index2;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Decoder(Charset charset) {
            super(charset);
            this.decoderJ0201 = new JIS_X_0201.Decoder(charset);
            this.start = 161;
            this.end = 254;
            this.jis0208Index1 = super.getIndex1();
            this.jis0208Index2 = super.getIndex2();
        }

        protected char convSingleByte(int n) {
            if (n < 0 || n > 127) {
                return '\ufffd';
            }
            return this.decoderJ0201.decode(n);
        }

        protected char decodeDouble(int n, int n2) {
            if (n == 142) {
                return this.decoderJ0201.decode(n2 - 256);
            }
            if (n < 0 || n > this.jis0208Index1.length || n2 < this.start || n2 > this.end) {
                return '\ufffd';
            }
            int n3 = (this.jis0208Index1[n - 128] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
            return this.jis0208Index2[this.jis0208Index1[n - 128] >> 4].charAt(n3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            if (!$assertionsDisabled && n > n2) {
                throw new AssertionError();
            }
            n = n <= n2 ? n : n2;
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 65533;
            try {
                while (n < n2) {
                    n5 = byArray[n] & 0xFF;
                    n7 = 1;
                    if ((n5 & 0x80) == 0) {
                        n8 = (char)n5;
                    } else {
                        if ((n5 & 0xFF) == 143) {
                            if (n + 3 > n2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n += (n7 += 2);
                            CoderResult coderResult = CoderResult.unmappableForLength(n7);
                            return coderResult;
                        }
                        if (n + 2 > n2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n6 = byArray[n + 1] & 0xFF;
                        ++n7;
                        n8 = this.decodeDouble(n5, n6);
                    }
                    if (n8 == 65533) {
                        CoderResult coderResult = CoderResult.malformedForLength(n7);
                        return coderResult;
                    }
                    if (n3 + 1 > n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n8;
                    n += n7;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            block10: {
                CoderResult coderResult2;
                block13: {
                    CoderResult coderResult3;
                    block12: {
                        CoderResult coderResult4;
                        n = byteBuffer.position();
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        char c = '\ufffd';
                        try {
                            while (true) {
                                if (!byteBuffer.hasRemaining()) {
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block10;
                                }
                                n2 = byteBuffer.get() & 0xFF;
                                n4 = 1;
                                if ((n2 & 0x80) == 0) {
                                    c = (char)n2;
                                } else {
                                    if (byteBuffer.remaining() < 1) {
                                        CoderResult coderResult5 = CoderResult.UNDERFLOW;
                                        Object var11_12 = null;
                                        byteBuffer.position(n);
                                        return coderResult5;
                                    }
                                    if ((n2 & 0xFF) == 143) {
                                        n3 = byteBuffer.get() & 0xFF;
                                        coderResult4 = CoderResult.unmappableForLength(n4);
                                        break;
                                    }
                                    n3 = byteBuffer.get() & 0xFF;
                                    ++n4;
                                    c = this.decodeDouble(n2, n3);
                                }
                                if (c == '\ufffd') {
                                    coderResult3 = CoderResult.unmappableForLength(n4);
                                    break block12;
                                }
                                if (charBuffer.remaining() < 1) {
                                    coderResult2 = CoderResult.OVERFLOW;
                                    break block13;
                                }
                                charBuffer.put(c);
                                n += n4;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var11_17 = null;
                            byteBuffer.position(n);
                            throw throwable;
                        }
                        Object var11_13 = null;
                        byteBuffer.position(n += ++n4);
                        return coderResult4;
                    }
                    Object var11_14 = null;
                    byteBuffer.position(n);
                    return coderResult3;
                }
                Object var11_15 = null;
                byteBuffer.position(n);
                return coderResult2;
            }
            Object var11_16 = null;
            byteBuffer.position(n);
            return coderResult;
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$ext$EUC_JP_LINUX == null ? (class$sun$nio$cs$ext$EUC_JP_LINUX = EUC_JP_LINUX.class$("sun.nio.cs.ext.EUC_JP_LINUX")) : class$sun$nio$cs$ext$EUC_JP_LINUX).desiredAssertionStatus();
        }
    }
}

