/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class EncryptedPrivateKeyInfo {
    private AlgorithmId a;
    private byte[] b;
    private byte[] c = null;

    public EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("the encoded parameter must be non-null");
        }
        DerValue derValue = new DerValue(byArray);
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new IOException("overrun, bytes = " + derValue.data.available());
        }
        this.a = AlgorithmId.parse(derValueArray[0]);
        if (derValueArray[0].data.available() != 0) {
            throw new IOException("encryptionAlgorithm field overrun");
        }
        this.b = derValueArray[1].getOctetString();
        if (derValueArray[1].data.available() != 0) {
            throw new IOException("encryptedData field overrun");
        }
        this.c = (byte[])byArray.clone();
    }

    public EncryptedPrivateKeyInfo(String string, byte[] byArray) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException("the algName parameter must be non-null");
        }
        this.a = AlgorithmId.get(string);
        if (byArray == null) {
            throw new NullPointerException("the encryptedData parameter must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the encryptedData parameter must not be empty");
        }
        this.b = (byte[])byArray.clone();
        this.c = null;
    }

    public EncryptedPrivateKeyInfo(AlgorithmParameters algorithmParameters, byte[] byArray) throws NoSuchAlgorithmException {
        if (algorithmParameters == null) {
            throw new NullPointerException("algParams must be non-null");
        }
        this.a = AlgorithmId.get(algorithmParameters);
        if (byArray == null) {
            throw new NullPointerException("encryptedData must be non-null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("the encryptedData parameter must not be empty");
        }
        this.b = (byte[])byArray.clone();
        this.c = null;
    }

    public String getAlgName() {
        return this.a.getName();
    }

    public AlgorithmParameters getAlgParameters() {
        return this.a.getParameters();
    }

    public byte[] getEncryptedData() {
        return (byte[])this.b.clone();
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        byte[] byArray = null;
        try {
            byArray = cipher.doFinal(this.b);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeySpecException(illegalBlockSizeException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeySpecException(badPaddingException.toString());
        }
        return new PKCS8EncodedKeySpec(byArray);
    }

    public byte[] getEncoded() throws IOException {
        if (this.c != null) {
            return (byte[])this.c.clone();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.a.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write((byte)48, derOutputStream2);
        this.c = derOutputStream.toByteArray();
        return (byte[])this.c.clone();
    }
}

