/** 
 * Copyright (C) 1997-2002 the KGhostView authors. See file AUTHORS.
 * 	
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>

#include "messages.h"
#include "messages.moc"

#include <qaccel.h>
#include <qlayout.h>
#include <qstyle.h>

#include <klocale.h>
#include <kapplication.h>
#include <kbuttonbox.h>
#include <kglobalsettings.h>

MessagesDialog::MessagesDialog( QWidget *parent, const char *name )
	: QDialog( parent, name )
{
	setFocusPolicy(QWidget::StrongFocus);
	setCaption(i18n("Ghostscript Messages"));
	
	QBoxLayout *topLayout = new QVBoxLayout( this, 0, 10 );

	frame = new QFrame ( this );
	if ( style().inherits( "QWindowsStyle" ) ) {
		frame ->setFrameStyle( QFrame::WinPanel | QFrame::Sunken);
	} 
	else {
		frame ->setFrameStyle( QFrame::Panel | QFrame::Sunken);
   		frame ->setLineWidth(2);
	}
	
	topLayout->addWidget( frame, 10 );
	
	messageBox = new QMultiLineEdit( frame );
	messageBox->setFrameStyle( QFrame::NoFrame );
	messageBox->setFont( KGlobalSettings::fixedFont() );
	messageBox->setReadOnly( TRUE );
	
	QFontMetrics fm( KGlobalSettings::fixedFont() );
	frame->setMinimumWidth( 80*fm.width(" ") );
	
	// CREATE BUTTONS
	
	KButtonBox *bbox = new KButtonBox( this );
	bbox->addStretch( 10 );

	QPushButton* clear = bbox->addButton( i18n("&Clear") );
	connect( clear, SIGNAL(clicked()), SLOT(clear()) );

	cancel = bbox->addButton( i18n("&Dismiss") );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	bbox->layout();
	
	QBoxLayout *pushLayout = new QHBoxLayout( 10 );
	topLayout->addLayout( pushLayout, 0 );
	topLayout->addSpacing( 10 );
	
	pushLayout->addWidget( bbox, 0 );
	pushLayout->addSpacing( 10 );
	
	
	topLayout->activate();
	
	resize( 250, 250 );
}

void MessagesDialog::clear()
{
	messageBox->clear();
}

void MessagesDialog::resizeEvent( QResizeEvent * )
{
	messageBox->setGeometry( 2, 2, frame->width()-4, frame->height()-4 );
}


