/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmcomment.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"

#include "pmcommentedit.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>

PMComment::PMComment( )
      : Base( )
{
}

PMComment::PMComment( const QString& t )
   : Base( )
{
   m_text = t;
}

PMComment::~PMComment( )
{
}

QString PMComment::description( ) const
{
   return i18n( "comment" );
}

void PMComment::setText( const QString& text )
{
   if( text != m_text )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTComment, PMTextID, m_text );
      m_text = text;
   }
}

bool PMComment::isA( PMObjectType t ) const
{
   if( t == PMTComment )
      return true;
   return Base::isA( t );
}

void PMComment::serialize( PMOutputDevice& dev ) const
{
   dev.writeComment( m_text );
}

void PMComment::serialize( QDomElement& e, QDomDocument& doc ) const
{
   QDomText t = doc.createTextNode( m_text );
   e.appendChild( t );
}

void PMComment::readAttributes( const PMXMLHelper& h )
{
   QDomNode e = h.element( ).firstChild( );
   if( e.isText( ) )
      m_text = e.toText( ).data( );
}

PMDialogEditBase* PMComment::editWidget( QWidget* parent ) const
{
   return new PMCommentEdit( parent );
}

void PMComment::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTComment )
      {
         switch( data->valueID( ) )
         {
            case PMTextID:
               setText( data->stringData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMComment::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

