/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef KSIM_H
#define KSIM_H

#include <kmainwindow.h>
#include <kurl.h>

class QPopupMenu;

namespace KSim
{
  class MainView;
  class Dock;

  class MainWindow : public KMainWindow
  {
    Q_OBJECT
    public:
      MainWindow(const KURL::List &urlList = KURL::List(),
          QWidget *parent = 0, const char *name = 0);
      ~MainWindow();

    public slots:
      void loadPlugins(const KURL::List &);
      void contextMenu();
      virtual void show();
      void reparse();

    protected:
      bool queryClose();

    private slots:
      void showDock();

    private:
      void windowMenu(int);
      void initWidget(const KURL::List &urlList);

      KSim::MainView *m_view;
      KSim::Dock *m_dock;
      QPopupMenu *m_mainMenu;
      QPopupMenu *m_winMenu;
      int m_ontopItem;
      int m_desktopItem;
      int m_shownBefore;
  };
};
#endif // KSIM_H
