/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmvector.h"
#include "pmslope.h"
#include "pmslopeedit.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>

const double heightDefault = 0;
const double slopeDefault = 0;

PMSlope::PMSlope( )
      : Base( )
{
   m_height = heightDefault;
   m_slope = slopeDefault;
}

PMSlope::~PMSlope( )
{
}

QString PMSlope::description( ) const
{
   return i18n( "slope" );
}

void PMSlope::serialize( PMOutputDevice& dev ) const
{
   QString str1,str2;

   str1.setNum(m_height);
   str2.setNum(m_slope);

   dev.writeLine( "<" + str1 + ", " + str2 + ">" );
}

void PMSlope::serialize( QDomElement& e, QDomDocument& /*doc*/ ) const
{
   e.setAttribute( "height", m_height );
   e.setAttribute( "slope", m_slope );
}

void PMSlope::readAttributes( const PMXMLHelper& h )
{
   m_height = h.doubleAttribute( "height", heightDefault );
   m_slope = h.doubleAttribute( "slope", slopeDefault );
}

bool PMSlope::isA( PMObjectType t ) const
{
   if( t == PMTSlope )
      return true;
   return Base::isA( t );
}

void PMSlope::setHeight( const double c )
{
   if( c != m_height )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTSlope, PMHeightID, m_height );
      m_height = c;
   }
}

void PMSlope::setSlope( const double c )
{
   if( c != m_slope )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTSlope, PMSlopeID, m_slope );
      m_slope = c;
   }
}

PMDialogEditBase* PMSlope::editWidget( QWidget* parent ) const
{
   return new PMSlopeEdit( parent );
}

void PMSlope::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTSlope )
      {
         switch( data->valueID( ) )
         {
            case PMSlopeID:
               setSlope( data->doubleData( ) );
               break;
            case PMHeightID:
               setHeight( data->doubleData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMSlope::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
