/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef CATALOGSETTINGS_H
#define CATALOGSETTINGS_H

#include <qstring.h>
#include <qregexp.h>
#include <qdatetime.h>

class QTextCodec;
class QStringList;

enum FileEncoding{Locale,UTF8,UTF16};

enum CopyrightUpdate{Remove,Update,NoChange,RemoveLine};

struct SaveSettings
{
    bool autoUpdate;
    bool updateLastTranslator;
    bool updateRevisionDate;
    bool updateLanguageTeam;
    bool updateCharset;
    bool updateEncoding;
    
    bool updateProject;
    bool updateDescription;
    QString descriptionString;
    bool updateTranslatorCopyright;
    CopyrightUpdate FSFCopyright;

    FileEncoding encoding;
    bool useOldEncoding;

    Qt::DateFormat dateFormat;
    QString customDateFormat;
    
    QString projectString;

    bool autoSyntaxCheck;
    bool saveObsolete;
};

struct IdentitySettings
{
    QString authorName;
    QString authorLocalizedName;
    QString authorEmail;
    QString languageName;
    QString languageCode;
    QString mailingList;
    QString timeZone;

   /**
    * The number of plural forms. If <= 0 the number is determined
    * automatically.
    */
   int numberOfPluralForms;

};


struct MiscSettings
{
   /** 
    * The char, that marks keyboard accelerators.
    * Default is '&' as used by Qt
    */
   QChar accelMarker;
   
   /**
    * The regular expression for what is context information.
    * Default is "^_:.+" as used in KDE
    */ 
   QRegExp contextInfo;

   /** 
    * The regular expression for strings that contain a message for
    * singular and one for plural
    */
   QRegExp singularPlural;

  /**
   * The method used for compresion of email attachments. Use
   * tar/bzip2 if true, tar/gzip if false.
   * Default is true.
   */
  bool useBzip;

  /**
   * Use compression for single file attachments. 
   * Default is true.
   */
  bool compressSingleFile;
};

struct TagSettings
{
    /**
    * A list of regular expressions defining tags
    */
    QStringList expressions;
};

QString charsetString(FileEncoding);
QString charsetString(QTextCodec *codec);

namespace Defaults
{
   /**
   * this class contains or computes the defaults values of the
   * Save preferences
   */
   class Save
   {
    public:
       static const bool autoUpdate;
       static const bool updateLastTranslator;
       static const bool updateRevisionDate;
       static const bool updateLanguageTeam;
       static const bool updateCharset;
       static const bool updateEncoding;
       static const bool updateProject;
       static const bool updateTranslatorCopyright;
       static const bool updateDescription;
       
       static const CopyrightUpdate FSFCopyright;

       static const FileEncoding encoding;
       static const bool useOldEncoding;

       static const Qt::DateFormat dateFormat;

       static const bool autoSyntaxCheck;
       static const bool saveObsolete;

       static const QString customDateFormat();
       static const QString projectString();
       static const QString descriptionString();
   };

   class Identity
   {
    public:
       Identity();
       QString authorName();
       QString authorLocalizedName();
       QString authorEmail();
       QString languageName();
       QString languageCode();
       QString mailingList();
       QString timezone();

       const int numberOfPluralForms;

    private:
       QString _authorName;
       QString _authorLocalizedName;
       QString _authorEmail;
       QString _mailingList;
       QString _timezone;
       QString _languageName;
       QString _languageCode;
   };

   class Misc
   {
      public:
         QChar accelMarker();
         QRegExp contextInfo();
         QRegExp singularPlural();

	 static const bool useBzip;
	 static const bool compressSingleFile;
   };
   
   class Tag
   {
      public:
	 static QStringList expressions();
   };
}


#endif
