.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.TH man 1 "15/3/1994"
.LO 1
.SH NOME
man \- formatar e mostrar as pginas do manual on-line
.br
manpath \- determinar o manpath inicial para o utilizador
.SH SINOPSE
man [\-acdfhktw] [\-m sistema] [\-p string] [\-C fich_config] [\-M path]
[\-P paginador] [\-S lista_sec] [seco] nome ...
.SH DESCRIO
.B man
formata e mostra as pginas do manual `on-line'. Esta verso reconhece
as variveis de ambiente (environment)
.B MANPATH
e
.B (MAN)PAGER
(vr a seguir).
Se a
.I seco
for indicada,
.B man
apenas procura nessa seco de manuais.
Pode tambm indicar por que ordem das seces deve procurar 
e que preprocessamento efectuar nos manuais, por meio de opes na
linha de comando ou variveis de ambiente.
Se
.I nome
contiver uma / tentar primeiro o ficheiro com esse nome, permitindo
fazer
.B "man ./foo.5"
ou mesmo
.B "man /cd/foo/bar.1.gz"
para formatar e vr um ficheiro em particular.
.SH OPES
.TP
.B \-\^C " fich_config"
Indica o ficheiro de configurao a usar; por omisso ser usado
@man_config_file@. (Veja man.conf(5).)
.TP
.B \-\^M " path"
Indica a lista de directrios onde procurar manuais.
Sem esta opo, ser consultada a varivel
.B MANPATH.
Se tambm esta varivel estiver definida, uma lista ser obtida
por consulta de @man_config_file@. Um directrio vazio em MANPATH
representa a lista anterior.
.TP
.B \-\^P " paginador"
Indica qual o paginador/visualisador a usar. Sem esta opo tentar
consultar a varivel
.B PAGER.
Normalmente, man usar
.B @pager@.
.TP
.B \-\^S " lista_sec"
Fornece a lista de seces (separadas por ,) onde procurar e por que
ordem. Esta opo substitui o que  indicado pela varivel
.B MANSECT
quando esta est definida.
.TP
.B \-\^a
Normalmente man mostra o primeiro manual que encontrar. Esta opo
faz com que mostre todas as pginas de manuais encontradas para a entrada
.B nome. 
.TP
.B \-\^d
No mostra o manual, imprimindo vria informao para `debug'.
.TP
.B \-\^f
Equivalente a
.B whatis.
.TP
.B \-\^h
Imprime apenas uma mensagem de ajuda.
.TP
.B \-\^k
Equivalente a
.B apropos.
.TP
.B \-\^m " sistema"
Indica um conjunto de manuais diferente aplicveis ao sistema indicado.
.TP
.B \-\^p " string"
Especifica uma sequncia de preprocessadores a usar antes de nroff ou
troff (os formatadores). Algumas instalaes podem no ter todos os
preprocessadores. Alguns preprocessadores e as letras a usar para os
indicar so:
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Esta opo sobrepe-se  varivel
.B MANROFFSEQ.
.TP
.B \-\^t
Usar
.B @troff@
para formatar as pginas do manual. A sada deste comando
pode ter ainda de ser processada por outro antes de a poder
imprimir.
.TP
.B \-\^w \fRor\fP \-\-path
No imprime as pginas do manual, mas mostra a(s) localizao(es) dos
ficheiros a formatar e mostrar, para a entrada de
.B nome
indicado. Se no fornecer mais nenhuma opo mostra a lista de
directrios que sero percorridos por
.B man
nas suas buscas. Se
.B manpath
 um `link' para man, ento "manpath"  equivalente a "man --path".

.SH AMBIENTE
.TP \w'MANROFFSEQ\ \ 'u
.B MANPATH
Se
.B MANPATH
estiver definido, o seu valor ser usado como a lista de directrios
(manpath) onde podem estar entradas do manual.
.TP
.B MANROFFSEQ
Se
.B MANROFFSEQ
est definido, o seu valor determina os preprocessamentos a aplicar
antes de nroff ou troff. Normalmente, as pginas de manual, so
preprocessadas pelo tbl antes de nroff.
.TP
.B MANSECT
Se
.B MANSECT
existir, o seu valor indica as seces a percorrer.
.TP
.B PAGER
Se
.B PAGER
est definido, indicar o programa a usar para mostrar o manual.
Normalmente usar
.B @pager@.
.SH "VEJA TAMBM"
apropos(1), whatis(1), less(1), groff(1).
.SH BUGS
.B \-t
s funciona se existir o programa troff ou equivalente.
